"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _reactRelay = require("react-relay");

/* istanbul ignore file */
const mutation = function () {
  const node = require("./__generated__/resolveReviewThreadMutation.graphql");

  if (node.hash && node.hash !== "6947ef6710d494dc52fba1a5b532cd76") {
    console.error("The definition of 'resolveReviewThreadMutation' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/resolveReviewThreadMutation.graphql");
};

var _default = (environment, {
  threadID,
  viewerID,
  viewerLogin
}) => {
  const variables = {
    input: {
      threadId: threadID
    }
  };
  const optimisticResponse = {
    resolveReviewThread: {
      thread: {
        id: threadID,
        isResolved: true,
        viewerCanResolve: false,
        viewerCanUnresolve: true,
        resolvedBy: {
          id: viewerID,
          login: viewerLogin || 'you'
        }
      }
    }
  };
  return new Promise((resolve, reject) => {
    (0, _reactRelay.commitMutation)(environment, {
      mutation,
      variables,
      optimisticResponse,
      onCompleted: resolve,
      onError: reject
    });
  });
};

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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