"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _fsExtra = _interopRequireDefault(require("fs-extra"));

var _state = _interopRequireDefault(require("./state"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

/**
 * Git is asynchronously cloning a repository into this working directory.
 */
class Cloning extends _state["default"] {
  constructor(repository, remoteUrl) {
    super(repository);
    this.remoteUrl = remoteUrl;
  }

  async start() {
    await _fsExtra["default"].mkdirs(this.workdir());
    await this.doClone(this.remoteUrl, {
      recursive: true
    });
    await this.transitionTo('Loading');
  }

  showGitTabLoading() {
    return true;
  }

  directClone(remoteUrl, options) {
    return this.git().clone(remoteUrl, options);
  }

}

exports["default"] = Cloning;

_state["default"].register(Cloning);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNsb25pbmcuanMiXSwibmFtZXMiOlsiQ2xvbmluZyIsIlN0YXRlIiwiY29uc3RydWN0b3IiLCJyZXBvc2l0b3J5IiwicmVtb3RlVXJsIiwic3RhcnQiLCJmcyIsIm1rZGlycyIsIndvcmtkaXIiLCJkb0Nsb25lIiwicmVjdXJzaXZlIiwidHJhbnNpdGlvblRvIiwic2hvd0dpdFRhYkxvYWRpbmciLCJkaXJlY3RDbG9uZSIsIm9wdGlvbnMiLCJnaXQiLCJjbG9uZSIsInJlZ2lzdGVyIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7O0FBRUE7Ozs7QUFFQTs7O0FBR2UsTUFBTUEsT0FBTixTQUFzQkMsaUJBQXRCLENBQTRCO0FBQ3pDQyxFQUFBQSxXQUFXLENBQUNDLFVBQUQsRUFBYUMsU0FBYixFQUF3QjtBQUNqQyxVQUFNRCxVQUFOO0FBQ0EsU0FBS0MsU0FBTCxHQUFpQkEsU0FBakI7QUFDRDs7QUFFRCxRQUFNQyxLQUFOLEdBQWM7QUFDWixVQUFNQyxvQkFBR0MsTUFBSCxDQUFVLEtBQUtDLE9BQUwsRUFBVixDQUFOO0FBQ0EsVUFBTSxLQUFLQyxPQUFMLENBQWEsS0FBS0wsU0FBbEIsRUFBNkI7QUFBQ00sTUFBQUEsU0FBUyxFQUFFO0FBQVosS0FBN0IsQ0FBTjtBQUVBLFVBQU0sS0FBS0MsWUFBTCxDQUFrQixTQUFsQixDQUFOO0FBQ0Q7O0FBRURDLEVBQUFBLGlCQUFpQixHQUFHO0FBQ2xCLFdBQU8sSUFBUDtBQUNEOztBQUVEQyxFQUFBQSxXQUFXLENBQUNULFNBQUQsRUFBWVUsT0FBWixFQUFxQjtBQUM5QixXQUFPLEtBQUtDLEdBQUwsR0FBV0MsS0FBWCxDQUFpQlosU0FBakIsRUFBNEJVLE9BQTVCLENBQVA7QUFDRDs7QUFuQndDOzs7O0FBc0IzQ2Isa0JBQU1nQixRQUFOLENBQWVqQixPQUFmIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBmcyBmcm9tICdmcy1leHRyYSc7XG5cbmltcG9ydCBTdGF0ZSBmcm9tICcuL3N0YXRlJztcblxuLyoqXG4gKiBHaXQgaXMgYXN5bmNocm9ub3VzbHkgY2xvbmluZyBhIHJlcG9zaXRvcnkgaW50byB0aGlzIHdvcmtpbmcgZGlyZWN0b3J5LlxuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBDbG9uaW5nIGV4dGVuZHMgU3RhdGUge1xuICBjb25zdHJ1Y3RvcihyZXBvc2l0b3J5LCByZW1vdGVVcmwpIHtcbiAgICBzdXBlcihyZXBvc2l0b3J5KTtcbiAgICB0aGlzLnJlbW90ZVVybCA9IHJlbW90ZVVybDtcbiAgfVxuXG4gIGFzeW5jIHN0YXJ0KCkge1xuICAgIGF3YWl0IGZzLm1rZGlycyh0aGlzLndvcmtkaXIoKSk7XG4gICAgYXdhaXQgdGhpcy5kb0Nsb25lKHRoaXMucmVtb3RlVXJsLCB7cmVjdXJzaXZlOiB0cnVlfSk7XG5cbiAgICBhd2FpdCB0aGlzLnRyYW5zaXRpb25UbygnTG9hZGluZycpO1xuICB9XG5cbiAgc2hvd0dpdFRhYkxvYWRpbmcoKSB7XG4gICAgcmV0dXJuIHRydWU7XG4gIH1cblxuICBkaXJlY3RDbG9uZShyZW1vdGVVcmwsIG9wdGlvbnMpIHtcbiAgICByZXR1cm4gdGhpcy5naXQoKS5jbG9uZShyZW1vdGVVcmwsIG9wdGlvbnMpO1xuICB9XG59XG5cblN0YXRlLnJlZ2lzdGVyKENsb25pbmcpO1xuIl19