"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _remote = require("./remote");

var _helpers = require("../helpers");

class RemoteSet {
  constructor(iterable = []) {
    this.byName = new Map();
    this.byDotcomRepo = new Map();
    this.protocolCount = new Map();

    for (const remote of iterable) {
      this.add(remote);
    }
  }

  add(remote) {
    this.byName.set(remote.getName(), remote);

    if (remote.isGithubRepo()) {
      (0, _helpers.pushAtKey)(this.byDotcomRepo, remote.getSlug(), remote);
    }

    if (remote.getProtocol()) {
      const count = this.protocolCount.get(remote.getProtocol()) || 0;
      this.protocolCount.set(remote.getProtocol(), count + 1);
    }
  }

  isEmpty() {
    return this.byName.size === 0;
  }

  size() {
    return this.byName.size;
  }

  withName(name) {
    return this.byName.get(name) || _remote.nullRemote;
  }

  [Symbol.iterator]() {
    return this.byName.values();
  }

  filter(predicate) {
    return new this.constructor(Array.from(this).filter(predicate));
  }

  matchingGitHubRepository(owner, name) {
    return this.byDotcomRepo.get(`${owner}/${name}`) || [];
  }

  mostUsedProtocol(choices) {
    let best = choices[0];
    let bestCount = 0;

    for (const protocol of choices) {
      const count = this.protocolCount.get(protocol) || 0;

      if (count > bestCount) {
        bestCount = count;
        best = protocol;
      }
    }

    return best;
  }

}

exports["default"] = RemoteSet;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInJlbW90ZS1zZXQuanMiXSwibmFtZXMiOlsiUmVtb3RlU2V0IiwiY29uc3RydWN0b3IiLCJpdGVyYWJsZSIsImJ5TmFtZSIsIk1hcCIsImJ5RG90Y29tUmVwbyIsInByb3RvY29sQ291bnQiLCJyZW1vdGUiLCJhZGQiLCJzZXQiLCJnZXROYW1lIiwiaXNHaXRodWJSZXBvIiwiZ2V0U2x1ZyIsImdldFByb3RvY29sIiwiY291bnQiLCJnZXQiLCJpc0VtcHR5Iiwic2l6ZSIsIndpdGhOYW1lIiwibmFtZSIsIm51bGxSZW1vdGUiLCJTeW1ib2wiLCJpdGVyYXRvciIsInZhbHVlcyIsImZpbHRlciIsInByZWRpY2F0ZSIsIkFycmF5IiwiZnJvbSIsIm1hdGNoaW5nR2l0SHViUmVwb3NpdG9yeSIsIm93bmVyIiwibW9zdFVzZWRQcm90b2NvbCIsImNob2ljZXMiLCJiZXN0IiwiYmVzdENvdW50IiwicHJvdG9jb2wiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBQTs7QUFDQTs7QUFFZSxNQUFNQSxTQUFOLENBQWdCO0FBQzdCQyxFQUFBQSxXQUFXLENBQUNDLFFBQVEsR0FBRyxFQUFaLEVBQWdCO0FBQ3pCLFNBQUtDLE1BQUwsR0FBYyxJQUFJQyxHQUFKLEVBQWQ7QUFDQSxTQUFLQyxZQUFMLEdBQW9CLElBQUlELEdBQUosRUFBcEI7QUFDQSxTQUFLRSxhQUFMLEdBQXFCLElBQUlGLEdBQUosRUFBckI7O0FBQ0EsU0FBSyxNQUFNRyxNQUFYLElBQXFCTCxRQUFyQixFQUErQjtBQUM3QixXQUFLTSxHQUFMLENBQVNELE1BQVQ7QUFDRDtBQUNGOztBQUVEQyxFQUFBQSxHQUFHLENBQUNELE1BQUQsRUFBUztBQUNWLFNBQUtKLE1BQUwsQ0FBWU0sR0FBWixDQUFnQkYsTUFBTSxDQUFDRyxPQUFQLEVBQWhCLEVBQWtDSCxNQUFsQzs7QUFDQSxRQUFJQSxNQUFNLENBQUNJLFlBQVAsRUFBSixFQUEyQjtBQUN6Qiw4QkFBVSxLQUFLTixZQUFmLEVBQTZCRSxNQUFNLENBQUNLLE9BQVAsRUFBN0IsRUFBK0NMLE1BQS9DO0FBQ0Q7O0FBQ0QsUUFBSUEsTUFBTSxDQUFDTSxXQUFQLEVBQUosRUFBMEI7QUFDeEIsWUFBTUMsS0FBSyxHQUFHLEtBQUtSLGFBQUwsQ0FBbUJTLEdBQW5CLENBQXVCUixNQUFNLENBQUNNLFdBQVAsRUFBdkIsS0FBZ0QsQ0FBOUQ7QUFDQSxXQUFLUCxhQUFMLENBQW1CRyxHQUFuQixDQUF1QkYsTUFBTSxDQUFDTSxXQUFQLEVBQXZCLEVBQTZDQyxLQUFLLEdBQUcsQ0FBckQ7QUFDRDtBQUNGOztBQUVERSxFQUFBQSxPQUFPLEdBQUc7QUFDUixXQUFPLEtBQUtiLE1BQUwsQ0FBWWMsSUFBWixLQUFxQixDQUE1QjtBQUNEOztBQUVEQSxFQUFBQSxJQUFJLEdBQUc7QUFDTCxXQUFPLEtBQUtkLE1BQUwsQ0FBWWMsSUFBbkI7QUFDRDs7QUFFREMsRUFBQUEsUUFBUSxDQUFDQyxJQUFELEVBQU87QUFDYixXQUFPLEtBQUtoQixNQUFMLENBQVlZLEdBQVosQ0FBZ0JJLElBQWhCLEtBQXlCQyxrQkFBaEM7QUFDRDs7QUFFRCxHQUFDQyxNQUFNLENBQUNDLFFBQVIsSUFBb0I7QUFDbEIsV0FBTyxLQUFLbkIsTUFBTCxDQUFZb0IsTUFBWixFQUFQO0FBQ0Q7O0FBRURDLEVBQUFBLE1BQU0sQ0FBQ0MsU0FBRCxFQUFZO0FBQ2hCLFdBQU8sSUFBSSxLQUFLeEIsV0FBVCxDQUNMeUIsS0FBSyxDQUFDQyxJQUFOLENBQVcsSUFBWCxFQUFpQkgsTUFBakIsQ0FBd0JDLFNBQXhCLENBREssQ0FBUDtBQUdEOztBQUVERyxFQUFBQSx3QkFBd0IsQ0FBQ0MsS0FBRCxFQUFRVixJQUFSLEVBQWM7QUFDcEMsV0FBTyxLQUFLZCxZQUFMLENBQWtCVSxHQUFsQixDQUF1QixHQUFFYyxLQUFNLElBQUdWLElBQUssRUFBdkMsS0FBNkMsRUFBcEQ7QUFDRDs7QUFFRFcsRUFBQUEsZ0JBQWdCLENBQUNDLE9BQUQsRUFBVTtBQUN4QixRQUFJQyxJQUFJLEdBQUdELE9BQU8sQ0FBQyxDQUFELENBQWxCO0FBQ0EsUUFBSUUsU0FBUyxHQUFHLENBQWhCOztBQUNBLFNBQUssTUFBTUMsUUFBWCxJQUF1QkgsT0FBdkIsRUFBZ0M7QUFDOUIsWUFBTWpCLEtBQUssR0FBRyxLQUFLUixhQUFMLENBQW1CUyxHQUFuQixDQUF1Qm1CLFFBQXZCLEtBQW9DLENBQWxEOztBQUNBLFVBQUlwQixLQUFLLEdBQUdtQixTQUFaLEVBQXVCO0FBQ3JCQSxRQUFBQSxTQUFTLEdBQUduQixLQUFaO0FBQ0FrQixRQUFBQSxJQUFJLEdBQUdFLFFBQVA7QUFDRDtBQUNGOztBQUNELFdBQU9GLElBQVA7QUFDRDs7QUExRDRCIiwic291cmNlUm9vdCI6Ii9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2dpdGh1YiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7bnVsbFJlbW90ZX0gZnJvbSAnLi9yZW1vdGUnO1xuaW1wb3J0IHtwdXNoQXRLZXl9IGZyb20gJy4uL2hlbHBlcnMnO1xuXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBSZW1vdGVTZXQge1xuICBjb25zdHJ1Y3RvcihpdGVyYWJsZSA9IFtdKSB7XG4gICAgdGhpcy5ieU5hbWUgPSBuZXcgTWFwKCk7XG4gICAgdGhpcy5ieURvdGNvbVJlcG8gPSBuZXcgTWFwKCk7XG4gICAgdGhpcy5wcm90b2NvbENvdW50ID0gbmV3IE1hcCgpO1xuICAgIGZvciAoY29uc3QgcmVtb3RlIG9mIGl0ZXJhYmxlKSB7XG4gICAgICB0aGlzLmFkZChyZW1vdGUpO1xuICAgIH1cbiAgfVxuXG4gIGFkZChyZW1vdGUpIHtcbiAgICB0aGlzLmJ5TmFtZS5zZXQocmVtb3RlLmdldE5hbWUoKSwgcmVtb3RlKTtcbiAgICBpZiAocmVtb3RlLmlzR2l0aHViUmVwbygpKSB7XG4gICAgICBwdXNoQXRLZXkodGhpcy5ieURvdGNvbVJlcG8sIHJlbW90ZS5nZXRTbHVnKCksIHJlbW90ZSk7XG4gICAgfVxuICAgIGlmIChyZW1vdGUuZ2V0UHJvdG9jb2woKSkge1xuICAgICAgY29uc3QgY291bnQgPSB0aGlzLnByb3RvY29sQ291bnQuZ2V0KHJlbW90ZS5nZXRQcm90b2NvbCgpKSB8fCAwO1xuICAgICAgdGhpcy5wcm90b2NvbENvdW50LnNldChyZW1vdGUuZ2V0UHJvdG9jb2woKSwgY291bnQgKyAxKTtcbiAgICB9XG4gIH1cblxuICBpc0VtcHR5KCkge1xuICAgIHJldHVybiB0aGlzLmJ5TmFtZS5zaXplID09PSAwO1xuICB9XG5cbiAgc2l6ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5ieU5hbWUuc2l6ZTtcbiAgfVxuXG4gIHdpdGhOYW1lKG5hbWUpIHtcbiAgICByZXR1cm4gdGhpcy5ieU5hbWUuZ2V0KG5hbWUpIHx8IG51bGxSZW1vdGU7XG4gIH1cblxuICBbU3ltYm9sLml0ZXJhdG9yXSgpIHtcbiAgICByZXR1cm4gdGhpcy5ieU5hbWUudmFsdWVzKCk7XG4gIH1cblxuICBmaWx0ZXIocHJlZGljYXRlKSB7XG4gICAgcmV0dXJuIG5ldyB0aGlzLmNvbnN0cnVjdG9yKFxuICAgICAgQXJyYXkuZnJvbSh0aGlzKS5maWx0ZXIocHJlZGljYXRlKSxcbiAgICApO1xuICB9XG5cbiAgbWF0Y2hpbmdHaXRIdWJSZXBvc2l0b3J5KG93bmVyLCBuYW1lKSB7XG4gICAgcmV0dXJuIHRoaXMuYnlEb3Rjb21SZXBvLmdldChgJHtvd25lcn0vJHtuYW1lfWApIHx8IFtdO1xuICB9XG5cbiAgbW9zdFVzZWRQcm90b2NvbChjaG9pY2VzKSB7XG4gICAgbGV0IGJlc3QgPSBjaG9pY2VzWzBdO1xuICAgIGxldCBiZXN0Q291bnQgPSAwO1xuICAgIGZvciAoY29uc3QgcHJvdG9jb2wgb2YgY2hvaWNlcykge1xuICAgICAgY29uc3QgY291bnQgPSB0aGlzLnByb3RvY29sQ291bnQuZ2V0KHByb3RvY29sKSB8fCAwO1xuICAgICAgaWYgKGNvdW50ID4gYmVzdENvdW50KSB7XG4gICAgICAgIGJlc3RDb3VudCA9IGNvdW50O1xuICAgICAgICBiZXN0ID0gcHJvdG9jb2w7XG4gICAgICB9XG4gICAgfVxuICAgIHJldHVybiBiZXN0O1xuICB9XG59XG4iXX0=