"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filter = filter;
exports.MAX_PATCH_CHARS = void 0;
const MAX_PATCH_CHARS = 1024 * 1024;
exports.MAX_PATCH_CHARS = MAX_PATCH_CHARS;

function filter(original) {
  let accumulating = false;
  let accumulated = '';
  let includedChars = 0;
  const removed = new Set();
  const pathRx = /\n?diff --git (?:a|b)\/(\S+) (?:a|b)\/(\S+)/y;
  let index = 0;

  while (index !== -1) {
    let include = true;
    const result = original.indexOf('\ndiff --git ', index);
    const nextIndex = result !== -1 ? result + 1 : -1;
    const patchEnd = nextIndex !== -1 ? nextIndex : original.length; // Exclude this patch if its inclusion would cause the patch to become too large.

    const patchChars = patchEnd - index + 1;

    if (includedChars + patchChars > MAX_PATCH_CHARS) {
      include = false;
    }

    if (include) {
      // Avoid copying large buffers of text around if we're including everything anyway.
      if (accumulating) {
        accumulated += original.slice(index, patchEnd);
      }

      includedChars += patchChars;
    } else {
      // If this is the first excluded patch, start by copying everything before this into "accumulated."
      if (!accumulating) {
        accumulating = true;
        accumulated = original.slice(0, index);
      } // Extract the removed filenames from the "diff --git" line.


      pathRx.lastIndex = index;
      const pathMatch = pathRx.exec(original);

      if (pathMatch) {
        removed.add(pathMatch[1]);
        removed.add(pathMatch[2]);
      }
    }

    index = nextIndex;
  }

  return {
    filtered: accumulating ? accumulated : original,
    removed
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImZpbHRlci5qcyJdLCJuYW1lcyI6WyJNQVhfUEFUQ0hfQ0hBUlMiLCJmaWx0ZXIiLCJvcmlnaW5hbCIsImFjY3VtdWxhdGluZyIsImFjY3VtdWxhdGVkIiwiaW5jbHVkZWRDaGFycyIsInJlbW92ZWQiLCJTZXQiLCJwYXRoUngiLCJpbmRleCIsImluY2x1ZGUiLCJyZXN1bHQiLCJpbmRleE9mIiwibmV4dEluZGV4IiwicGF0Y2hFbmQiLCJsZW5ndGgiLCJwYXRjaENoYXJzIiwic2xpY2UiLCJsYXN0SW5kZXgiLCJwYXRoTWF0Y2giLCJleGVjIiwiYWRkIiwiZmlsdGVyZWQiXSwibWFwcGluZ3MiOiI7Ozs7Ozs7QUFBTyxNQUFNQSxlQUFlLEdBQUcsT0FBTyxJQUEvQjs7O0FBRUEsU0FBU0MsTUFBVCxDQUFnQkMsUUFBaEIsRUFBMEI7QUFDL0IsTUFBSUMsWUFBWSxHQUFHLEtBQW5CO0FBQ0EsTUFBSUMsV0FBVyxHQUFHLEVBQWxCO0FBQ0EsTUFBSUMsYUFBYSxHQUFHLENBQXBCO0FBQ0EsUUFBTUMsT0FBTyxHQUFHLElBQUlDLEdBQUosRUFBaEI7QUFDQSxRQUFNQyxNQUFNLEdBQUcsOENBQWY7QUFFQSxNQUFJQyxLQUFLLEdBQUcsQ0FBWjs7QUFDQSxTQUFPQSxLQUFLLEtBQUssQ0FBQyxDQUFsQixFQUFxQjtBQUNuQixRQUFJQyxPQUFPLEdBQUcsSUFBZDtBQUVBLFVBQU1DLE1BQU0sR0FBR1QsUUFBUSxDQUFDVSxPQUFULENBQWlCLGVBQWpCLEVBQWtDSCxLQUFsQyxDQUFmO0FBQ0EsVUFBTUksU0FBUyxHQUFHRixNQUFNLEtBQUssQ0FBQyxDQUFaLEdBQWdCQSxNQUFNLEdBQUcsQ0FBekIsR0FBNkIsQ0FBQyxDQUFoRDtBQUNBLFVBQU1HLFFBQVEsR0FBR0QsU0FBUyxLQUFLLENBQUMsQ0FBZixHQUFtQkEsU0FBbkIsR0FBK0JYLFFBQVEsQ0FBQ2EsTUFBekQsQ0FMbUIsQ0FPbkI7O0FBQ0EsVUFBTUMsVUFBVSxHQUFHRixRQUFRLEdBQUdMLEtBQVgsR0FBbUIsQ0FBdEM7O0FBQ0EsUUFBSUosYUFBYSxHQUFHVyxVQUFoQixHQUE2QmhCLGVBQWpDLEVBQWtEO0FBQ2hEVSxNQUFBQSxPQUFPLEdBQUcsS0FBVjtBQUNEOztBQUVELFFBQUlBLE9BQUosRUFBYTtBQUNYO0FBQ0EsVUFBSVAsWUFBSixFQUFrQjtBQUNoQkMsUUFBQUEsV0FBVyxJQUFJRixRQUFRLENBQUNlLEtBQVQsQ0FBZVIsS0FBZixFQUFzQkssUUFBdEIsQ0FBZjtBQUNEOztBQUNEVCxNQUFBQSxhQUFhLElBQUlXLFVBQWpCO0FBQ0QsS0FORCxNQU1PO0FBQ0w7QUFDQSxVQUFJLENBQUNiLFlBQUwsRUFBbUI7QUFDakJBLFFBQUFBLFlBQVksR0FBRyxJQUFmO0FBQ0FDLFFBQUFBLFdBQVcsR0FBR0YsUUFBUSxDQUFDZSxLQUFULENBQWUsQ0FBZixFQUFrQlIsS0FBbEIsQ0FBZDtBQUNELE9BTEksQ0FPTDs7O0FBQ0FELE1BQUFBLE1BQU0sQ0FBQ1UsU0FBUCxHQUFtQlQsS0FBbkI7QUFDQSxZQUFNVSxTQUFTLEdBQUdYLE1BQU0sQ0FBQ1ksSUFBUCxDQUFZbEIsUUFBWixDQUFsQjs7QUFDQSxVQUFJaUIsU0FBSixFQUFlO0FBQ2JiLFFBQUFBLE9BQU8sQ0FBQ2UsR0FBUixDQUFZRixTQUFTLENBQUMsQ0FBRCxDQUFyQjtBQUNBYixRQUFBQSxPQUFPLENBQUNlLEdBQVIsQ0FBWUYsU0FBUyxDQUFDLENBQUQsQ0FBckI7QUFDRDtBQUNGOztBQUVEVixJQUFBQSxLQUFLLEdBQUdJLFNBQVI7QUFDRDs7QUFFRCxTQUFPO0FBQUNTLElBQUFBLFFBQVEsRUFBRW5CLFlBQVksR0FBR0MsV0FBSCxHQUFpQkYsUUFBeEM7QUFBa0RJLElBQUFBO0FBQWxELEdBQVA7QUFDRCIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJleHBvcnQgY29uc3QgTUFYX1BBVENIX0NIQVJTID0gMTAyNCAqIDEwMjQ7XG5cbmV4cG9ydCBmdW5jdGlvbiBmaWx0ZXIob3JpZ2luYWwpIHtcbiAgbGV0IGFjY3VtdWxhdGluZyA9IGZhbHNlO1xuICBsZXQgYWNjdW11bGF0ZWQgPSAnJztcbiAgbGV0IGluY2x1ZGVkQ2hhcnMgPSAwO1xuICBjb25zdCByZW1vdmVkID0gbmV3IFNldCgpO1xuICBjb25zdCBwYXRoUnggPSAvXFxuP2RpZmYgLS1naXQgKD86YXxiKVxcLyhcXFMrKSAoPzphfGIpXFwvKFxcUyspL3k7XG5cbiAgbGV0IGluZGV4ID0gMDtcbiAgd2hpbGUgKGluZGV4ICE9PSAtMSkge1xuICAgIGxldCBpbmNsdWRlID0gdHJ1ZTtcblxuICAgIGNvbnN0IHJlc3VsdCA9IG9yaWdpbmFsLmluZGV4T2YoJ1xcbmRpZmYgLS1naXQgJywgaW5kZXgpO1xuICAgIGNvbnN0IG5leHRJbmRleCA9IHJlc3VsdCAhPT0gLTEgPyByZXN1bHQgKyAxIDogLTE7XG4gICAgY29uc3QgcGF0Y2hFbmQgPSBuZXh0SW5kZXggIT09IC0xID8gbmV4dEluZGV4IDogb3JpZ2luYWwubGVuZ3RoO1xuXG4gICAgLy8gRXhjbHVkZSB0aGlzIHBhdGNoIGlmIGl0cyBpbmNsdXNpb24gd291bGQgY2F1c2UgdGhlIHBhdGNoIHRvIGJlY29tZSB0b28gbGFyZ2UuXG4gICAgY29uc3QgcGF0Y2hDaGFycyA9IHBhdGNoRW5kIC0gaW5kZXggKyAxO1xuICAgIGlmIChpbmNsdWRlZENoYXJzICsgcGF0Y2hDaGFycyA+IE1BWF9QQVRDSF9DSEFSUykge1xuICAgICAgaW5jbHVkZSA9IGZhbHNlO1xuICAgIH1cblxuICAgIGlmIChpbmNsdWRlKSB7XG4gICAgICAvLyBBdm9pZCBjb3B5aW5nIGxhcmdlIGJ1ZmZlcnMgb2YgdGV4dCBhcm91bmQgaWYgd2UncmUgaW5jbHVkaW5nIGV2ZXJ5dGhpbmcgYW55d2F5LlxuICAgICAgaWYgKGFjY3VtdWxhdGluZykge1xuICAgICAgICBhY2N1bXVsYXRlZCArPSBvcmlnaW5hbC5zbGljZShpbmRleCwgcGF0Y2hFbmQpO1xuICAgICAgfVxuICAgICAgaW5jbHVkZWRDaGFycyArPSBwYXRjaENoYXJzO1xuICAgIH0gZWxzZSB7XG4gICAgICAvLyBJZiB0aGlzIGlzIHRoZSBmaXJzdCBleGNsdWRlZCBwYXRjaCwgc3RhcnQgYnkgY29weWluZyBldmVyeXRoaW5nIGJlZm9yZSB0aGlzIGludG8gXCJhY2N1bXVsYXRlZC5cIlxuICAgICAgaWYgKCFhY2N1bXVsYXRpbmcpIHtcbiAgICAgICAgYWNjdW11bGF0aW5nID0gdHJ1ZTtcbiAgICAgICAgYWNjdW11bGF0ZWQgPSBvcmlnaW5hbC5zbGljZSgwLCBpbmRleCk7XG4gICAgICB9XG5cbiAgICAgIC8vIEV4dHJhY3QgdGhlIHJlbW92ZWQgZmlsZW5hbWVzIGZyb20gdGhlIFwiZGlmZiAtLWdpdFwiIGxpbmUuXG4gICAgICBwYXRoUngubGFzdEluZGV4ID0gaW5kZXg7XG4gICAgICBjb25zdCBwYXRoTWF0Y2ggPSBwYXRoUnguZXhlYyhvcmlnaW5hbCk7XG4gICAgICBpZiAocGF0aE1hdGNoKSB7XG4gICAgICAgIHJlbW92ZWQuYWRkKHBhdGhNYXRjaFsxXSk7XG4gICAgICAgIHJlbW92ZWQuYWRkKHBhdGhNYXRjaFsyXSk7XG4gICAgICB9XG4gICAgfVxuXG4gICAgaW5kZXggPSBuZXh0SW5kZXg7XG4gIH1cblxuICByZXR1cm4ge2ZpbHRlcmVkOiBhY2N1bXVsYXRpbmcgPyBhY2N1bXVsYXRlZCA6IG9yaWdpbmFsLCByZW1vdmVkfTtcbn1cbiJdfQ==