"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nullAuthor = exports["default"] = exports.NO_REPLY_GITHUB_EMAIL = void 0;
const NEW = Symbol('new');
const NO_REPLY_GITHUB_EMAIL = 'noreply@github.com';
exports.NO_REPLY_GITHUB_EMAIL = NO_REPLY_GITHUB_EMAIL;

class Author {
  constructor(email, fullName, login = null, isNew = null) {
    this.email = email;
    this.fullName = fullName;
    this.login = login;
    this["new"] = isNew === NEW;
  }

  static createNew(email, fullName) {
    return new this(email, fullName, null, NEW);
  }

  getEmail() {
    return this.email;
  }

  getFullName() {
    return this.fullName;
  }

  getLogin() {
    return this.login;
  }

  isNoReply() {
    return this.email === NO_REPLY_GITHUB_EMAIL;
  }

  hasLogin() {
    return this.login !== null;
  }

  isNew() {
    return this["new"];
  }

  isPresent() {
    return true;
  }

  matches(other) {
    return this.getEmail() === other.getEmail();
  }

  toString() {
    let s = `${this.fullName} <${this.email}>`;

    if (this.hasLogin()) {
      s += ` @${this.login}`;
    }

    return s;
  }

  static compare(a, b) {
    if (a.getFullName() < b.getFullName()) {
      return -1;
    }

    if (a.getFullName() > b.getFullName()) {
      return 1;
    }

    return 0;
  }

}

exports["default"] = Author;
const nullAuthor = {
  getEmail() {
    return '';
  },

  getFullName() {
    return '';
  },

  getLogin() {
    return null;
  },

  isNoReply() {
    return false;
  },

  hasLogin() {
    return false;
  },

  isNew() {
    return false;
  },

  isPresent() {
    return false;
  },

  matches(other) {
    return other === this;
  },

  toString() {
    return 'null author';
  }

};
exports.nullAuthor = nullAuthor;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImF1dGhvci5qcyJdLCJuYW1lcyI6WyJORVciLCJTeW1ib2wiLCJOT19SRVBMWV9HSVRIVUJfRU1BSUwiLCJBdXRob3IiLCJjb25zdHJ1Y3RvciIsImVtYWlsIiwiZnVsbE5hbWUiLCJsb2dpbiIsImlzTmV3IiwiY3JlYXRlTmV3IiwiZ2V0RW1haWwiLCJnZXRGdWxsTmFtZSIsImdldExvZ2luIiwiaXNOb1JlcGx5IiwiaGFzTG9naW4iLCJpc1ByZXNlbnQiLCJtYXRjaGVzIiwib3RoZXIiLCJ0b1N0cmluZyIsInMiLCJjb21wYXJlIiwiYSIsImIiLCJudWxsQXV0aG9yIl0sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSxNQUFNQSxHQUFHLEdBQUdDLE1BQU0sQ0FBQyxLQUFELENBQWxCO0FBRU8sTUFBTUMscUJBQXFCLEdBQUcsb0JBQTlCOzs7QUFFUSxNQUFNQyxNQUFOLENBQWE7QUFDMUJDLEVBQUFBLFdBQVcsQ0FBQ0MsS0FBRCxFQUFRQyxRQUFSLEVBQWtCQyxLQUFLLEdBQUcsSUFBMUIsRUFBZ0NDLEtBQUssR0FBRyxJQUF4QyxFQUE4QztBQUN2RCxTQUFLSCxLQUFMLEdBQWFBLEtBQWI7QUFDQSxTQUFLQyxRQUFMLEdBQWdCQSxRQUFoQjtBQUNBLFNBQUtDLEtBQUwsR0FBYUEsS0FBYjtBQUNBLGtCQUFXQyxLQUFLLEtBQUtSLEdBQXJCO0FBQ0Q7O0FBRUQsU0FBT1MsU0FBUCxDQUFpQkosS0FBakIsRUFBd0JDLFFBQXhCLEVBQWtDO0FBQ2hDLFdBQU8sSUFBSSxJQUFKLENBQVNELEtBQVQsRUFBZ0JDLFFBQWhCLEVBQTBCLElBQTFCLEVBQWdDTixHQUFoQyxDQUFQO0FBQ0Q7O0FBRURVLEVBQUFBLFFBQVEsR0FBRztBQUNULFdBQU8sS0FBS0wsS0FBWjtBQUNEOztBQUVETSxFQUFBQSxXQUFXLEdBQUc7QUFDWixXQUFPLEtBQUtMLFFBQVo7QUFDRDs7QUFFRE0sRUFBQUEsUUFBUSxHQUFHO0FBQ1QsV0FBTyxLQUFLTCxLQUFaO0FBQ0Q7O0FBRURNLEVBQUFBLFNBQVMsR0FBRztBQUNWLFdBQU8sS0FBS1IsS0FBTCxLQUFlSCxxQkFBdEI7QUFDRDs7QUFFRFksRUFBQUEsUUFBUSxHQUFHO0FBQ1QsV0FBTyxLQUFLUCxLQUFMLEtBQWUsSUFBdEI7QUFDRDs7QUFFREMsRUFBQUEsS0FBSyxHQUFHO0FBQ04sV0FBTyxXQUFQO0FBQ0Q7O0FBRURPLEVBQUFBLFNBQVMsR0FBRztBQUNWLFdBQU8sSUFBUDtBQUNEOztBQUVEQyxFQUFBQSxPQUFPLENBQUNDLEtBQUQsRUFBUTtBQUNiLFdBQU8sS0FBS1AsUUFBTCxPQUFvQk8sS0FBSyxDQUFDUCxRQUFOLEVBQTNCO0FBQ0Q7O0FBRURRLEVBQUFBLFFBQVEsR0FBRztBQUNULFFBQUlDLENBQUMsR0FBSSxHQUFFLEtBQUtiLFFBQVMsS0FBSSxLQUFLRCxLQUFNLEdBQXhDOztBQUNBLFFBQUksS0FBS1MsUUFBTCxFQUFKLEVBQXFCO0FBQ25CSyxNQUFBQSxDQUFDLElBQUssS0FBSSxLQUFLWixLQUFNLEVBQXJCO0FBQ0Q7O0FBQ0QsV0FBT1ksQ0FBUDtBQUNEOztBQUVELFNBQU9DLE9BQVAsQ0FBZUMsQ0FBZixFQUFrQkMsQ0FBbEIsRUFBcUI7QUFDbkIsUUFBSUQsQ0FBQyxDQUFDVixXQUFGLEtBQWtCVyxDQUFDLENBQUNYLFdBQUYsRUFBdEIsRUFBdUM7QUFBRSxhQUFPLENBQUMsQ0FBUjtBQUFZOztBQUNyRCxRQUFJVSxDQUFDLENBQUNWLFdBQUYsS0FBa0JXLENBQUMsQ0FBQ1gsV0FBRixFQUF0QixFQUF1QztBQUFFLGFBQU8sQ0FBUDtBQUFXOztBQUNwRCxXQUFPLENBQVA7QUFDRDs7QUF4RHlCOzs7QUEyRHJCLE1BQU1ZLFVBQVUsR0FBRztBQUN4QmIsRUFBQUEsUUFBUSxHQUFHO0FBQ1QsV0FBTyxFQUFQO0FBQ0QsR0FIdUI7O0FBS3hCQyxFQUFBQSxXQUFXLEdBQUc7QUFDWixXQUFPLEVBQVA7QUFDRCxHQVB1Qjs7QUFTeEJDLEVBQUFBLFFBQVEsR0FBRztBQUNULFdBQU8sSUFBUDtBQUNELEdBWHVCOztBQWF4QkMsRUFBQUEsU0FBUyxHQUFHO0FBQ1YsV0FBTyxLQUFQO0FBQ0QsR0FmdUI7O0FBaUJ4QkMsRUFBQUEsUUFBUSxHQUFHO0FBQ1QsV0FBTyxLQUFQO0FBQ0QsR0FuQnVCOztBQXFCeEJOLEVBQUFBLEtBQUssR0FBRztBQUNOLFdBQU8sS0FBUDtBQUNELEdBdkJ1Qjs7QUF5QnhCTyxFQUFBQSxTQUFTLEdBQUc7QUFDVixXQUFPLEtBQVA7QUFDRCxHQTNCdUI7O0FBNkJ4QkMsRUFBQUEsT0FBTyxDQUFDQyxLQUFELEVBQVE7QUFDYixXQUFPQSxLQUFLLEtBQUssSUFBakI7QUFDRCxHQS9CdUI7O0FBaUN4QkMsRUFBQUEsUUFBUSxHQUFHO0FBQ1QsV0FBTyxhQUFQO0FBQ0Q7O0FBbkN1QixDQUFuQiIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJjb25zdCBORVcgPSBTeW1ib2woJ25ldycpO1xuXG5leHBvcnQgY29uc3QgTk9fUkVQTFlfR0lUSFVCX0VNQUlMID0gJ25vcmVwbHlAZ2l0aHViLmNvbSc7XG5cbmV4cG9ydCBkZWZhdWx0IGNsYXNzIEF1dGhvciB7XG4gIGNvbnN0cnVjdG9yKGVtYWlsLCBmdWxsTmFtZSwgbG9naW4gPSBudWxsLCBpc05ldyA9IG51bGwpIHtcbiAgICB0aGlzLmVtYWlsID0gZW1haWw7XG4gICAgdGhpcy5mdWxsTmFtZSA9IGZ1bGxOYW1lO1xuICAgIHRoaXMubG9naW4gPSBsb2dpbjtcbiAgICB0aGlzLm5ldyA9IGlzTmV3ID09PSBORVc7XG4gIH1cblxuICBzdGF0aWMgY3JlYXRlTmV3KGVtYWlsLCBmdWxsTmFtZSkge1xuICAgIHJldHVybiBuZXcgdGhpcyhlbWFpbCwgZnVsbE5hbWUsIG51bGwsIE5FVyk7XG4gIH1cblxuICBnZXRFbWFpbCgpIHtcbiAgICByZXR1cm4gdGhpcy5lbWFpbDtcbiAgfVxuXG4gIGdldEZ1bGxOYW1lKCkge1xuICAgIHJldHVybiB0aGlzLmZ1bGxOYW1lO1xuICB9XG5cbiAgZ2V0TG9naW4oKSB7XG4gICAgcmV0dXJuIHRoaXMubG9naW47XG4gIH1cblxuICBpc05vUmVwbHkoKSB7XG4gICAgcmV0dXJuIHRoaXMuZW1haWwgPT09IE5PX1JFUExZX0dJVEhVQl9FTUFJTDtcbiAgfVxuXG4gIGhhc0xvZ2luKCkge1xuICAgIHJldHVybiB0aGlzLmxvZ2luICE9PSBudWxsO1xuICB9XG5cbiAgaXNOZXcoKSB7XG4gICAgcmV0dXJuIHRoaXMubmV3O1xuICB9XG5cbiAgaXNQcmVzZW50KCkge1xuICAgIHJldHVybiB0cnVlO1xuICB9XG5cbiAgbWF0Y2hlcyhvdGhlcikge1xuICAgIHJldHVybiB0aGlzLmdldEVtYWlsKCkgPT09IG90aGVyLmdldEVtYWlsKCk7XG4gIH1cblxuICB0b1N0cmluZygpIHtcbiAgICBsZXQgcyA9IGAke3RoaXMuZnVsbE5hbWV9IDwke3RoaXMuZW1haWx9PmA7XG4gICAgaWYgKHRoaXMuaGFzTG9naW4oKSkge1xuICAgICAgcyArPSBgIEAke3RoaXMubG9naW59YDtcbiAgICB9XG4gICAgcmV0dXJuIHM7XG4gIH1cblxuICBzdGF0aWMgY29tcGFyZShhLCBiKSB7XG4gICAgaWYgKGEuZ2V0RnVsbE5hbWUoKSA8IGIuZ2V0RnVsbE5hbWUoKSkgeyByZXR1cm4gLTE7IH1cbiAgICBpZiAoYS5nZXRGdWxsTmFtZSgpID4gYi5nZXRGdWxsTmFtZSgpKSB7IHJldHVybiAxOyB9XG4gICAgcmV0dXJuIDA7XG4gIH1cbn1cblxuZXhwb3J0IGNvbnN0IG51bGxBdXRob3IgPSB7XG4gIGdldEVtYWlsKCkge1xuICAgIHJldHVybiAnJztcbiAgfSxcblxuICBnZXRGdWxsTmFtZSgpIHtcbiAgICByZXR1cm4gJyc7XG4gIH0sXG5cbiAgZ2V0TG9naW4oKSB7XG4gICAgcmV0dXJuIG51bGw7XG4gIH0sXG5cbiAgaXNOb1JlcGx5KCkge1xuICAgIHJldHVybiBmYWxzZTtcbiAgfSxcblxuICBoYXNMb2dpbigpIHtcbiAgICByZXR1cm4gZmFsc2U7XG4gIH0sXG5cbiAgaXNOZXcoKSB7XG4gICAgcmV0dXJuIGZhbHNlO1xuICB9LFxuXG4gIGlzUHJlc2VudCgpIHtcbiAgICByZXR1cm4gZmFsc2U7XG4gIH0sXG5cbiAgbWF0Y2hlcyhvdGhlcikge1xuICAgIHJldHVybiBvdGhlciA9PT0gdGhpcztcbiAgfSxcblxuICB0b1N0cmluZygpIHtcbiAgICByZXR1cm4gJ251bGwgYXV0aG9yJztcbiAgfSxcbn07XG4iXX0=