"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _repository = _interopRequireDefault(require("../models/repository"));

var _endpoint = require("../models/endpoint");

var _reviewsContainer = _interopRequireDefault(require("../containers/reviews-container"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ReviewsItem extends _react["default"].Component {
  static buildURI({
    host,
    owner,
    repo,
    number,
    workdir
  }) {
    return 'atom-github://reviews/' + encodeURIComponent(host) + '/' + encodeURIComponent(owner) + '/' + encodeURIComponent(repo) + '/' + encodeURIComponent(number) + '?workdir=' + encodeURIComponent(workdir || '');
  }

  constructor(props) {
    super(props);
    this.emitter = new _eventKit.Emitter();
    this.isDestroyed = false;
    this.state = {
      initThreadID: null
    };
  }

  render() {
    const endpoint = (0, _endpoint.getEndpoint)(this.props.host);
    const repository = this.props.workdir.length > 0 ? this.props.workdirContextPool.add(this.props.workdir).getRepository() : _repository["default"].absent();
    return _react["default"].createElement(_reviewsContainer["default"], _extends({
      endpoint: endpoint,
      repository: repository,
      initThreadID: this.state.initThreadID
    }, this.props));
  }

  getTitle() {
    return `Reviews #${this.props.number}`;
  }

  getDefaultLocation() {
    return 'right';
  }

  getPreferredWidth() {
    return 400;
  }

  destroy() {
    /* istanbul ignore else */
    if (!this.isDestroyed) {
      this.emitter.emit('did-destroy');
      this.isDestroyed = true;
    }
  }

  onDidDestroy(callback) {
    return this.emitter.on('did-destroy', callback);
  }

  serialize() {
    return {
      deserializer: 'ReviewsStub',
      uri: ReviewsItem.buildURI({
        host: this.props.host,
        owner: this.props.owner,
        repo: this.props.repo,
        number: this.props.number,
        workdir: this.props.workdir
      })
    };
  }

  async jumpToThread(id) {
    if (this.state.initThreadID === id) {
      await new Promise(resolve => this.setState({
        initThreadID: null
      }, resolve));
    }

    return new Promise(resolve => this.setState({
      initThreadID: id
    }, resolve));
  }

}

exports["default"] = ReviewsItem;

_defineProperty(ReviewsItem, "propTypes", {
  // Parsed from URI
  host: _propTypes["default"].string.isRequired,
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  number: _propTypes["default"].number.isRequired,
  workdir: _propTypes["default"].string.isRequired,
  // Package models
  workdirContextPool: _propTypes2.WorkdirContextPoolPropType.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  confirm: _propTypes["default"].func.isRequired,
  // Action methods
  reportRelayError: _propTypes["default"].func.isRequired
});

_defineProperty(ReviewsItem, "uriPattern", 'atom-github://reviews/{host}/{owner}/{repo}/{number}?workdir={workdir}');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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