"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

var _changedFileContainer = _interopRequireDefault(require("../containers/changed-file-container"));

var _refHolder = _interopRequireDefault(require("../models/ref-holder"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ChangedFileItem extends _react["default"].Component {
  static buildURI(relPath, workingDirectory, stagingStatus) {
    return 'atom-github://file-patch/' + encodeURIComponent(relPath) + `?workdir=${encodeURIComponent(workingDirectory)}` + `&stagingStatus=${encodeURIComponent(stagingStatus)}`;
  }

  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'destroy');
    this.emitter = new _eventKit.Emitter();
    this.isDestroyed = false;
    this.hasTerminatedPendingState = false;
    this.refEditor = new _refHolder["default"]();
    this.refEditor.observe(editor => {
      if (editor.isAlive()) {
        this.emitter.emit('did-change-embedded-text-editor', editor);
      }
    });
  }

  getTitle() {
    let title = this.props.stagingStatus === 'staged' ? 'Staged' : 'Unstaged';
    title += ' Changes: ';
    title += this.props.relPath;
    return title;
  }

  terminatePendingState() {
    if (!this.hasTerminatedPendingState) {
      this.emitter.emit('did-terminate-pending-state');
      this.hasTerminatedPendingState = true;
    }
  }

  onDidTerminatePendingState(callback) {
    return this.emitter.on('did-terminate-pending-state', callback);
  }

  destroy() {
    /* istanbul ignore else */
    if (!this.isDestroyed) {
      this.emitter.emit('did-destroy');
      this.isDestroyed = true;
    }
  }

  onDidDestroy(callback) {
    return this.emitter.on('did-destroy', callback);
  }

  render() {
    const repository = this.props.workdirContextPool.getContext(this.props.workingDirectory).getRepository();
    return _react["default"].createElement(_changedFileContainer["default"], _extends({
      itemType: this.constructor,
      repository: repository,
      destroy: this.destroy,
      refEditor: this.refEditor
    }, this.props));
  }

  observeEmbeddedTextEditor(cb) {
    this.refEditor.map(editor => editor.isAlive() && cb(editor));
    return this.emitter.on('did-change-embedded-text-editor', cb);
  }

  serialize() {
    return {
      deserializer: 'FilePatchControllerStub',
      uri: ChangedFileItem.buildURI(this.props.relPath, this.props.workingDirectory, this.props.stagingStatus)
    };
  }

  getStagingStatus() {
    return this.props.stagingStatus;
  }

  getFilePath() {
    return this.props.relPath;
  }

  getWorkingDirectory() {
    return this.props.workingDirectory;
  }

  isFilePatchItem() {
    return true;
  }

}

exports["default"] = ChangedFileItem;

_defineProperty(ChangedFileItem, "propTypes", {
  workdirContextPool: _propTypes2.WorkdirContextPoolPropType.isRequired,
  relPath: _propTypes["default"].string.isRequired,
  workingDirectory: _propTypes["default"].string.isRequired,
  stagingStatus: _propTypes["default"].oneOf(['staged', 'unstaged']),
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  keymaps: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  discardLines: _propTypes["default"].func.isRequired,
  undoLastDiscard: _propTypes["default"].func.isRequired,
  surfaceFileAtPath: _propTypes["default"].func.isRequired
});

_defineProperty(ChangedFileItem, "uriPattern", 'atom-github://file-patch/{relPath...}?workdir={workingDirectory}&stagingStatus={stagingStatus}');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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