"use strict";

var _githubPackage = _interopRequireDefault(require("./github-package"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

let pack;
const entry = {
  initialize() {
    pack = new _githubPackage["default"]({
      workspace: atom.workspace,
      project: atom.project,
      commands: atom.commands,
      notificationManager: atom.notifications,
      tooltips: atom.tooltips,
      styles: atom.styles,
      keymaps: atom.keymaps,
      grammars: atom.grammars,
      config: atom.config,
      deserializers: atom.deserializers,
      confirm: atom.confirm.bind(atom),
      getLoadSettings: atom.getLoadSettings.bind(atom),
      configDirPath: atom.getConfigDirPath()
    });
  }

};
module.exports = new Proxy(entry, {
  get(target, name) {
    if (pack && Reflect.has(pack, name)) {
      let item = pack[name];

      if (typeof item === 'function') {
        item = item.bind(pack);
      }

      return item;
    } else {
      return target[name];
    }
  }

});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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