"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _net = _interopRequireDefault(require("net"));

var _eventKit = require("event-kit");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

class GitPromptServer {
  constructor(gitTempDir) {
    this.emitter = new _eventKit.Emitter();
    this.gitTempDir = gitTempDir;
  }

  async start(promptForInput) {
    this.promptForInput = promptForInput;
    await this.gitTempDir.ensure();
    this.server = await this.startListening(this.gitTempDir.getSocketPath());
  }

  startListening(socketPath) {
    return new Promise(resolve => {
      const server = _net["default"].createServer(connection => {
        connection.setEncoding('utf8');
        const parts = [];
        connection.on('data', data => {
          const nullIndex = data.indexOf('\u0000');

          if (nullIndex === -1) {
            parts.push(data);
          } else {
            parts.push(data.substring(0, nullIndex));
            this.handleData(connection, parts.join(''));
          }
        });
      });

      server.listen(socketPath, () => resolve(server));
    });
  }

  handleData(connection, data) {
    let query;

    try {
      query = JSON.parse(data);
    } catch (e) {
      this.emitter.emit('did-cancel');
    }

    Promise.resolve(this.promptForInput(query)).then(answer => connection.end(JSON.stringify(answer), 'utf-8'))["catch"](() => this.emitter.emit('did-cancel', {
      handlerPid: query.pid
    }));
  }

  onDidCancel(cb) {
    return this.emitter.on('did-cancel', cb);
  }

  async terminate() {
    await new Promise(resolve => this.server.close(resolve));
    this.emitter.dispose();
  }

}

exports["default"] = GitPromptServer;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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