"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareReviewsController = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _propTypes2 = require("../prop-types");

var _reviewsView = _interopRequireDefault(require("../views/reviews-view"));

var _prCheckoutController = _interopRequireDefault(require("../controllers/pr-checkout-controller"));

var _addPrReview = _interopRequireDefault(require("../mutations/add-pr-review"));

var _addPrReviewComment = _interopRequireDefault(require("../mutations/add-pr-review-comment"));

var _submitPrReview = _interopRequireDefault(require("../mutations/submit-pr-review"));

var _deletePrReview = _interopRequireDefault(require("../mutations/delete-pr-review"));

var _resolveReviewThread = _interopRequireDefault(require("../mutations/resolve-review-thread"));

var _unresolveReviewThread = _interopRequireDefault(require("../mutations/unresolve-review-thread"));

var _updatePrReviewComment = _interopRequireDefault(require("../mutations/update-pr-review-comment"));

var _updatePrReviewSummary = _interopRequireDefault(require("../mutations/update-pr-review-summary"));

var _issueishDetailItem = _interopRequireDefault(require("../items/issueish-detail-item"));

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Milliseconds to update highlightedThreadIDs
const FLASH_DELAY = 1500;

class BareReviewsController extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "openFile", async (filePath, lineNumber) => {
      await this.props.workspace.open(filePath, {
        initialLine: lineNumber - 1,
        initialColumn: 0,
        pending: true
      });
      (0, _reporterProxy.addEvent)('reviews-dock-open-file', {
        "package": 'github'
      });
    });

    _defineProperty(this, "openDiff", async (filePath, lineNumber) => {
      const item = await this.getPRDetailItem();
      item.openFilesTab({
        changedFilePath: filePath,
        changedFilePosition: lineNumber
      });
      (0, _reporterProxy.addEvent)('reviews-dock-open-diff', {
        "package": 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "openPR", async () => {
      await this.getPRDetailItem();
      (0, _reporterProxy.addEvent)('reviews-dock-open-pr', {
        "package": 'github',
        component: this.constructor.name
      });
    });

    _defineProperty(this, "getPRDetailItem", () => {
      return this.props.workspace.open(_issueishDetailItem["default"].buildURI({
        host: this.props.endpoint.getHost(),
        owner: this.props.owner,
        repo: this.props.repo,
        number: this.props.number,
        workdir: this.props.workdir
      }), {
        pending: true,
        searchAllPanes: true
      });
    });

    _defineProperty(this, "moreContext", () => {
      this.setState(prev => ({
        contextLines: prev.contextLines + 1
      }));
      (0, _reporterProxy.addEvent)('reviews-dock-show-more-context', {
        "package": 'github'
      });
    });

    _defineProperty(this, "lessContext", () => {
      this.setState(prev => ({
        contextLines: Math.max(prev.contextLines - 1, 1)
      }));
      (0, _reporterProxy.addEvent)('reviews-dock-show-less-context', {
        "package": 'github'
      });
    });

    _defineProperty(this, "openIssueish", async (owner, repo, number) => {
      const host = this.props.endpoint.getHost();
      const homeRepository = (await this.props.localRepository.hasGitHubRemote(host, owner, repo)) ? this.props.localRepository : (await this.props.workdirContextPool.getMatchingContext(host, owner, repo)).getRepository();

      const uri = _issueishDetailItem["default"].buildURI({
        host,
        owner,
        repo,
        number,
        workdir: homeRepository.getWorkingDirectoryPath()
      });

      return this.props.workspace.open(uri, {
        pending: true,
        searchAllPanes: true
      });
    });

    _defineProperty(this, "showSummaries", () => new Promise(resolve => this.setState({
      summarySectionOpen: true
    }, resolve)));

    _defineProperty(this, "hideSummaries", () => new Promise(resolve => this.setState({
      summarySectionOpen: false
    }, resolve)));

    _defineProperty(this, "showComments", () => new Promise(resolve => this.setState({
      commentSectionOpen: true
    }, resolve)));

    _defineProperty(this, "hideComments", () => new Promise(resolve => this.setState({
      commentSectionOpen: false
    }, resolve)));

    _defineProperty(this, "showThreadID", commentID => new Promise(resolve => this.setState(state => {
      state.threadIDsOpen.add(commentID);
      return {};
    }, resolve)));

    _defineProperty(this, "hideThreadID", commentID => new Promise(resolve => this.setState(state => {
      state.threadIDsOpen["delete"](commentID);
      return {};
    }, resolve)));

    _defineProperty(this, "highlightThread", threadID => {
      this.setState(state => {
        state.highlightedThreadIDs.add(threadID);
        return {};
      }, () => {
        setTimeout(() => this.setState(state => {
          state.highlightedThreadIDs["delete"](threadID);

          if (state.scrollToThreadID === threadID) {
            return {
              scrollToThreadID: null
            };
          }

          return {};
        }), FLASH_DELAY);
      });
    });

    _defineProperty(this, "resolveThread", async thread => {
      if (thread.viewerCanResolve) {
        // optimistically hide the thread to avoid jankiness;
        // if the operation fails, the onError callback will revert it.
        this.hideThreadID(thread.id);

        try {
          await (0, _resolveReviewThread["default"])(this.props.relay.environment, {
            threadID: thread.id,
            viewerID: this.props.viewer.id,
            viewerLogin: this.props.viewer.login
          });
          this.highlightThread(thread.id);
          (0, _reporterProxy.addEvent)('resolve-comment-thread', {
            "package": 'github'
          });
        } catch (err) {
          this.showThreadID(thread.id);
          this.props.reportRelayError('Unable to resolve the comment thread', err);
        }
      }
    });

    _defineProperty(this, "unresolveThread", async thread => {
      if (thread.viewerCanUnresolve) {
        try {
          await (0, _unresolveReviewThread["default"])(this.props.relay.environment, {
            threadID: thread.id,
            viewerID: this.props.viewer.id,
            viewerLogin: this.props.viewer.login
          });
          this.highlightThread(thread.id);
          (0, _reporterProxy.addEvent)('unresolve-comment-thread', {
            "package": 'github'
          });
        } catch (err) {
          this.props.reportRelayError('Unable to unresolve the comment thread', err);
        }
      }
    });

    _defineProperty(this, "addSingleComment", async (commentBody, threadID, replyToID, path, position, callbacks = {}) => {
      let pendingReviewID = null;

      try {
        this.setState({
          postingToThreadID: threadID
        });
        const reviewResult = await (0, _addPrReview["default"])(this.props.relay.environment, {
          pullRequestID: this.props.pullRequest.id,
          viewerID: this.props.viewer.id
        });
        const reviewID = reviewResult.addPullRequestReview.reviewEdge.node.id;
        pendingReviewID = reviewID;
        const commentPromise = (0, _addPrReviewComment["default"])(this.props.relay.environment, {
          body: commentBody,
          inReplyTo: replyToID,
          reviewID,
          threadID,
          viewerID: this.props.viewer.id,
          path,
          position
        });

        if (callbacks.didSubmitComment) {
          callbacks.didSubmitComment();
        }

        await commentPromise;
        pendingReviewID = null;
        await (0, _submitPrReview["default"])(this.props.relay.environment, {
          event: 'COMMENT',
          reviewID
        });
        (0, _reporterProxy.addEvent)('add-single-comment', {
          "package": 'github'
        });
      } catch (error) {
        if (callbacks.didFailComment) {
          callbacks.didFailComment();
        }

        if (pendingReviewID !== null) {
          try {
            await (0, _deletePrReview["default"])(this.props.relay.environment, {
              reviewID: pendingReviewID,
              pullRequestID: this.props.pullRequest.id
            });
          } catch (e) {
            /* istanbul ignore else */
            if (error.errors && e.errors) {
              error.errors.push(...e.errors);
            } else {
              // eslint-disable-next-line no-console
              console.warn('Unable to delete pending review', e);
            }
          }
        }

        this.props.reportRelayError('Unable to submit your comment', error);
      } finally {
        this.setState({
          postingToThreadID: null
        });
      }
    });

    _defineProperty(this, "updateComment", async (commentId, commentBody) => {
      try {
        await (0, _updatePrReviewComment["default"])(this.props.relay.environment, {
          commentId,
          commentBody
        });
        (0, _reporterProxy.addEvent)('update-review-comment', {
          "package": 'github'
        });
      } catch (error) {
        this.props.reportRelayError('Unable to update comment', error);
        throw error;
      }
    });

    _defineProperty(this, "updateSummary", async (reviewId, reviewBody) => {
      try {
        await (0, _updatePrReviewSummary["default"])(this.props.relay.environment, {
          reviewId,
          reviewBody
        });
        (0, _reporterProxy.addEvent)('update-review-summary', {
          "package": 'github'
        });
      } catch (error) {
        this.props.reportRelayError('Unable to update review summary', error);
        throw error;
      }
    });

    this.state = {
      contextLines: 4,
      postingToThreadID: null,
      scrollToThreadID: this.props.initThreadID,
      summarySectionOpen: true,
      commentSectionOpen: true,
      threadIDsOpen: new Set(this.props.initThreadID ? [this.props.initThreadID] : []),
      highlightedThreadIDs: new Set()
    };
  }

  componentDidMount() {
    const {
      scrollToThreadID
    } = this.state;

    if (scrollToThreadID) {
      this.highlightThread(scrollToThreadID);
    }
  }

  componentDidUpdate(prevProps) {
    const {
      initThreadID
    } = this.props;

    if (initThreadID && initThreadID !== prevProps.initThreadID) {
      this.setState(prev => {
        prev.threadIDsOpen.add(initThreadID);
        this.highlightThread(initThreadID);
        return {
          commentSectionOpen: true,
          scrollToThreadID: initThreadID
        };
      });
    }
  }

  render() {
    return _react["default"].createElement(_prCheckoutController["default"], {
      repository: this.props.repository,
      pullRequest: this.props.pullRequest,
      localRepository: this.props.localRepository,
      isAbsent: this.props.isAbsent,
      isLoading: this.props.isLoading,
      isPresent: this.props.isPresent,
      isMerging: this.props.isMerging,
      isRebasing: this.props.isRebasing,
      branches: this.props.branches,
      remotes: this.props.remotes
    }, checkoutOp => _react["default"].createElement(_reviewsView["default"], _extends({
      checkoutOp: checkoutOp,
      contextLines: this.state.contextLines,
      postingToThreadID: this.state.postingToThreadID,
      summarySectionOpen: this.state.summarySectionOpen,
      commentSectionOpen: this.state.commentSectionOpen,
      threadIDsOpen: this.state.threadIDsOpen,
      highlightedThreadIDs: this.state.highlightedThreadIDs,
      scrollToThreadID: this.state.scrollToThreadID,
      moreContext: this.moreContext,
      lessContext: this.lessContext,
      openFile: this.openFile,
      openDiff: this.openDiff,
      openPR: this.openPR,
      openIssueish: this.openIssueish,
      showSummaries: this.showSummaries,
      hideSummaries: this.hideSummaries,
      showComments: this.showComments,
      hideComments: this.hideComments,
      showThreadID: this.showThreadID,
      hideThreadID: this.hideThreadID,
      resolveThread: this.resolveThread,
      unresolveThread: this.unresolveThread,
      addSingleComment: this.addSingleComment,
      updateComment: this.updateComment,
      updateSummary: this.updateSummary
    }, this.props)));
  }

}

exports.BareReviewsController = BareReviewsController;

_defineProperty(BareReviewsController, "propTypes", {
  // Relay results
  relay: _propTypes["default"].shape({
    environment: _propTypes["default"].object.isRequired
  }).isRequired,
  viewer: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired
  }).isRequired,
  repository: _propTypes["default"].object.isRequired,
  pullRequest: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired
  }).isRequired,
  summaries: _propTypes["default"].array.isRequired,
  commentThreads: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    thread: _propTypes["default"].object.isRequired,
    comments: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired
  })),
  refetch: _propTypes["default"].func.isRequired,
  // Package models
  workdirContextPool: _propTypes2.WorkdirContextPoolPropType.isRequired,
  localRepository: _propTypes["default"].object.isRequired,
  isAbsent: _propTypes["default"].bool.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  isPresent: _propTypes["default"].bool.isRequired,
  isMerging: _propTypes["default"].bool.isRequired,
  isRebasing: _propTypes["default"].bool.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  multiFilePatch: _propTypes["default"].object.isRequired,
  initThreadID: _propTypes["default"].string,
  // Connection properties
  endpoint: _propTypes2.EndpointPropType.isRequired,
  // URL parameters
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  number: _propTypes["default"].number.isRequired,
  workdir: _propTypes["default"].string.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  confirm: _propTypes["default"].func.isRequired,
  // Action methods
  reportRelayError: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createFragmentContainer)(BareReviewsController, {
  viewer: function () {
    const node = require("./__generated__/reviewsController_viewer.graphql");

    if (node.hash && node.hash !== "e9e4cf88f2d8a809620a0f225d502896") {
      console.error("The definition of 'reviewsController_viewer' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/reviewsController_viewer.graphql");
  },
  repository: function () {
    const node = require("./__generated__/reviewsController_repository.graphql");

    if (node.hash && node.hash !== "1e0016aed6db6035651ff6213eb38ff6") {
      console.error("The definition of 'reviewsController_repository' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/reviewsController_repository.graphql");
  },
  pullRequest: function () {
    const node = require("./__generated__/reviewsController_pullRequest.graphql");

    if (node.hash && node.hash !== "9d67f9908ab4ed776af5f1ee14f61ccb") {
      console.error("The definition of 'reviewsController_pullRequest' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/reviewsController_pullRequest.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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