"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _electron = require("electron");

var _helpers = require("../helpers");

var _reporterProxy = require("../reporter-proxy");

var _propTypes2 = require("../prop-types");

var _issueishSearchesController = _interopRequireDefault(require("./issueish-searches-controller"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class RemoteController extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'onCreatePr');
  }

  render() {
    return _react["default"].createElement(_issueishSearchesController["default"], {
      endpoint: this.props.endpoint,
      token: this.props.token,
      remoteOperationObserver: this.props.remoteOperationObserver,
      workingDirectory: this.props.workingDirectory,
      repository: this.props.repository,
      workspace: this.props.workspace,
      remote: this.props.remote,
      remotes: this.props.remotes,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      onCreatePr: this.onCreatePr
    });
  }

  async onCreatePr() {
    const currentBranch = this.props.branches.getHeadBranch();
    const upstream = currentBranch.getUpstream();

    if (!upstream.isPresent() || this.props.aheadCount > 0) {
      await this.props.onPushBranch();
    }

    let createPrUrl = 'https://github.com/';
    createPrUrl += this.props.remote.getOwner() + '/' + this.props.remote.getRepo();
    createPrUrl += '/compare/' + encodeURIComponent(currentBranch.getName());
    createPrUrl += '?expand=1';
    return new Promise((resolve, reject) => {
      _electron.shell.openExternal(createPrUrl, {}, err => {
        if (err) {
          reject(err);
        } else {
          (0, _reporterProxy.incrementCounter)('create-pull-request');
          resolve();
        }
      });
    });
  }

}

exports["default"] = RemoteController;

_defineProperty(RemoteController, "propTypes", {
  // Relay payload
  repository: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired,
    defaultBranchRef: _propTypes["default"].shape({
      prefix: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired
    })
  }),
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Repository derived attributes
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  workingDirectory: _propTypes["default"].string,
  workspace: _propTypes["default"].object.isRequired,
  remote: _propTypes2.RemotePropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes["default"].number,
  pushInProgress: _propTypes["default"].bool.isRequired,
  // Actions
  onPushBranch: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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