"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareIssueishListController = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _propTypes2 = require("../prop-types");

var _issueishListView = _interopRequireDefault(require("../views/issueish-list-view"));

var _issueish = _interopRequireDefault(require("../models/issueish"));

var _electron = require("electron");

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

const {
  Menu,
  MenuItem
} = _electron.remote;

const StatePropType = _propTypes["default"].oneOf(['EXPECTED', 'PENDING', 'SUCCESS', 'ERROR', 'FAILURE']);

class BareIssueishListController extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "openOnGitHub", url => {
      return new Promise((resolve, reject) => {
        _electron.shell.openExternal(url, {}, err => {
          if (err) {
            reject(err);
          } else {
            resolve();
            (0, _reporterProxy.addEvent)('open-issueish-in-browser', {
              "package": 'github',
              component: this.constructor.name
            });
          }
        });
      });
    });

    _defineProperty(this, "showActionsMenu",
    /* istanbul ignore next */
    issueish => {
      const menu = new Menu();
      menu.append(new MenuItem({
        label: 'See reviews',
        click: () => this.props.onOpenReviews(issueish)
      }));
      menu.append(new MenuItem({
        label: 'Open on GitHub',
        click: () => this.openOnGitHub(issueish.getGitHubURL())
      }));
      menu.popup(_electron.remote.getCurrentWindow());
    });

    this.state = {};
  }

  static getDerivedStateFromProps(props, state) {
    if (props.results === null) {
      return {
        lastResults: null,
        issueishes: []
      };
    }

    if (props.results !== state.lastResults) {
      return {
        lastResults: props.results,
        issueishes: props.results.map(node => new _issueish["default"](node)).filter(props.resultFilter)
      };
    }

    return null;
  }

  render() {
    return _react["default"].createElement(_issueishListView["default"], {
      title: this.props.title,
      isLoading: this.props.isLoading,
      total: this.props.total,
      issueishes: this.state.issueishes,
      error: this.props.error,
      needReviewsButton: this.props.needReviewsButton,
      onIssueishClick: this.props.onOpenIssueish,
      onMoreClick: this.props.onOpenMore,
      openReviews: this.props.onOpenReviews,
      openOnGitHub: this.openOnGitHub,
      showActionsMenu: this.showActionsMenu,
      emptyComponent: this.props.emptyComponent
    });
  }

}

exports.BareIssueishListController = BareIssueishListController;

_defineProperty(BareIssueishListController, "propTypes", {
  results: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    number: _propTypes["default"].number.isRequired,
    title: _propTypes["default"].string.isRequired,
    url: _propTypes["default"].string.isRequired,
    author: _propTypes["default"].shape({
      login: _propTypes["default"].string.isRequired,
      avatarUrl: _propTypes["default"].string.isRequired
    }),
    createdAt: _propTypes["default"].string.isRequired,
    headRefName: _propTypes["default"].string.isRequired,
    repository: _propTypes["default"].shape({
      id: _propTypes["default"].string.isRequired,
      name: _propTypes["default"].string.isRequired,
      owner: _propTypes["default"].shape({
        login: _propTypes["default"].string.isRequired
      }).isRequired
    }).isRequired,
    commits: _propTypes["default"].shape({
      nodes: _propTypes["default"].arrayOf(_propTypes["default"].shape({
        commit: _propTypes["default"].shape({
          status: _propTypes["default"].shape({
            contexts: _propTypes["default"].arrayOf(_propTypes["default"].shape({
              state: StatePropType.isRequired
            }).isRequired).isRequired
          })
        })
      }))
    })
  })),
  total: _propTypes["default"].number.isRequired,
  isLoading: _propTypes["default"].bool.isRequired,
  title: _propTypes["default"].string.isRequired,
  error: _propTypes["default"].object,
  resultFilter: _propTypes["default"].func,
  onOpenIssueish: _propTypes["default"].func.isRequired,
  onOpenReviews: _propTypes["default"].func.isRequired,
  onOpenMore: _propTypes["default"].func,
  emptyComponent: _propTypes["default"].func,
  workspace: _propTypes["default"].object,
  endpoint: _propTypes2.EndpointPropType,
  needReviewsButton: _propTypes["default"].bool
});

_defineProperty(BareIssueishListController, "defaultProps", {
  results: [],
  total: 0,
  resultFilter: () => true
});

var _default = (0, _reactRelay.createFragmentContainer)(BareIssueishListController, {
  results: function () {
    const node = require("./__generated__/issueishListController_results.graphql");

    if (node.hash && node.hash !== "af31b5400d8cce5026fc1bb3fc42dc91") {
      console.error("The definition of 'issueishListController_results' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/issueishListController_results.graphql");
  }
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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