"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _atom = require("atom");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _decoration = _interopRequireDefault(require("../atom/decoration"));

var _marker = _interopRequireDefault(require("../atom/marker"));

var _reviewsItem = _interopRequireDefault(require("../items/reviews-item"));

var _reporterProxy = require("../reporter-proxy");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class CommentGutterDecorationController extends _react["default"].Component {
  render() {
    const range = _atom.Range.fromObject([[this.props.commentRow, 0], [this.props.commentRow, Infinity]]);

    return _react["default"].createElement(_marker["default"], {
      key: `github-comment-gutter-decoration-${this.props.threadId}`,
      editor: this.props.editor,
      exclusive: true,
      invalidate: "surround",
      bufferRange: range
    }, _react["default"].createElement(_decoration["default"], {
      editor: this.props.editor,
      type: "gutter",
      gutterName: "github-comment-icon",
      className: `github-editorCommentGutterIcon ${this.props.extraClasses.join(' ')}`,
      omitEmptyLastRow: false
    }, _react["default"].createElement("button", {
      className: "icon icon-comment",
      onClick: () => this.openReviewThread(this.props.threadId)
    })));
  }

  async openReviewThread(threadId) {
    const uri = _reviewsItem["default"].buildURI({
      host: this.props.endpoint.getHost(),
      owner: this.props.owner,
      repo: this.props.repo,
      number: this.props.number,
      workdir: this.props.workdir
    });

    const reviewsItem = await this.props.workspace.open(uri, {
      searchAllPanes: true
    });
    reviewsItem.jumpToThread(threadId);
    (0, _reporterProxy.addEvent)('open-review-thread', {
      "package": 'github',
      from: this.props.parent
    });
  }

}

exports["default"] = CommentGutterDecorationController;

_defineProperty(CommentGutterDecorationController, "propTypes", {
  commentRow: _propTypes["default"].number.isRequired,
  threadId: _propTypes["default"].string.isRequired,
  extraClasses: _propTypes["default"].array,
  workspace: _propTypes["default"].object.isRequired,
  endpoint: _propTypes2.EndpointPropType.isRequired,
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  number: _propTypes["default"].number.isRequired,
  workdir: _propTypes["default"].string.isRequired,
  editor: _propTypes["default"].object,
  // For metric reporting
  parent: _propTypes["default"].string.isRequired
});

_defineProperty(CommentGutterDecorationController, "defaultProps", {
  extraClasses: []
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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