"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ContextMenuInterceptor extends _react["default"].Component {
  static handle(event) {
    for (const [element, callback] of ContextMenuInterceptor.registration) {
      if (element.contains(event.target)) {
        callback(event);
      }
    }
  }

  static dispose() {
    document.removeEventListener('contextmenu', contextMenuHandler, {
      capture: true
    });
  }

  componentDidMount() {
    // Helpfully, addEventListener dedupes listeners for us.
    document.addEventListener('contextmenu', contextMenuHandler, {
      capture: true
    });
    ContextMenuInterceptor.registration.set(this.element, (...args) => this.props.onWillShowContextMenu(...args));
  }

  render() {
    return _react["default"].createElement("div", {
      ref: e => {
        this.element = e;
      }
    }, this.props.children);
  }

  componentWillUnmount() {
    ContextMenuInterceptor.registration["delete"](this.element);
  }

}

exports["default"] = ContextMenuInterceptor;

_defineProperty(ContextMenuInterceptor, "propTypes", {
  onWillShowContextMenu: _propTypes["default"].func.isRequired,
  children: _propTypes["default"].element.isRequired
});

_defineProperty(ContextMenuInterceptor, "registration", new Map());

function contextMenuHandler(event) {
  ContextMenuInterceptor.handle(event);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNvbnRleHQtbWVudS1pbnRlcmNlcHRvci5qcyJdLCJuYW1lcyI6WyJDb250ZXh0TWVudUludGVyY2VwdG9yIiwiUmVhY3QiLCJDb21wb25lbnQiLCJoYW5kbGUiLCJldmVudCIsImVsZW1lbnQiLCJjYWxsYmFjayIsInJlZ2lzdHJhdGlvbiIsImNvbnRhaW5zIiwidGFyZ2V0IiwiZGlzcG9zZSIsImRvY3VtZW50IiwicmVtb3ZlRXZlbnRMaXN0ZW5lciIsImNvbnRleHRNZW51SGFuZGxlciIsImNhcHR1cmUiLCJjb21wb25lbnREaWRNb3VudCIsImFkZEV2ZW50TGlzdGVuZXIiLCJzZXQiLCJhcmdzIiwicHJvcHMiLCJvbldpbGxTaG93Q29udGV4dE1lbnUiLCJyZW5kZXIiLCJlIiwiY2hpbGRyZW4iLCJjb21wb25lbnRXaWxsVW5tb3VudCIsIlByb3BUeXBlcyIsImZ1bmMiLCJpc1JlcXVpcmVkIiwiTWFwIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBQUE7O0FBQ0E7Ozs7OztBQUVlLE1BQU1BLHNCQUFOLFNBQXFDQyxrQkFBTUMsU0FBM0MsQ0FBcUQ7QUFRbEUsU0FBT0MsTUFBUCxDQUFjQyxLQUFkLEVBQXFCO0FBQ25CLFNBQUssTUFBTSxDQUFDQyxPQUFELEVBQVVDLFFBQVYsQ0FBWCxJQUFrQ04sc0JBQXNCLENBQUNPLFlBQXpELEVBQXVFO0FBQ3JFLFVBQUlGLE9BQU8sQ0FBQ0csUUFBUixDQUFpQkosS0FBSyxDQUFDSyxNQUF2QixDQUFKLEVBQW9DO0FBQ2xDSCxRQUFBQSxRQUFRLENBQUNGLEtBQUQsQ0FBUjtBQUNEO0FBQ0Y7QUFDRjs7QUFFRCxTQUFPTSxPQUFQLEdBQWlCO0FBQ2ZDLElBQUFBLFFBQVEsQ0FBQ0MsbUJBQVQsQ0FBNkIsYUFBN0IsRUFBNENDLGtCQUE1QyxFQUFnRTtBQUFDQyxNQUFBQSxPQUFPLEVBQUU7QUFBVixLQUFoRTtBQUNEOztBQUVEQyxFQUFBQSxpQkFBaUIsR0FBRztBQUNsQjtBQUNBSixJQUFBQSxRQUFRLENBQUNLLGdCQUFULENBQTBCLGFBQTFCLEVBQXlDSCxrQkFBekMsRUFBNkQ7QUFBQ0MsTUFBQUEsT0FBTyxFQUFFO0FBQVYsS0FBN0Q7QUFDQWQsSUFBQUEsc0JBQXNCLENBQUNPLFlBQXZCLENBQW9DVSxHQUFwQyxDQUF3QyxLQUFLWixPQUE3QyxFQUFzRCxDQUFDLEdBQUdhLElBQUosS0FBYSxLQUFLQyxLQUFMLENBQVdDLHFCQUFYLENBQWlDLEdBQUdGLElBQXBDLENBQW5FO0FBQ0Q7O0FBRURHLEVBQUFBLE1BQU0sR0FBRztBQUNQLFdBQU87QUFBSyxNQUFBLEdBQUcsRUFBRUMsQ0FBQyxJQUFJO0FBQUUsYUFBS2pCLE9BQUwsR0FBZWlCLENBQWY7QUFBbUI7QUFBcEMsT0FBdUMsS0FBS0gsS0FBTCxDQUFXSSxRQUFsRCxDQUFQO0FBQ0Q7O0FBRURDLEVBQUFBLG9CQUFvQixHQUFHO0FBQ3JCeEIsSUFBQUEsc0JBQXNCLENBQUNPLFlBQXZCLFdBQTJDLEtBQUtGLE9BQWhEO0FBQ0Q7O0FBaENpRTs7OztnQkFBL0NMLHNCLGVBQ0E7QUFDakJvQixFQUFBQSxxQkFBcUIsRUFBRUssc0JBQVVDLElBQVYsQ0FBZUMsVUFEckI7QUFFakJKLEVBQUFBLFFBQVEsRUFBRUUsc0JBQVVwQixPQUFWLENBQWtCc0I7QUFGWCxDOztnQkFEQTNCLHNCLGtCQU1HLElBQUk0QixHQUFKLEU7O0FBNkJ4QixTQUFTZixrQkFBVCxDQUE0QlQsS0FBNUIsRUFBbUM7QUFDakNKLEVBQUFBLHNCQUFzQixDQUFDRyxNQUF2QixDQUE4QkMsS0FBOUI7QUFDRCIsInNvdXJjZVJvb3QiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9naXRodWIiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgUmVhY3QgZnJvbSAncmVhY3QnO1xuaW1wb3J0IFByb3BUeXBlcyBmcm9tICdwcm9wLXR5cGVzJztcblxuZXhwb3J0IGRlZmF1bHQgY2xhc3MgQ29udGV4dE1lbnVJbnRlcmNlcHRvciBleHRlbmRzIFJlYWN0LkNvbXBvbmVudCB7XG4gIHN0YXRpYyBwcm9wVHlwZXMgPSB7XG4gICAgb25XaWxsU2hvd0NvbnRleHRNZW51OiBQcm9wVHlwZXMuZnVuYy5pc1JlcXVpcmVkLFxuICAgIGNoaWxkcmVuOiBQcm9wVHlwZXMuZWxlbWVudC5pc1JlcXVpcmVkLFxuICB9XG5cbiAgc3RhdGljIHJlZ2lzdHJhdGlvbiA9IG5ldyBNYXAoKVxuXG4gIHN0YXRpYyBoYW5kbGUoZXZlbnQpIHtcbiAgICBmb3IgKGNvbnN0IFtlbGVtZW50LCBjYWxsYmFja10gb2YgQ29udGV4dE1lbnVJbnRlcmNlcHRvci5yZWdpc3RyYXRpb24pIHtcbiAgICAgIGlmIChlbGVtZW50LmNvbnRhaW5zKGV2ZW50LnRhcmdldCkpIHtcbiAgICAgICAgY2FsbGJhY2soZXZlbnQpO1xuICAgICAgfVxuICAgIH1cbiAgfVxuXG4gIHN0YXRpYyBkaXNwb3NlKCkge1xuICAgIGRvY3VtZW50LnJlbW92ZUV2ZW50TGlzdGVuZXIoJ2NvbnRleHRtZW51JywgY29udGV4dE1lbnVIYW5kbGVyLCB7Y2FwdHVyZTogdHJ1ZX0pO1xuICB9XG5cbiAgY29tcG9uZW50RGlkTW91bnQoKSB7XG4gICAgLy8gSGVscGZ1bGx5LCBhZGRFdmVudExpc3RlbmVyIGRlZHVwZXMgbGlzdGVuZXJzIGZvciB1cy5cbiAgICBkb2N1bWVudC5hZGRFdmVudExpc3RlbmVyKCdjb250ZXh0bWVudScsIGNvbnRleHRNZW51SGFuZGxlciwge2NhcHR1cmU6IHRydWV9KTtcbiAgICBDb250ZXh0TWVudUludGVyY2VwdG9yLnJlZ2lzdHJhdGlvbi5zZXQodGhpcy5lbGVtZW50LCAoLi4uYXJncykgPT4gdGhpcy5wcm9wcy5vbldpbGxTaG93Q29udGV4dE1lbnUoLi4uYXJncykpO1xuICB9XG5cbiAgcmVuZGVyKCkge1xuICAgIHJldHVybiA8ZGl2IHJlZj17ZSA9PiB7IHRoaXMuZWxlbWVudCA9IGU7IH19Pnt0aGlzLnByb3BzLmNoaWxkcmVufTwvZGl2PjtcbiAgfVxuXG4gIGNvbXBvbmVudFdpbGxVbm1vdW50KCkge1xuICAgIENvbnRleHRNZW51SW50ZXJjZXB0b3IucmVnaXN0cmF0aW9uLmRlbGV0ZSh0aGlzLmVsZW1lbnQpO1xuICB9XG59XG5cbmZ1bmN0aW9uIGNvbnRleHRNZW51SGFuZGxlcihldmVudCkge1xuICBDb250ZXh0TWVudUludGVyY2VwdG9yLmhhbmRsZShldmVudCk7XG59XG4iXX0=