"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _reactRelay = require("react-relay");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

var _keytarStrategy = require("../shared/keytar-strategy");

var _prPatchContainer = _interopRequireDefault(require("./pr-patch-container"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _loadingView = _interopRequireDefault(require("../views/loading-view"));

var _githubLoginView = _interopRequireDefault(require("../views/github-login-view"));

var _errorView = _interopRequireDefault(require("../views/error-view"));

var _queryErrorView = _interopRequireDefault(require("../views/query-error-view"));

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _relayEnvironment = _interopRequireDefault(require("../views/relay-environment"));

var _reviewsController = _interopRequireDefault(require("../controllers/reviews-controller"));

var _aggregatedReviewsContainer = _interopRequireDefault(require("./aggregated-reviews-container"));

var _commentPositioningContainer = _interopRequireDefault(require("./comment-positioning-container"));

var _graphql;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class ReviewsContainer extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "renderWithToken", token => {
      if (!token) {
        return _react["default"].createElement(_loadingView["default"], null);
      }

      if (token instanceof Error) {
        return _react["default"].createElement(_queryErrorView["default"], {
          error: token,
          retry: this.handleTokenRetry,
          login: this.handleLogin,
          logout: this.handleLogout
        });
      }

      if (token === _keytarStrategy.UNAUTHENTICATED) {
        return _react["default"].createElement(_githubLoginView["default"], {
          onLogin: this.handleLogin
        });
      }

      if (token === _keytarStrategy.INSUFFICIENT) {
        return _react["default"].createElement(_githubLoginView["default"], {
          onLogin: this.handleLogin
        }, _react["default"].createElement("p", null, "Your token no longer has sufficient authorizations. Please re-authenticate and generate a new one."));
      }

      return _react["default"].createElement(_prPatchContainer["default"], {
        owner: this.props.owner,
        repo: this.props.repo,
        number: this.props.number,
        endpoint: this.props.endpoint,
        token: token,
        largeDiffThreshold: Infinity
      }, (error, patch) => this.renderWithPatch(error, {
        token,
        patch
      }));
    });

    _defineProperty(this, "fetchToken", loginModel => loginModel.getToken(this.props.endpoint.getLoginAccount()));

    _defineProperty(this, "fetchRepositoryData", repository => {
      return (0, _yubikiri["default"])({
        branches: repository.getBranches(),
        remotes: repository.getRemotes(),
        isAbsent: repository.isAbsent(),
        isLoading: repository.isLoading(),
        isPresent: repository.isPresent(),
        isMerging: repository.isMerging(),
        isRebasing: repository.isRebasing()
      });
    });

    _defineProperty(this, "handleLogin", token => this.props.loginModel.setToken(this.props.endpoint.getLoginAccount(), token));

    _defineProperty(this, "handleLogout", () => this.props.loginModel.removeToken(this.props.endpoint.getLoginAccount()));

    _defineProperty(this, "handleTokenRetry", () => this.props.loginModel.didUpdate());
  }

  render() {
    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.loginModel,
      fetchData: this.fetchToken
    }, this.renderWithToken);
  }

  renderWithPatch(error, {
    token,
    patch
  }) {
    if (error) {
      return _react["default"].createElement(_errorView["default"], {
        descriptions: [error]
      });
    }

    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.repository,
      fetchData: this.fetchRepositoryData
    }, repoData => this.renderWithRepositoryData(repoData, {
      token,
      patch
    }));
  }

  renderWithRepositoryData(repoData, {
    token,
    patch
  }) {
    const environment = _relayNetworkLayerManager["default"].getEnvironmentForHost(this.props.endpoint, token);

    const query = _graphql || (_graphql = function () {
      const node = require("./__generated__/reviewsContainerQuery.graphql");

      if (node.hash && node.hash !== "b05cc30cb078003afba9bd8c2de989fa") {
        console.error("The definition of 'reviewsContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
      }

      return require("./__generated__/reviewsContainerQuery.graphql");
    });

    const variables = {
      repoOwner: this.props.owner,
      repoName: this.props.repo,
      prNumber: this.props.number,
      reviewCount: _helpers.PAGE_SIZE,
      reviewCursor: null,
      threadCount: _helpers.PAGE_SIZE,
      threadCursor: null,
      commentCount: _helpers.PAGE_SIZE,
      commentCursor: null
    };
    return _react["default"].createElement(_relayEnvironment["default"].Provider, {
      value: environment
    }, _react["default"].createElement(_reactRelay.QueryRenderer, {
      environment: environment,
      query: query,
      variables: variables,
      render: queryResult => this.renderWithQuery(queryResult, {
        repoData,
        patch
      })
    }));
  }

  renderWithQuery({
    error,
    props,
    retry
  }, {
    repoData,
    patch
  }) {
    if (error) {
      return _react["default"].createElement(_queryErrorView["default"], {
        error: error,
        login: this.handleLogin,
        retry: retry,
        logout: this.handleLogout
      });
    }

    if (!props || !repoData || !patch) {
      return _react["default"].createElement(_loadingView["default"], null);
    }

    return _react["default"].createElement(_aggregatedReviewsContainer["default"], {
      pullRequest: props.repository.pullRequest,
      reportRelayError: this.props.reportRelayError
    }, ({
      errors,
      summaries,
      commentThreads,
      refetch
    }) => {
      if (errors && errors.length > 0) {
        return errors.map((err, i) => _react["default"].createElement(_errorView["default"], {
          key: `error-${i}`,
          title: "Pagination error",
          descriptions: [err.stack]
        }));
      }

      const aggregationResult = {
        summaries,
        commentThreads,
        refetch
      };
      return this.renderWithResult({
        aggregationResult,
        queryProps: props,
        repoData,
        patch,
        refetch
      });
    });
  }

  renderWithResult({
    aggregationResult,
    queryProps,
    repoData,
    patch
  }) {
    return _react["default"].createElement(_commentPositioningContainer["default"], _extends({
      multiFilePatch: patch
    }, aggregationResult, {
      prCommitSha: queryProps.repository.pullRequest.headRefOid,
      localRepository: this.props.repository
    }), commentTranslations => {
      return _react["default"].createElement(_reviewsController["default"], _extends({}, this.props, aggregationResult, {
        commentTranslations: commentTranslations,
        localRepository: this.props.repository,
        multiFilePatch: patch,
        repository: queryProps.repository,
        pullRequest: queryProps.repository.pullRequest,
        viewer: queryProps.viewer
      }, repoData));
    });
  }

}

exports["default"] = ReviewsContainer;

_defineProperty(ReviewsContainer, "propTypes", {
  // Connection
  endpoint: _propTypes2.EndpointPropType.isRequired,
  // Pull request selection criteria
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  number: _propTypes["default"].number.isRequired,
  workdir: _propTypes["default"].string.isRequired,
  // Package models
  repository: _propTypes["default"].object.isRequired,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  workdirContextPool: _propTypes2.WorkdirContextPoolPropType.isRequired,
  initThreadID: _propTypes["default"].string,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  confirm: _propTypes["default"].func.isRequired,
  // Action methods
  reportRelayError: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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