"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactRelay = require("react-relay");

var _reporterProxy = require("../reporter-proxy");

var _propTypes2 = require("../prop-types");

var _relayNetworkLayerManager = _interopRequireDefault(require("../relay-network-layer-manager"));

var _keytarStrategy = require("../shared/keytar-strategy");

var _remoteController = _interopRequireDefault(require("../controllers/remote-controller"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _loadingView = _interopRequireDefault(require("../views/loading-view"));

var _queryErrorView = _interopRequireDefault(require("../views/query-error-view"));

var _githubLoginView = _interopRequireDefault(require("../views/github-login-view"));

var _graphql;

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class RemoteContainer extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "fetchToken", loginModel => {
      return loginModel.getToken(this.props.endpoint.getLoginAccount());
    });

    _defineProperty(this, "renderWithToken", token => {
      if (token === null) {
        return _react["default"].createElement(_loadingView["default"], null);
      }

      if (token instanceof Error) {
        return _react["default"].createElement(_queryErrorView["default"], {
          error: token,
          retry: this.handleTokenRetry,
          login: this.handleLogin,
          logout: this.handleLogout
        });
      }

      if (token === _keytarStrategy.UNAUTHENTICATED) {
        return _react["default"].createElement(_githubLoginView["default"], {
          onLogin: this.handleLogin
        });
      }

      if (token === _keytarStrategy.INSUFFICIENT) {
        return _react["default"].createElement(_githubLoginView["default"], {
          onLogin: this.handleLogin
        }, _react["default"].createElement("p", null, "Your token no longer has sufficient authorizations. Please re-authenticate and generate a new one."));
      }

      const environment = _relayNetworkLayerManager["default"].getEnvironmentForHost(this.props.endpoint, token);

      const query = _graphql || (_graphql = function () {
        const node = require("./__generated__/remoteContainerQuery.graphql");

        if (node.hash && node.hash !== "b83aa6c27c5d7e1c499badf2e6bfab6b") {
          console.error("The definition of 'remoteContainerQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
        }

        return require("./__generated__/remoteContainerQuery.graphql");
      });

      const variables = {
        owner: this.props.remote.getOwner(),
        name: this.props.remote.getRepo()
      };
      return _react["default"].createElement(_reactRelay.QueryRenderer, {
        environment: environment,
        variables: variables,
        query: query,
        render: result => this.renderWithResult(result, token)
      });
    });

    _defineProperty(this, "handleLogin", token => {
      (0, _reporterProxy.incrementCounter)('github-login');
      this.props.loginModel.setToken(this.props.endpoint.getLoginAccount(), token);
    });

    _defineProperty(this, "handleLogout", () => {
      (0, _reporterProxy.incrementCounter)('github-logout');
      this.props.loginModel.removeToken(this.props.endpoint.getLoginAccount());
    });

    _defineProperty(this, "handleTokenRetry", () => this.props.loginModel.didUpdate());
  }

  render() {
    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.loginModel,
      fetchData: this.fetchToken
    }, this.renderWithToken);
  }

  renderWithResult({
    error,
    props,
    retry
  }, token) {
    if (error) {
      return _react["default"].createElement(_queryErrorView["default"], {
        error: error,
        login: this.handleLogin,
        retry: retry,
        logout: this.handleLogout
      });
    }

    if (props === null) {
      return _react["default"].createElement(_loadingView["default"], null);
    }

    return _react["default"].createElement(_remoteController["default"], {
      endpoint: this.props.endpoint,
      token: token,
      repository: props.repository,
      remoteOperationObserver: this.props.remoteOperationObserver,
      workingDirectory: this.props.workingDirectory,
      workspace: this.props.workspace,
      remote: this.props.remote,
      remotes: this.props.remotes,
      branches: this.props.branches,
      aheadCount: this.props.aheadCount,
      pushInProgress: this.props.pushInProgress,
      onPushBranch: this.props.onPushBranch
    });
  }

}

exports["default"] = RemoteContainer;

_defineProperty(RemoteContainer, "propTypes", {
  // Connection
  loginModel: _propTypes["default"].object.isRequired,
  endpoint: _propTypes2.EndpointPropType.isRequired,
  // Repository attributes
  remoteOperationObserver: _propTypes2.OperationStateObserverPropType.isRequired,
  pushInProgress: _propTypes["default"].bool.isRequired,
  workingDirectory: _propTypes["default"].string,
  workspace: _propTypes["default"].object.isRequired,
  remote: _propTypes2.RemotePropType.isRequired,
  remotes: _propTypes2.RemoteSetPropType.isRequired,
  branches: _propTypes2.BranchSetPropType.isRequired,
  aheadCount: _propTypes["default"].number,
  // Action methods
  onPushBranch: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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