"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

var _propTypes2 = require("../prop-types");

var _prPatchContainer = _interopRequireDefault(require("./pr-patch-container"));

var _multiFilePatchController = _interopRequireDefault(require("../controllers/multi-file-patch-controller"));

var _loadingView = _interopRequireDefault(require("../views/loading-view"));

var _errorView = _interopRequireDefault(require("../views/error-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class PullRequestChangedFilesContainer extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "renderPatchResult", (error, multiFilePatch) => {
      if (error === null && multiFilePatch === null) {
        return _react["default"].createElement(_loadingView["default"], null);
      }

      if (error !== null) {
        return _react["default"].createElement(_errorView["default"], {
          descriptions: [error]
        });
      }

      if (multiFilePatch !== this.lastPatch.patch) {
        this.lastPatch.subs.dispose();
        this.lastPatch = {
          subs: new _eventKit.CompositeDisposable(...multiFilePatch.getFilePatches().map(fp => fp.onDidChangeRenderStatus(() => this.forceUpdate()))),
          patch: multiFilePatch
        };
      }

      return _react["default"].createElement(_multiFilePatchController["default"], _extends({
        multiFilePatch: multiFilePatch,
        repository: this.props.localRepository,
        reviewCommentsLoading: this.props.reviewCommentsLoading,
        reviewCommentThreads: this.props.reviewCommentThreads
      }, this.props));
    });

    this.lastPatch = {
      patch: null,
      subs: new _eventKit.CompositeDisposable()
    };
  }

  componentWillUnmount() {
    this.lastPatch.subs.dispose();
  }

  render() {
    const patchProps = {
      owner: this.props.owner,
      repo: this.props.repo,
      number: this.props.number,
      endpoint: this.props.endpoint,
      token: this.props.token,
      refetch: this.props.shouldRefetch
    };
    return _react["default"].createElement(_prPatchContainer["default"], patchProps, this.renderPatchResult);
  }

}

exports["default"] = PullRequestChangedFilesContainer;

_defineProperty(PullRequestChangedFilesContainer, "propTypes", {
  // Pull request properties
  owner: _propTypes["default"].string.isRequired,
  repo: _propTypes["default"].string.isRequired,
  number: _propTypes["default"].number.isRequired,
  // Connection properties
  endpoint: _propTypes2.EndpointPropType.isRequired,
  token: _propTypes["default"].string.isRequired,
  // Item context
  itemType: _propTypes2.ItemTypePropType.isRequired,
  // action methods
  destroy: _propTypes["default"].func.isRequired,
  // Atom environment
  workspace: _propTypes["default"].object.isRequired,
  commands: _propTypes["default"].object.isRequired,
  keymaps: _propTypes["default"].object.isRequired,
  tooltips: _propTypes["default"].object.isRequired,
  config: _propTypes["default"].object.isRequired,
  // local repo as opposed to pull request repo
  localRepository: _propTypes["default"].object.isRequired,
  workdirPath: _propTypes["default"].string,
  // Review comment threads
  reviewCommentsLoading: _propTypes["default"].bool.isRequired,
  reviewCommentThreads: _propTypes["default"].arrayOf(_propTypes["default"].shape({
    thread: _propTypes["default"].object.isRequired,
    comments: _propTypes["default"].arrayOf(_propTypes["default"].object).isRequired
  })).isRequired,
  // refetch diff on refresh
  shouldRefetch: _propTypes["default"].bool.isRequired,
  // For opening files changed tab
  initChangedFilePath: _propTypes["default"].string,
  initChangedFilePosition: _propTypes["default"].number,
  onOpenFilesTab: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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