"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _yubikiri = _interopRequireDefault(require("yubikiri"));

var _propTypes2 = require("../prop-types");

var _operationStateObserver = _interopRequireWildcard(require("../models/operation-state-observer"));

var _githubTabController = _interopRequireDefault(require("../controllers/github-tab-controller"));

var _observeModel = _interopRequireDefault(require("../views/observe-model"));

var _remoteSet = _interopRequireDefault(require("../models/remote-set"));

var _branchSet = _interopRequireDefault(require("../models/branch-set"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj["default"] = obj; return newObj; } }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class GitHubTabContainer extends _react["default"].Component {
  constructor(...args) {
    super(...args);

    _defineProperty(this, "state", {});

    _defineProperty(this, "fetchRepositoryData", repository => {
      return (0, _yubikiri["default"])({
        workingDirectory: repository.getWorkingDirectoryPath(),
        allRemotes: repository.getRemotes(),
        branches: repository.getBranches(),
        selectedRemoteName: repository.getConfig('atomGithub.currentRemote'),
        aheadCount: async query => {
          const branches = await query.branches;
          const currentBranch = branches.getHeadBranch();
          return repository.getAheadCount(currentBranch.getName());
        },
        pushInProgress: repository.getOperationStates().isPushInProgress()
      });
    });

    _defineProperty(this, "renderRepositoryData", data => {
      if (!data || this.props.repository.isLoading()) {
        return _react["default"].createElement(_githubTabController["default"], _extends({}, this.props, {
          remoteOperationObserver: this.state.remoteOperationObserver,
          allRemotes: new _remoteSet["default"](),
          branches: new _branchSet["default"](),
          aheadCount: 0,
          pushInProgress: false,
          isLoading: true
        }));
      }

      if (!this.props.repository.isPresent()) {
        // TODO include a better message here.
        return null;
      }

      return _react["default"].createElement(_githubTabController["default"], _extends({}, data, this.props, {
        remoteOperationObserver: this.state.remoteOperationObserver,
        isLoading: false
      }));
    });
  }

  static getDerivedStateFromProps(props, state) {
    if (props.repository !== state.lastRepository) {
      return {
        lastRepository: props.repository,
        remoteOperationObserver: new _operationStateObserver["default"](props.repository, _operationStateObserver.PUSH, _operationStateObserver.PULL, _operationStateObserver.FETCH)
      };
    }

    return null;
  }

  render() {
    return _react["default"].createElement(_observeModel["default"], {
      model: this.props.repository,
      fetchData: this.fetchRepositoryData
    }, this.renderRepositoryData);
  }

}

exports["default"] = GitHubTabContainer;

_defineProperty(GitHubTabContainer, "propTypes", {
  workspace: _propTypes["default"].object.isRequired,
  repository: _propTypes["default"].object,
  loginModel: _propTypes2.GithubLoginModelPropType.isRequired,
  rootHolder: _propTypes2.RefHolderPropType.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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