"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exports.BareAggregatedReviewsContainer = void 0;

var _react = _interopRequireDefault(require("react"));

var _eventKit = require("event-kit");

var _reactRelay = require("react-relay");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _helpers = require("../helpers");

var _reviewSummariesAccumulator = _interopRequireDefault(require("./accumulators/review-summaries-accumulator"));

var _reviewThreadsAccumulator = _interopRequireDefault(require("./accumulators/review-threads-accumulator"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class BareAggregatedReviewsContainer extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "refetch", callback => this.props.relay.refetch({
      prId: this.props.pullRequest.id,
      reviewCount: _helpers.PAGE_SIZE,
      reviewCursor: null,
      threadCount: _helpers.PAGE_SIZE,
      threadCursor: null,
      commentCount: _helpers.PAGE_SIZE,
      commentCursor: null
    }, null, err => {
      if (err) {
        this.props.reportRelayError('Unable to refresh reviews', err);
      } else {
        this.emitter.emit('did-refetch');
      }

      callback();
    }, {
      force: true
    }));

    _defineProperty(this, "onDidRefetch", callback => this.emitter.on('did-refetch', callback));

    this.emitter = new _eventKit.Emitter();
  }

  render() {
    return _react["default"].createElement(_reviewSummariesAccumulator["default"], {
      onDidRefetch: this.onDidRefetch,
      pullRequest: this.props.pullRequest
    }, ({
      error: summaryError,
      summaries,
      loading: summariesLoading
    }) => {
      return _react["default"].createElement(_reviewThreadsAccumulator["default"], {
        onDidRefetch: this.onDidRefetch,
        pullRequest: this.props.pullRequest
      }, payload => {
        const result = {
          errors: [],
          refetch: this.refetch,
          summaries,
          commentThreads: payload.commentThreads,
          loading: payload.loading || summariesLoading
        };

        if (summaryError) {
          result.errors.push(summaryError);
        }

        result.errors.push(...payload.errors);
        return this.props.children(result);
      });
    });
  }

}

exports.BareAggregatedReviewsContainer = BareAggregatedReviewsContainer;

_defineProperty(BareAggregatedReviewsContainer, "propTypes", {
  // Relay response
  relay: _propTypes["default"].shape({
    refetch: _propTypes["default"].func.isRequired
  }),
  // Relay results.
  pullRequest: _propTypes["default"].shape({
    id: _propTypes["default"].string.isRequired
  }).isRequired,
  // Render prop. Called with {errors, summaries, commentThreads, loading}.
  children: _propTypes["default"].func.isRequired,
  // only fetch summaries when we specify a summariesRenderer
  summariesRenderer: _propTypes["default"].func,
  // Report errors during refetch
  reportRelayError: _propTypes["default"].func.isRequired
});

var _default = (0, _reactRelay.createRefetchContainer)(BareAggregatedReviewsContainer, {
  pullRequest: function () {
    const node = require("./__generated__/aggregatedReviewsContainer_pullRequest.graphql");

    if (node.hash && node.hash !== "830225d5b83d6c320e16cf824fe0cca6") {
      console.error("The definition of 'aggregatedReviewsContainer_pullRequest' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
    }

    return require("./__generated__/aggregatedReviewsContainer_pullRequest.graphql");
  }
}, function () {
  const node = require("./__generated__/aggregatedReviewsContainerRefetchQuery.graphql");

  if (node.hash && node.hash !== "2bf1bb4fa69d264bcecbe81f41621908") {
    console.error("The definition of 'aggregatedReviewsContainerRefetchQuery' appears to have changed. Run `relay-compiler` to update the generated files to receive the expected data.");
  }

  return require("./__generated__/aggregatedReviewsContainerRefetchQuery.graphql");
});

exports["default"] = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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