"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _eventKit = require("event-kit");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Accumulator extends _react["default"].Component {
  constructor(props) {
    super(props);

    _defineProperty(this, "attemptToLoadMore", () => {
      this.loadMoreSub.dispose();
      this.nextUpdateID = null;
      /* istanbul ignore if */

      if (!this.props.relay.hasMore() || this.props.relay.isLoading()) {
        return;
      }

      this.loadMoreSub = this.props.relay.loadMore(this.props.pageSize, this.accumulate);
    });

    _defineProperty(this, "accumulate", error => {
      if (error) {
        this.setState({
          error
        });
      } else {
        if (this.props.waitTimeMs > 0 && this.nextUpdateID === null) {
          this.nextUpdateID = setTimeout(this.attemptToLoadMore, this.props.waitTimeMs);
          this.nextUpdateSub = new _eventKit.Disposable(() => {
            clearTimeout(this.nextUpdateID);
            this.nextUpdateID = null;
          });
        } else {
          this.attemptToLoadMore();
        }
      }
    });

    this.refetchSub = new _eventKit.Disposable();
    this.loadMoreSub = new _eventKit.Disposable();
    this.nextUpdateSub = new _eventKit.Disposable();
    this.nextUpdateID = null;
    this.state = {
      error: null
    };
  }

  componentDidMount() {
    this.refetchSub = this.props.onDidRefetch(this.attemptToLoadMore);
    this.attemptToLoadMore();
  }

  componentWillUnmount() {
    this.refetchSub.dispose();
    this.loadMoreSub.dispose();
    this.nextUpdateSub.dispose();
  }

  render() {
    return this.props.children(this.state.error, this.props.resultBatch, this.props.relay.hasMore());
  }

}

exports["default"] = Accumulator;

_defineProperty(Accumulator, "propTypes", {
  // Relay props
  relay: _propTypes["default"].shape({
    hasMore: _propTypes["default"].func.isRequired,
    loadMore: _propTypes["default"].func.isRequired,
    isLoading: _propTypes["default"].func.isRequired
  }).isRequired,
  resultBatch: _propTypes["default"].arrayOf(_propTypes["default"].any).isRequired,
  // Control props
  pageSize: _propTypes["default"].number.isRequired,
  waitTimeMs: _propTypes["default"].number.isRequired,
  // Render prop. Called with (error, full result list, loading) each time more results arrive. Return value is
  // rendered as a child element.
  children: _propTypes["default"].func,
  // Called right after refetch happens
  onDidRefetch: _propTypes["default"].func.isRequired
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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