"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactDom = _interopRequireDefault(require("react-dom"));

var _propTypes = _interopRequireDefault(require("prop-types"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class StatusBar extends _react["default"].Component {
  constructor(props) {
    super(props);
    this.domNode = document.createElement('div');
    this.domNode.classList.add('react-atom-status-bar');

    if (props.className) {
      this.domNode.classList.add(props.className);
    }

    this.tile = null;
  }

  componentDidMount() {
    this.consumeStatusBar();
  }

  render() {
    return _reactDom["default"].createPortal(this.props.children, this.domNode);
  }

  consumeStatusBar() {
    if (this.tile) {
      return;
    }

    if (!this.props.statusBar) {
      return;
    }

    this.tile = this.props.statusBar.addRightTile({
      item: this.domNode,
      priority: -50
    });
    this.props.onConsumeStatusBar(this.props.statusBar);
  }

  componentWillUnmount() {
    this.tile && this.tile.destroy();
  }

}

exports["default"] = StatusBar;

_defineProperty(StatusBar, "propTypes", {
  children: _propTypes["default"].element.isRequired,
  statusBar: _propTypes["default"].object,
  onConsumeStatusBar: _propTypes["default"].func,
  className: _propTypes["default"].string
});

_defineProperty(StatusBar, "defaultProps", {
  onConsumeStatusBar: statusBar => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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