"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _underscorePlus = require("underscore-plus");

var _eventKit = require("event-kit");

var _helpers = require("../helpers");

var _propTypes2 = require("../prop-types");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Keystroke extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'didChangeTarget');
    this.sub = new _eventKit.Disposable();
    this.state = {
      keybinding: null
    };
  }

  componentDidMount() {
    this.observeTarget();
  }

  componentDidUpdate(prevProps, prevState) {
    if (this.props.refTarget !== prevProps.refTarget) {
      this.observeTarget();
    } else if (this.props.command !== prevProps.command) {
      this.didChangeTarget(this.props.refTarget.getOr(null));
    }
  }

  componentWillUnmount() {
    this.sub.dispose();
  }

  render() {
    if (!this.state.keybinding) {
      return null;
    }

    return _react["default"].createElement("span", {
      className: "keystroke"
    }, (0, _underscorePlus.humanizeKeystroke)(this.state.keybinding.keystrokes));
  }

  observeTarget() {
    this.sub.dispose();

    if (this.props.refTarget) {
      this.sub = this.props.refTarget.observe(this.didChangeTarget);
    } else {
      this.didChangeTarget(null);
    }
  }

  didChangeTarget(target) {
    const [keybinding] = this.props.keymaps.findKeyBindings({
      command: this.props.command,
      target
    });
    this.setState({
      keybinding
    });
  }

}

exports["default"] = Keystroke;

_defineProperty(Keystroke, "propTypes", {
  keymaps: _propTypes["default"].shape({
    findKeyBindings: _propTypes["default"].func.isRequired
  }).isRequired,
  command: _propTypes["default"].string.isRequired,
  refTarget: _propTypes2.RefHolderPropType
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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