Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */
/** @jsx etch.dom */

var _underscorePlus = require('underscore-plus');

var _underscorePlus2 = _interopRequireDefault(_underscorePlus);

var _atom = require('atom');

var _etch = require('etch');

var _etch2 = _interopRequireDefault(_etch);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _grim = require('grim');

var _grim2 = _interopRequireDefault(_grim);

var _marked = require('marked');

var _marked2 = _interopRequireDefault(_marked);

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _shell = require('shell');

var _shell2 = _interopRequireDefault(_shell);

var DeprecationCopView = (function () {
  function DeprecationCopView(_ref) {
    var _this = this;

    var uri = _ref.uri;

    _classCallCheck(this, DeprecationCopView);

    this.uri = uri;
    this.subscriptions = new _atom.CompositeDisposable();
    this.subscriptions.add(_grim2['default'].on('updated', function () {
      _etch2['default'].update(_this);
    }));
    // TODO: Remove conditional when the new StyleManager deprecation APIs reach stable.
    if (atom.styles.onDidUpdateDeprecations) {
      this.subscriptions.add(atom.styles.onDidUpdateDeprecations(function () {
        _etch2['default'].update(_this);
      }));
    }
    _etch2['default'].initialize(this);
    this.subscriptions.add(atom.commands.add(this.element, {
      'core:move-up': function coreMoveUp() {
        _this.scrollUp();
      },
      'core:move-down': function coreMoveDown() {
        _this.scrollDown();
      },
      'core:page-up': function corePageUp() {
        _this.pageUp();
      },
      'core:page-down': function corePageDown() {
        _this.pageDown();
      },
      'core:move-to-top': function coreMoveToTop() {
        _this.scrollToTop();
      },
      'core:move-to-bottom': function coreMoveToBottom() {
        _this.scrollToBottom();
      }
    }));
  }

  _createClass(DeprecationCopView, [{
    key: 'serialize',
    value: function serialize() {
      return {
        deserializer: this.constructor.name,
        uri: this.getURI(),
        version: 1
      };
    }
  }, {
    key: 'destroy',
    value: function destroy() {
      this.subscriptions.dispose();
      return _etch2['default'].destroy(this);
    }
  }, {
    key: 'update',
    value: function update() {
      return _etch2['default'].update(this);
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      return _etch2['default'].dom(
        'div',
        {
          className: 'deprecation-cop pane-item native-key-bindings',
          tabIndex: '-1'
        },
        _etch2['default'].dom(
          'div',
          { className: 'panel' },
          _etch2['default'].dom(
            'div',
            { className: 'padded deprecation-overview' },
            _etch2['default'].dom(
              'div',
              { className: 'pull-right btn-group' },
              _etch2['default'].dom(
                'button',
                {
                  className: 'btn btn-primary check-for-update',
                  onclick: function (event) {
                    event.preventDefault();
                    _this2.checkForUpdates();
                  }
                },
                'Check for Updates'
              )
            )
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            _etch2['default'].dom(
              'span',
              null,
              'Deprecated calls'
            )
          ),
          _etch2['default'].dom(
            'ul',
            { className: 'list-tree has-collapsable-children' },
            this.renderDeprecatedCalls()
          ),
          _etch2['default'].dom(
            'div',
            { className: 'panel-heading' },
            _etch2['default'].dom(
              'span',
              null,
              'Deprecated selectors'
            )
          ),
          _etch2['default'].dom(
            'ul',
            { className: 'selectors list-tree has-collapsable-children' },
            this.renderDeprecatedSelectors()
          )
        )
      );
    }
  }, {
    key: 'renderDeprecatedCalls',
    value: function renderDeprecatedCalls() {
      var _this3 = this;

      var deprecationsByPackageName = this.getDeprecatedCallsByPackageName();
      var packageNames = Object.keys(deprecationsByPackageName);
      if (packageNames.length === 0) {
        return _etch2['default'].dom(
          'li',
          { className: 'list-item' },
          'No deprecated calls'
        );
      } else {
        return packageNames.sort().map(function (packageName) {
          return _etch2['default'].dom(
            'li',
            { className: 'deprecation list-nested-item collapsed' },
            _etch2['default'].dom(
              'div',
              {
                className: 'deprecation-info list-item',
                onclick: function (event) {
                  return event.target.parentElement.classList.toggle('collapsed');
                }
              },
              _etch2['default'].dom(
                'span',
                { className: 'text-highlight' },
                packageName || 'atom core'
              ),
              _etch2['default'].dom(
                'span',
                null,
                ' (' + _underscorePlus2['default'].pluralize(deprecationsByPackageName[packageName].length, 'deprecation') + ')'
              )
            ),
            _etch2['default'].dom(
              'ul',
              { className: 'list' },
              _this3.renderPackageActionsIfNeeded(packageName),
              deprecationsByPackageName[packageName].map(function (_ref2) {
                var deprecation = _ref2.deprecation;
                var stack = _ref2.stack;
                return _etch2['default'].dom(
                  'li',
                  { className: 'list-item deprecation-detail' },
                  _etch2['default'].dom('span', { className: 'text-warning icon icon-alert' }),
                  _etch2['default'].dom('div', {
                    className: 'list-item deprecation-message',
                    innerHTML: (0, _marked2['default'])(deprecation.getMessage())
                  }),
                  _this3.renderIssueURLIfNeeded(packageName, deprecation, _this3.buildIssueURL(packageName, deprecation, stack)),
                  _etch2['default'].dom(
                    'div',
                    { className: 'stack-trace' },
                    stack.map(function (_ref3) {
                      var functionName = _ref3.functionName;
                      var location = _ref3.location;
                      return _etch2['default'].dom(
                        'div',
                        { className: 'stack-line' },
                        _etch2['default'].dom(
                          'span',
                          null,
                          functionName
                        ),
                        _etch2['default'].dom(
                          'span',
                          null,
                          ' - '
                        ),
                        _etch2['default'].dom(
                          'a',
                          {
                            className: 'stack-line-location',
                            href: location,
                            onclick: function (event) {
                              event.preventDefault();
                              _this3.openLocation(location);
                            }
                          },
                          location
                        )
                      );
                    })
                  )
                );
              })
            )
          );
        });
      }
    }
  }, {
    key: 'renderDeprecatedSelectors',
    value: function renderDeprecatedSelectors() {
      var _this4 = this;

      var deprecationsByPackageName = this.getDeprecatedSelectorsByPackageName();
      var packageNames = Object.keys(deprecationsByPackageName);
      if (packageNames.length === 0) {
        return _etch2['default'].dom(
          'li',
          { className: 'list-item' },
          'No deprecated selectors'
        );
      } else {
        return packageNames.map(function (packageName) {
          return _etch2['default'].dom(
            'li',
            { className: 'deprecation list-nested-item collapsed' },
            _etch2['default'].dom(
              'div',
              {
                className: 'deprecation-info list-item',
                onclick: function (event) {
                  return event.target.parentElement.classList.toggle('collapsed');
                }
              },
              _etch2['default'].dom(
                'span',
                { className: 'text-highlight' },
                packageName
              )
            ),
            _etch2['default'].dom(
              'ul',
              { className: 'list' },
              _this4.renderPackageActionsIfNeeded(packageName),
              deprecationsByPackageName[packageName].map(function (_ref4) {
                var packagePath = _ref4.packagePath;
                var sourcePath = _ref4.sourcePath;
                var deprecation = _ref4.deprecation;

                var relativeSourcePath = _path2['default'].relative(packagePath, sourcePath);
                var issueTitle = 'Deprecated selector in `' + relativeSourcePath + '`';
                var issueBody = 'In `' + relativeSourcePath + '`: \n\n' + deprecation.message;
                return _etch2['default'].dom(
                  'li',
                  { className: 'list-item source-file' },
                  _etch2['default'].dom(
                    'a',
                    {
                      className: 'source-url',
                      href: sourcePath,
                      onclick: function (event) {
                        event.preventDefault();
                        _this4.openLocation(sourcePath);
                      }
                    },
                    relativeSourcePath
                  ),
                  _etch2['default'].dom(
                    'ul',
                    { className: 'list' },
                    _etch2['default'].dom(
                      'li',
                      { className: 'list-item deprecation-detail' },
                      _etch2['default'].dom('span', { className: 'text-warning icon icon-alert' }),
                      _etch2['default'].dom('div', {
                        className: 'list-item deprecation-message',
                        innerHTML: (0, _marked2['default'])(deprecation.message)
                      }),
                      _this4.renderSelectorIssueURLIfNeeded(packageName, issueTitle, issueBody)
                    )
                  )
                );
              })
            )
          );
        });
      }
    }
  }, {
    key: 'renderPackageActionsIfNeeded',
    value: function renderPackageActionsIfNeeded(packageName) {
      var _this5 = this;

      if (packageName && atom.packages.getLoadedPackage(packageName)) {
        return _etch2['default'].dom(
          'div',
          { className: 'padded' },
          _etch2['default'].dom(
            'div',
            { className: 'btn-group' },
            _etch2['default'].dom(
              'button',
              {
                className: 'btn check-for-update',
                onclick: function (event) {
                  event.preventDefault();
                  _this5.checkForUpdates();
                }
              },
              'Check for Update'
            ),
            _etch2['default'].dom(
              'button',
              {
                className: 'btn disable-package',
                'data-package-name': packageName,
                onclick: function (event) {
                  event.preventDefault();
                  _this5.disablePackage(packageName);
                }
              },
              'Disable Package'
            )
          )
        );
      } else {
        return '';
      }
    }
  }, {
    key: 'encodeURI',
    value: (function (_encodeURI) {
      function encodeURI(_x) {
        return _encodeURI.apply(this, arguments);
      }

      encodeURI.toString = function () {
        return _encodeURI.toString();
      };

      return encodeURI;
    })(function (str) {
      return encodeURI(str).replace(/#/g, '%23').replace(/;/g, '%3B').replace(/%20/g, '+');
    })
  }, {
    key: 'renderSelectorIssueURLIfNeeded',
    value: function renderSelectorIssueURLIfNeeded(packageName, issueTitle, issueBody) {
      var _this6 = this;

      var repoURL = this.getRepoURL(packageName);
      if (repoURL) {
        var _ret = (function () {
          var issueURL = repoURL + '/issues/new?title=' + _this6.encodeURI(issueTitle) + '&body=' + _this6.encodeURI(issueBody);
          return {
            v: _etch2['default'].dom(
              'div',
              { className: 'btn-toolbar' },
              _etch2['default'].dom(
                'button',
                {
                  className: 'btn issue-url',
                  'data-issue-title': issueTitle,
                  'data-repo-url': repoURL,
                  'data-issue-url': issueURL,
                  onclick: function (event) {
                    event.preventDefault();
                    _this6.openIssueURL(repoURL, issueURL, issueTitle);
                  }
                },
                'Report Issue'
              )
            )
          };
        })();

        if (typeof _ret === 'object') return _ret.v;
      } else {
        return '';
      }
    }
  }, {
    key: 'renderIssueURLIfNeeded',
    value: function renderIssueURLIfNeeded(packageName, deprecation, issueURL) {
      var _this7 = this;

      if (packageName && issueURL) {
        var _ret2 = (function () {
          var repoURL = _this7.getRepoURL(packageName);
          var issueTitle = deprecation.getOriginName() + ' is deprecated.';
          return {
            v: _etch2['default'].dom(
              'div',
              { className: 'btn-toolbar' },
              _etch2['default'].dom(
                'button',
                {
                  className: 'btn issue-url',
                  'data-issue-title': issueTitle,
                  'data-repo-url': repoURL,
                  'data-issue-url': issueURL,
                  onclick: function (event) {
                    event.preventDefault();
                    _this7.openIssueURL(repoURL, issueURL, issueTitle);
                  }
                },
                'Report Issue'
              )
            )
          };
        })();

        if (typeof _ret2 === 'object') return _ret2.v;
      } else {
        return '';
      }
    }
  }, {
    key: 'buildIssueURL',
    value: function buildIssueURL(packageName, deprecation, stack) {
      var repoURL = this.getRepoURL(packageName);
      if (repoURL) {
        var title = deprecation.getOriginName() + ' is deprecated.';
        var stacktrace = stack.map(function (_ref5) {
          var functionName = _ref5.functionName;
          var location = _ref5.location;
          return functionName + ' (' + location + ')';
        }).join('\n');
        var body = deprecation.getMessage() + '\n```\n' + stacktrace + '\n```';
        return repoURL + '/issues/new?title=' + encodeURI(title) + '&body=' + encodeURI(body);
      } else {
        return null;
      }
    }
  }, {
    key: 'openIssueURL',
    value: _asyncToGenerator(function* (repoURL, issueURL, issueTitle) {
      var issue = yield this.findSimilarIssue(repoURL, issueTitle);
      if (issue) {
        _shell2['default'].openExternal(issue.html_url);
      } else if (process.platform === 'win32') {
        // Windows will not launch URLs greater than ~2000 bytes so we need to shrink it
        _shell2['default'].openExternal((yield this.shortenURL(issueURL)) || issueURL);
      } else {
        _shell2['default'].openExternal(issueURL);
      }
    })
  }, {
    key: 'findSimilarIssue',
    value: _asyncToGenerator(function* (repoURL, issueTitle) {
      var url = 'https://api.github.com/search/issues';
      var repo = repoURL.replace(/http(s)?:\/\/(\d+\.)?github.com\//gi, '');
      var query = issueTitle + ' repo:' + repo;
      var response = yield window.fetch(url + '?q=' + encodeURI(query) + '&sort=created', {
        method: 'GET',
        headers: {
          Accept: 'application/vnd.github.v3+json',
          'Content-Type': 'application/json'
        }
      });

      if (response.ok) {
        var data = yield response.json();
        if (data.items) {
          var issues = {};
          for (var issue of data.items) {
            if (issue.title.includes(issueTitle) && !issues[issue.state]) {
              issues[issue.state] = issue;
            }
          }

          return issues.open || issues.closed;
        }
      }
    })
  }, {
    key: 'shortenURL',
    value: _asyncToGenerator(function* (url) {
      var encodedUrl = encodeURIComponent(url).substr(0, 5000); // is.gd has 5000 char limit
      var incompletePercentEncoding = encodedUrl.indexOf('%', encodedUrl.length - 2);
      if (incompletePercentEncoding >= 0) {
        // Handle an incomplete % encoding cut-off
        encodedUrl = encodedUrl.substr(0, incompletePercentEncoding);
      }

      var result = yield fetch('https://is.gd/create.php?format=simple', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: 'url=' + encodedUrl
      });

      return result.text();
    })
  }, {
    key: 'getRepoURL',
    value: function getRepoURL(packageName) {
      var loadedPackage = atom.packages.getLoadedPackage(packageName);
      if (loadedPackage && loadedPackage.metadata && loadedPackage.metadata.repository) {
        var url = loadedPackage.metadata.repository.url || loadedPackage.metadata.repository;
        return url.replace(/\.git$/, '');
      } else {
        return null;
      }
    }
  }, {
    key: 'getDeprecatedCallsByPackageName',
    value: function getDeprecatedCallsByPackageName() {
      var deprecatedCalls = _grim2['default'].getDeprecations();
      deprecatedCalls.sort(function (a, b) {
        return b.getCallCount() - a.getCallCount();
      });
      var deprecatedCallsByPackageName = {};
      for (var deprecation of deprecatedCalls) {
        var stacks = deprecation.getStacks();
        stacks.sort(function (a, b) {
          return b.callCount - a.callCount;
        });
        for (var stack of stacks) {
          var packageName = null;
          if (stack.metadata && stack.metadata.packageName) {
            packageName = stack.metadata.packageName;
          } else {
            packageName = (this.getPackageName(stack) || '').toLowerCase();
          }

          deprecatedCallsByPackageName[packageName] = deprecatedCallsByPackageName[packageName] || [];
          deprecatedCallsByPackageName[packageName].push({ deprecation: deprecation, stack: stack });
        }
      }
      return deprecatedCallsByPackageName;
    }
  }, {
    key: 'getDeprecatedSelectorsByPackageName',
    value: function getDeprecatedSelectorsByPackageName() {
      var deprecatedSelectorsByPackageName = {};
      if (atom.styles.getDeprecations) {
        var deprecatedSelectorsBySourcePath = atom.styles.getDeprecations();
        for (var sourcePath of Object.keys(deprecatedSelectorsBySourcePath)) {
          var deprecation = deprecatedSelectorsBySourcePath[sourcePath];
          var components = sourcePath.split(_path2['default'].sep);
          var packagesComponentIndex = components.indexOf('packages');
          var packageName = null;
          var packagePath = null;
          if (packagesComponentIndex === -1) {
            packageName = 'Other'; // could be Atom Core or the personal style sheet
            packagePath = '';
          } else {
            packageName = components[packagesComponentIndex + 1];
            packagePath = components.slice(0, packagesComponentIndex + 1).join(_path2['default'].sep);
          }

          deprecatedSelectorsByPackageName[packageName] = deprecatedSelectorsByPackageName[packageName] || [];
          deprecatedSelectorsByPackageName[packageName].push({
            packagePath: packagePath,
            sourcePath: sourcePath,
            deprecation: deprecation
          });
        }
      }

      return deprecatedSelectorsByPackageName;
    }
  }, {
    key: 'getPackageName',
    value: function getPackageName(stack) {
      var packagePaths = this.getPackagePathsByPackageName();
      for (var _ref63 of packagePaths) {
        var _ref62 = _slicedToArray(_ref63, 2);

        var packageName = _ref62[0];
        var packagePath = _ref62[1];

        if (packagePath.includes('.atom/dev/packages') || packagePath.includes('.atom/packages')) {
          packagePaths.set(packageName, _fsPlus2['default'].absolute(packagePath));
        }
      }

      for (var i = 1; i < stack.length; i++) {
        var fileName = stack[i].fileName;

        // Empty when it was run from the dev console
        if (!fileName) {
          return null;
        }

        // Continue to next stack entry if call is in node_modules
        if (fileName.includes(_path2['default'].sep + 'node_modules' + _path2['default'].sep)) {
          continue;
        }

        for (var _ref73 of packagePaths) {
          var _ref72 = _slicedToArray(_ref73, 2);

          var packageName = _ref72[0];
          var packagePath = _ref72[1];

          var relativePath = _path2['default'].relative(packagePath, fileName);
          if (!/^\.\./.test(relativePath)) {
            return packageName;
          }
        }

        if (atom.getUserInitScriptPath() === fileName) {
          return 'Your local ' + _path2['default'].basename(fileName) + ' file';
        }
      }

      return null;
    }
  }, {
    key: 'getPackagePathsByPackageName',
    value: function getPackagePathsByPackageName() {
      if (this.packagePathsByPackageName) {
        return this.packagePathsByPackageName;
      } else {
        this.packagePathsByPackageName = new Map();
        for (var pack of atom.packages.getLoadedPackages()) {
          this.packagePathsByPackageName.set(pack.name, pack.path);
        }
        return this.packagePathsByPackageName;
      }
    }
  }, {
    key: 'checkForUpdates',
    value: function checkForUpdates() {
      atom.workspace.open('atom://config/updates');
    }
  }, {
    key: 'disablePackage',
    value: function disablePackage(packageName) {
      if (packageName) {
        atom.packages.disablePackage(packageName);
      }
    }
  }, {
    key: 'openLocation',
    value: function openLocation(location) {
      var pathToOpen = location.replace('file://', '');
      if (process.platform === 'win32') {
        pathToOpen = pathToOpen.replace(/^\//, '');
      }
      atom.open({ pathsToOpen: [pathToOpen] });
    }
  }, {
    key: 'getURI',
    value: function getURI() {
      return this.uri;
    }
  }, {
    key: 'getTitle',
    value: function getTitle() {
      return 'Deprecation Cop';
    }
  }, {
    key: 'getIconName',
    value: function getIconName() {
      return 'alert';
    }
  }, {
    key: 'scrollUp',
    value: function scrollUp() {
      this.element.scrollTop -= document.body.offsetHeight / 20;
    }
  }, {
    key: 'scrollDown',
    value: function scrollDown() {
      this.element.scrollTop += document.body.offsetHeight / 20;
    }
  }, {
    key: 'pageUp',
    value: function pageUp() {
      this.element.scrollTop -= this.element.offsetHeight;
    }
  }, {
    key: 'pageDown',
    value: function pageDown() {
      this.element.scrollTop += this.element.offsetHeight;
    }
  }, {
    key: 'scrollToTop',
    value: function scrollToTop() {
      this.element.scrollTop = 0;
    }
  }, {
    key: 'scrollToBottom',
    value: function scrollToBottom() {
      this.element.scrollTop = this.element.scrollHeight;
    }
  }]);

  return DeprecationCopView;
})();

exports['default'] = DeprecationCopView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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