function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

/** @babel */

var assert = require('assert');
var fs = require('fs');
var sinon = require('sinon');
var path = require('path');

var dalek = require('../lib/dalek');

describe('dalek', function () {
  describe('enumerate', function () {
    var availablePackages = {};
    var realPaths = {};
    var bundledPackages = [];
    var packageDirPaths = [];
    var sandbox = null;

    beforeEach(function () {
      availablePackages = {
        'an-unduplicated-installed-package': path.join('Users', 'username', '.atom', 'packages', 'an-unduplicated-installed-package'),
        'duplicated-package': path.join('Users', 'username', '.atom', 'packages', 'duplicated-package'),
        'unduplicated-package': path.join('' + atom.getLoadSettings().resourcePath, 'node_modules', 'unduplicated-package')
      };

      atom.devMode = false;
      bundledPackages = ['duplicated-package', 'unduplicated-package'];
      packageDirPaths = [path.join('Users', 'username', '.atom', 'packages')];
      sandbox = sinon.sandbox.create();
      sandbox.stub(dalek, 'realpath').callsFake(function (filePath) {
        return Promise.resolve(realPaths[filePath] || filePath);
      });
      sandbox.stub(atom.packages, 'isBundledPackage').callsFake(function (packageName) {
        return bundledPackages.includes(packageName);
      });
      sandbox.stub(atom.packages, 'getAvailablePackageNames').callsFake(function () {
        return Object.keys(availablePackages);
      });
      sandbox.stub(atom.packages, 'getPackageDirPaths').callsFake(function () {
        return packageDirPaths;
      });
      sandbox.stub(fs, 'existsSync').callsFake(function (candidate) {
        return Object.values(availablePackages).includes(candidate) && !candidate.includes(atom.getLoadSettings().resourcePath);
      });
    });

    afterEach(function () {
      sandbox.restore();
    });

    it('returns a list of duplicate names', _asyncToGenerator(function* () {
      assert.deepEqual((yield dalek.enumerate()), ['duplicated-package']);
    }));

    describe('when in dev mode', function () {
      beforeEach(function () {
        atom.devMode = true;
      });

      it('always returns an empty list', _asyncToGenerator(function* () {
        assert.deepEqual((yield dalek.enumerate()), []);
      }));
    });

    describe('when a package is symlinked into the package directory', _asyncToGenerator(function* () {
      beforeEach(function () {
        var realPath = path.join('Users', 'username', 'duplicated-package');
        var packagePath = path.join('Users', 'username', '.atom', 'packages', 'duplicated-package');
        realPaths[packagePath] = realPath;
      });

      it('is not included in the list of duplicate names', _asyncToGenerator(function* () {
        assert.deepEqual((yield dalek.enumerate()), []);
      }));
    }));
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi9idWlsZC9hdG9tL3NyYy9hdG9tL291dC9hcHAvbm9kZV9tb2R1bGVzL2RhbGVrL3Rlc3QvZGFsZWsudGVzdC5qcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7O0FBRUEsSUFBTSxNQUFNLEdBQUcsT0FBTyxDQUFDLFFBQVEsQ0FBQyxDQUFDO0FBQ2pDLElBQU0sRUFBRSxHQUFHLE9BQU8sQ0FBQyxJQUFJLENBQUMsQ0FBQztBQUN6QixJQUFNLEtBQUssR0FBRyxPQUFPLENBQUMsT0FBTyxDQUFDLENBQUM7QUFDL0IsSUFBTSxJQUFJLEdBQUcsT0FBTyxDQUFDLE1BQU0sQ0FBQyxDQUFDOztBQUU3QixJQUFNLEtBQUssR0FBRyxPQUFPLENBQUMsY0FBYyxDQUFDLENBQUM7O0FBRXRDLFFBQVEsQ0FBQyxPQUFPLEVBQUUsWUFBVztBQUMzQixVQUFRLENBQUMsV0FBVyxFQUFFLFlBQVc7QUFDL0IsUUFBSSxpQkFBaUIsR0FBRyxFQUFFLENBQUM7QUFDM0IsUUFBSSxTQUFTLEdBQUcsRUFBRSxDQUFDO0FBQ25CLFFBQUksZUFBZSxHQUFHLEVBQUUsQ0FBQztBQUN6QixRQUFJLGVBQWUsR0FBRyxFQUFFLENBQUM7QUFDekIsUUFBSSxPQUFPLEdBQUcsSUFBSSxDQUFDOztBQUVuQixjQUFVLENBQUMsWUFBVztBQUNwQix1QkFBaUIsR0FBRztBQUNsQiwyQ0FBbUMsRUFBRSxJQUFJLENBQUMsSUFBSSxDQUM1QyxPQUFPLEVBQ1AsVUFBVSxFQUNWLE9BQU8sRUFDUCxVQUFVLEVBQ1YsbUNBQW1DLENBQ3BDO0FBQ0QsNEJBQW9CLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FDN0IsT0FBTyxFQUNQLFVBQVUsRUFDVixPQUFPLEVBQ1AsVUFBVSxFQUNWLG9CQUFvQixDQUNyQjtBQUNELDhCQUFzQixFQUFFLElBQUksQ0FBQyxJQUFJLE1BQzVCLElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQyxZQUFZLEVBQ3RDLGNBQWMsRUFDZCxzQkFBc0IsQ0FDdkI7T0FDRixDQUFDOztBQUVGLFVBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDO0FBQ3JCLHFCQUFlLEdBQUcsQ0FBQyxvQkFBb0IsRUFBRSxzQkFBc0IsQ0FBQyxDQUFDO0FBQ2pFLHFCQUFlLEdBQUcsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxVQUFVLEVBQUUsT0FBTyxFQUFFLFVBQVUsQ0FBQyxDQUFDLENBQUM7QUFDeEUsYUFBTyxHQUFHLEtBQUssQ0FBQyxPQUFPLENBQUMsTUFBTSxFQUFFLENBQUM7QUFDakMsYUFBTyxDQUNKLElBQUksQ0FBQyxLQUFLLEVBQUUsVUFBVSxDQUFDLENBQ3ZCLFNBQVMsQ0FBQyxVQUFBLFFBQVE7ZUFDakIsT0FBTyxDQUFDLE9BQU8sQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLElBQUksUUFBUSxDQUFDO09BQUEsQ0FDakQsQ0FBQztBQUNKLGFBQU8sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxrQkFBa0IsQ0FBQyxDQUFDLFNBQVMsQ0FBQyxVQUFBLFdBQVcsRUFBSTtBQUN2RSxlQUFPLGVBQWUsQ0FBQyxRQUFRLENBQUMsV0FBVyxDQUFDLENBQUM7T0FDOUMsQ0FBQyxDQUFDO0FBQ0gsYUFBTyxDQUNKLElBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLDBCQUEwQixDQUFDLENBQy9DLFNBQVMsQ0FBQztlQUFNLE1BQU0sQ0FBQyxJQUFJLENBQUMsaUJBQWlCLENBQUM7T0FBQSxDQUFDLENBQUM7QUFDbkQsYUFBTyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsUUFBUSxFQUFFLG9CQUFvQixDQUFDLENBQUMsU0FBUyxDQUFDLFlBQU07QUFDaEUsZUFBTyxlQUFlLENBQUM7T0FDeEIsQ0FBQyxDQUFDO0FBQ0gsYUFBTyxDQUFDLElBQUksQ0FBQyxFQUFFLEVBQUUsWUFBWSxDQUFDLENBQUMsU0FBUyxDQUFDLFVBQUEsU0FBUyxFQUFJO0FBQ3BELGVBQ0UsTUFBTSxDQUFDLE1BQU0sQ0FBQyxpQkFBaUIsQ0FBQyxDQUFDLFFBQVEsQ0FBQyxTQUFTLENBQUMsSUFDcEQsQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxlQUFlLEVBQUUsQ0FBQyxZQUFZLENBQUMsQ0FDeEQ7T0FDSCxDQUFDLENBQUM7S0FDSixDQUFDLENBQUM7O0FBRUgsYUFBUyxDQUFDLFlBQVc7QUFDbkIsYUFBTyxDQUFDLE9BQU8sRUFBRSxDQUFDO0tBQ25CLENBQUMsQ0FBQzs7QUFFSCxNQUFFLENBQUMsbUNBQW1DLG9CQUFFLGFBQWlCO0FBQ3ZELFlBQU0sQ0FBQyxTQUFTLEVBQUMsTUFBTSxLQUFLLENBQUMsU0FBUyxFQUFFLENBQUEsRUFBRSxDQUFDLG9CQUFvQixDQUFDLENBQUMsQ0FBQztLQUNuRSxFQUFDLENBQUM7O0FBRUgsWUFBUSxDQUFDLGtCQUFrQixFQUFFLFlBQVc7QUFDdEMsZ0JBQVUsQ0FBQyxZQUFXO0FBQ3BCLFlBQUksQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDO09BQ3JCLENBQUMsQ0FBQzs7QUFFSCxRQUFFLENBQUMsOEJBQThCLG9CQUFFLGFBQWlCO0FBQ2xELGNBQU0sQ0FBQyxTQUFTLEVBQUMsTUFBTSxLQUFLLENBQUMsU0FBUyxFQUFFLENBQUEsRUFBRSxFQUFFLENBQUMsQ0FBQztPQUMvQyxFQUFDLENBQUM7S0FDSixDQUFDLENBQUM7O0FBRUgsWUFBUSxDQUFDLHdEQUF3RCxvQkFBRSxhQUFpQjtBQUNsRixnQkFBVSxDQUFDLFlBQVc7QUFDcEIsWUFBTSxRQUFRLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsVUFBVSxFQUFFLG9CQUFvQixDQUFDLENBQUM7QUFDdEUsWUFBTSxXQUFXLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FDM0IsT0FBTyxFQUNQLFVBQVUsRUFDVixPQUFPLEVBQ1AsVUFBVSxFQUNWLG9CQUFvQixDQUNyQixDQUFDO0FBQ0YsaUJBQVMsQ0FBQyxXQUFXLENBQUMsR0FBRyxRQUFRLENBQUM7T0FDbkMsQ0FBQyxDQUFDOztBQUVILFFBQUUsQ0FBQyxnREFBZ0Qsb0JBQUUsYUFBaUI7QUFDcEUsY0FBTSxDQUFDLFNBQVMsRUFBQyxNQUFNLEtBQUssQ0FBQyxTQUFTLEVBQUUsQ0FBQSxFQUFFLEVBQUUsQ0FBQyxDQUFDO09BQy9DLEVBQUMsQ0FBQztLQUNKLEVBQUMsQ0FBQztHQUNKLENBQUMsQ0FBQztDQUNKLENBQUMsQ0FBQyIsImZpbGUiOiIvYnVpbGQvYXRvbS9zcmMvYXRvbS9vdXQvYXBwL25vZGVfbW9kdWxlcy9kYWxlay90ZXN0L2RhbGVrLnRlc3QuanMiLCJzb3VyY2VzQ29udGVudCI6WyIvKiogQGJhYmVsICovXG5cbmNvbnN0IGFzc2VydCA9IHJlcXVpcmUoJ2Fzc2VydCcpO1xuY29uc3QgZnMgPSByZXF1aXJlKCdmcycpO1xuY29uc3Qgc2lub24gPSByZXF1aXJlKCdzaW5vbicpO1xuY29uc3QgcGF0aCA9IHJlcXVpcmUoJ3BhdGgnKTtcblxuY29uc3QgZGFsZWsgPSByZXF1aXJlKCcuLi9saWIvZGFsZWsnKTtcblxuZGVzY3JpYmUoJ2RhbGVrJywgZnVuY3Rpb24oKSB7XG4gIGRlc2NyaWJlKCdlbnVtZXJhdGUnLCBmdW5jdGlvbigpIHtcbiAgICBsZXQgYXZhaWxhYmxlUGFja2FnZXMgPSB7fTtcbiAgICBsZXQgcmVhbFBhdGhzID0ge307XG4gICAgbGV0IGJ1bmRsZWRQYWNrYWdlcyA9IFtdO1xuICAgIGxldCBwYWNrYWdlRGlyUGF0aHMgPSBbXTtcbiAgICBsZXQgc2FuZGJveCA9IG51bGw7XG5cbiAgICBiZWZvcmVFYWNoKGZ1bmN0aW9uKCkge1xuICAgICAgYXZhaWxhYmxlUGFja2FnZXMgPSB7XG4gICAgICAgICdhbi11bmR1cGxpY2F0ZWQtaW5zdGFsbGVkLXBhY2thZ2UnOiBwYXRoLmpvaW4oXG4gICAgICAgICAgJ1VzZXJzJyxcbiAgICAgICAgICAndXNlcm5hbWUnLFxuICAgICAgICAgICcuYXRvbScsXG4gICAgICAgICAgJ3BhY2thZ2VzJyxcbiAgICAgICAgICAnYW4tdW5kdXBsaWNhdGVkLWluc3RhbGxlZC1wYWNrYWdlJ1xuICAgICAgICApLFxuICAgICAgICAnZHVwbGljYXRlZC1wYWNrYWdlJzogcGF0aC5qb2luKFxuICAgICAgICAgICdVc2VycycsXG4gICAgICAgICAgJ3VzZXJuYW1lJyxcbiAgICAgICAgICAnLmF0b20nLFxuICAgICAgICAgICdwYWNrYWdlcycsXG4gICAgICAgICAgJ2R1cGxpY2F0ZWQtcGFja2FnZSdcbiAgICAgICAgKSxcbiAgICAgICAgJ3VuZHVwbGljYXRlZC1wYWNrYWdlJzogcGF0aC5qb2luKFxuICAgICAgICAgIGAke2F0b20uZ2V0TG9hZFNldHRpbmdzKCkucmVzb3VyY2VQYXRofWAsXG4gICAgICAgICAgJ25vZGVfbW9kdWxlcycsXG4gICAgICAgICAgJ3VuZHVwbGljYXRlZC1wYWNrYWdlJ1xuICAgICAgICApXG4gICAgICB9O1xuXG4gICAgICBhdG9tLmRldk1vZGUgPSBmYWxzZTtcbiAgICAgIGJ1bmRsZWRQYWNrYWdlcyA9IFsnZHVwbGljYXRlZC1wYWNrYWdlJywgJ3VuZHVwbGljYXRlZC1wYWNrYWdlJ107XG4gICAgICBwYWNrYWdlRGlyUGF0aHMgPSBbcGF0aC5qb2luKCdVc2VycycsICd1c2VybmFtZScsICcuYXRvbScsICdwYWNrYWdlcycpXTtcbiAgICAgIHNhbmRib3ggPSBzaW5vbi5zYW5kYm94LmNyZWF0ZSgpO1xuICAgICAgc2FuZGJveFxuICAgICAgICAuc3R1YihkYWxlaywgJ3JlYWxwYXRoJylcbiAgICAgICAgLmNhbGxzRmFrZShmaWxlUGF0aCA9PlxuICAgICAgICAgIFByb21pc2UucmVzb2x2ZShyZWFsUGF0aHNbZmlsZVBhdGhdIHx8IGZpbGVQYXRoKVxuICAgICAgICApO1xuICAgICAgc2FuZGJveC5zdHViKGF0b20ucGFja2FnZXMsICdpc0J1bmRsZWRQYWNrYWdlJykuY2FsbHNGYWtlKHBhY2thZ2VOYW1lID0+IHtcbiAgICAgICAgcmV0dXJuIGJ1bmRsZWRQYWNrYWdlcy5pbmNsdWRlcyhwYWNrYWdlTmFtZSk7XG4gICAgICB9KTtcbiAgICAgIHNhbmRib3hcbiAgICAgICAgLnN0dWIoYXRvbS5wYWNrYWdlcywgJ2dldEF2YWlsYWJsZVBhY2thZ2VOYW1lcycpXG4gICAgICAgIC5jYWxsc0Zha2UoKCkgPT4gT2JqZWN0LmtleXMoYXZhaWxhYmxlUGFja2FnZXMpKTtcbiAgICAgIHNhbmRib3guc3R1YihhdG9tLnBhY2thZ2VzLCAnZ2V0UGFja2FnZURpclBhdGhzJykuY2FsbHNGYWtlKCgpID0+IHtcbiAgICAgICAgcmV0dXJuIHBhY2thZ2VEaXJQYXRocztcbiAgICAgIH0pO1xuICAgICAgc2FuZGJveC5zdHViKGZzLCAnZXhpc3RzU3luYycpLmNhbGxzRmFrZShjYW5kaWRhdGUgPT4ge1xuICAgICAgICByZXR1cm4gKFxuICAgICAgICAgIE9iamVjdC52YWx1ZXMoYXZhaWxhYmxlUGFja2FnZXMpLmluY2x1ZGVzKGNhbmRpZGF0ZSkgJiZcbiAgICAgICAgICAhY2FuZGlkYXRlLmluY2x1ZGVzKGF0b20uZ2V0TG9hZFNldHRpbmdzKCkucmVzb3VyY2VQYXRoKVxuICAgICAgICApO1xuICAgICAgfSk7XG4gICAgfSk7XG5cbiAgICBhZnRlckVhY2goZnVuY3Rpb24oKSB7XG4gICAgICBzYW5kYm94LnJlc3RvcmUoKTtcbiAgICB9KTtcblxuICAgIGl0KCdyZXR1cm5zIGEgbGlzdCBvZiBkdXBsaWNhdGUgbmFtZXMnLCBhc3luYyBmdW5jdGlvbigpIHtcbiAgICAgIGFzc2VydC5kZWVwRXF1YWwoYXdhaXQgZGFsZWsuZW51bWVyYXRlKCksIFsnZHVwbGljYXRlZC1wYWNrYWdlJ10pO1xuICAgIH0pO1xuXG4gICAgZGVzY3JpYmUoJ3doZW4gaW4gZGV2IG1vZGUnLCBmdW5jdGlvbigpIHtcbiAgICAgIGJlZm9yZUVhY2goZnVuY3Rpb24oKSB7XG4gICAgICAgIGF0b20uZGV2TW9kZSA9IHRydWU7XG4gICAgICB9KTtcblxuICAgICAgaXQoJ2Fsd2F5cyByZXR1cm5zIGFuIGVtcHR5IGxpc3QnLCBhc3luYyBmdW5jdGlvbigpIHtcbiAgICAgICAgYXNzZXJ0LmRlZXBFcXVhbChhd2FpdCBkYWxlay5lbnVtZXJhdGUoKSwgW10pO1xuICAgICAgfSk7XG4gICAgfSk7XG5cbiAgICBkZXNjcmliZSgnd2hlbiBhIHBhY2thZ2UgaXMgc3ltbGlua2VkIGludG8gdGhlIHBhY2thZ2UgZGlyZWN0b3J5JywgYXN5bmMgZnVuY3Rpb24oKSB7XG4gICAgICBiZWZvcmVFYWNoKGZ1bmN0aW9uKCkge1xuICAgICAgICBjb25zdCByZWFsUGF0aCA9IHBhdGguam9pbignVXNlcnMnLCAndXNlcm5hbWUnLCAnZHVwbGljYXRlZC1wYWNrYWdlJyk7XG4gICAgICAgIGNvbnN0IHBhY2thZ2VQYXRoID0gcGF0aC5qb2luKFxuICAgICAgICAgICdVc2VycycsXG4gICAgICAgICAgJ3VzZXJuYW1lJyxcbiAgICAgICAgICAnLmF0b20nLFxuICAgICAgICAgICdwYWNrYWdlcycsXG4gICAgICAgICAgJ2R1cGxpY2F0ZWQtcGFja2FnZSdcbiAgICAgICAgKTtcbiAgICAgICAgcmVhbFBhdGhzW3BhY2thZ2VQYXRoXSA9IHJlYWxQYXRoO1xuICAgICAgfSk7XG5cbiAgICAgIGl0KCdpcyBub3QgaW5jbHVkZWQgaW4gdGhlIGxpc3Qgb2YgZHVwbGljYXRlIG5hbWVzJywgYXN5bmMgZnVuY3Rpb24oKSB7XG4gICAgICAgIGFzc2VydC5kZWVwRXF1YWwoYXdhaXQgZGFsZWsuZW51bWVyYXRlKCksIFtdKTtcbiAgICAgIH0pO1xuICAgIH0pO1xuICB9KTtcbn0pO1xuIl19