function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

/** @babel */

var fs = require('fs');
var path = require('path');

module.exports = {
  enumerate: _asyncToGenerator(function* () {
    if (atom.inDevMode()) {
      return [];
    }

    var duplicatePackages = [];
    var names = atom.packages.getAvailablePackageNames();
    for (var _name of names) {
      if (atom.packages.isBundledPackage(_name)) {
        var isDuplicatedPackage = yield this.isInstalledAsCommunityPackage(_name);
        if (isDuplicatedPackage) {
          duplicatePackages.push(_name);
        }
      }
    }

    return duplicatePackages;
  }),

  isInstalledAsCommunityPackage: _asyncToGenerator(function* (name) {
    var availablePackagePaths = atom.packages.getPackageDirPaths();

    for (var packagePath of availablePackagePaths) {
      var candidate = path.join(packagePath, name);

      if (fs.existsSync(candidate)) {
        var realPath = yield this.realpath(candidate);
        if (realPath === candidate) {
          return true;
        }
      }
    }

    return false;
  }),

  realpath: function realpath(path) {
    return new Promise(function (resolve, reject) {
      fs.realpath(path, function (error, realpath) {
        if (error) {
          reject(error);
        } else {
          resolve(realpath);
        }
      });
    });
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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