Object.defineProperty(exports, '__esModule', {
  value: true
});

var _slicedToArray = (function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i['return']) _i['return'](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError('Invalid attempt to destructure non-iterable instance'); } }; })();

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { var callNext = step.bind(null, 'next'); var callThrow = step.bind(null, 'throw'); function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(callNext, callThrow); } } callNext(); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atomSelectList = require('atom-select-list');

var _atomSelectList2 = _interopRequireDefault(_atomSelectList);

var _underscorePlus = require('underscore-plus');

var _fuzzaldrin = require('fuzzaldrin');

var _fuzzaldrin2 = _interopRequireDefault(_fuzzaldrin);

var _fuzzaldrinPlus = require('fuzzaldrin-plus');

var _fuzzaldrinPlus2 = _interopRequireDefault(_fuzzaldrinPlus);

var CommandPaletteView = (function () {
  function CommandPaletteView() {
    var _this = this;

    var initiallyVisibleItemCount = arguments.length <= 0 || arguments[0] === undefined ? 10 : arguments[0];

    _classCallCheck(this, CommandPaletteView);

    this.filter = function (items, query) {
      if (query.length === 0) {
        return items;
      }

      var scoredItems = [];
      for (var item of items) {
        var score = _this.fuzz.score(item.displayName, query);
        if (item.tags) {
          score += item.tags.reduce(function (currentScore, tag) {
            return currentScore + _this.fuzz.score(tag, query);
          }, 0);
        }
        if (item.description) {
          score += _this.fuzz.score(item.description, query);
        }

        if (score > 0) {
          scoredItems.push({ item: item, score: score });
        }
      }
      scoredItems.sort(function (a, b) {
        return b.score - a.score;
      });
      return scoredItems.map(function (i) {
        return i.item;
      });
    };

    this.keyBindingsForActiveElement = [];
    this.selectListView = new _atomSelectList2['default']({
      initiallyVisibleItemCount: initiallyVisibleItemCount, // just for being able to disable visible-on-render in spec
      items: [],
      filter: this.filter,
      emptyMessage: 'No matches found',
      elementForItem: function elementForItem(item, _ref) {
        var index = _ref.index;
        var selected = _ref.selected;
        var visible = _ref.visible;

        if (!visible) {
          return document.createElement("li");
        }

        var li = document.createElement('li');
        li.classList.add('event', 'two-lines');
        li.dataset.eventName = item.name;

        var rightBlock = document.createElement('div');
        rightBlock.classList.add('pull-right');

        _this.keyBindingsForActiveElement.filter(function (_ref2) {
          var command = _ref2.command;
          return command === item.name;
        }).forEach(function (keyBinding) {
          var kbd = document.createElement('kbd');
          kbd.classList.add('key-binding');
          kbd.textContent = (0, _underscorePlus.humanizeKeystroke)(keyBinding.keystrokes);
          rightBlock.appendChild(kbd);
        });
        li.appendChild(rightBlock);

        var leftBlock = document.createElement('div');
        var titleEl = document.createElement('div');
        titleEl.classList.add('primary-line');
        titleEl.title = item.name;
        leftBlock.appendChild(titleEl);

        var query = _this.selectListView.getQuery();
        _this.highlightMatchesInElement(item.displayName, query, titleEl);

        if (selected) {
          var secondaryEl = document.createElement('div');
          secondaryEl.classList.add('secondary-line');
          secondaryEl.style.display = 'flex';

          if (typeof item.description === 'string') {
            secondaryEl.appendChild(_this.createDescription(item.description, query));
          }

          if (Array.isArray(item.tags)) {
            var matchingTags = item.tags.map(function (t) {
              return [t, _this.fuzz.score(t, query)];
            }).filter(function (_ref3) {
              var _ref32 = _slicedToArray(_ref3, 2);

              var t = _ref32[0];
              var s = _ref32[1];
              return s > 0;
            }).sort(function (a, b) {
              return a.s - b.s;
            }).map(function (_ref4) {
              var _ref42 = _slicedToArray(_ref4, 2);

              var t = _ref42[0];
              var s = _ref42[1];
              return t;
            });

            if (matchingTags.length > 0) {
              secondaryEl.appendChild(_this.createTags(matchingTags, query));
            }
          }

          leftBlock.appendChild(secondaryEl);
        }

        li.appendChild(leftBlock);
        return li;
      },
      didConfirmSelection: function didConfirmSelection(keyBinding) {
        _this.hide();
        var event = new CustomEvent(keyBinding.name, { bubbles: true, cancelable: true });
        _this.activeElement.dispatchEvent(event);
      },
      didCancelSelection: function didCancelSelection() {
        _this.hide();
      }
    });
    this.selectListView.element.classList.add('command-palette');
  }

  _createClass(CommandPaletteView, [{
    key: 'destroy',
    value: _asyncToGenerator(function* () {
      yield this.selectListView.destroy();
    })
  }, {
    key: 'toggle',
    value: function toggle() {
      if (this.panel && this.panel.isVisible()) {
        this.hide();
        return Promise.resolve();
      } else {
        return this.show();
      }
    }
  }, {
    key: 'show',
    value: _asyncToGenerator(function* () {
      var showHiddenCommands = arguments.length <= 0 || arguments[0] === undefined ? false : arguments[0];

      if (!this.panel) {
        this.panel = atom.workspace.addModalPanel({ item: this.selectListView });
      }

      if (!this.preserveLastSearch) {
        this.selectListView.reset();
      } else {
        this.selectListView.refs.queryEditor.selectAll();
      }

      this.activeElement = document.activeElement === document.body ? atom.views.getView(atom.workspace) : document.activeElement;
      this.keyBindingsForActiveElement = atom.keymaps.findKeyBindings({ target: this.activeElement });
      var commandsForActiveElement = atom.commands.findCommands({ target: this.activeElement }).filter(function (command) {
        return showHiddenCommands === !!command.hiddenInCommandPalette;
      });
      commandsForActiveElement.sort(function (a, b) {
        return a.displayName.localeCompare(b.displayName);
      });
      yield this.selectListView.update({ items: commandsForActiveElement });

      this.previouslyFocusedElement = document.activeElement;
      this.panel.show();
      this.selectListView.focus();
    })
  }, {
    key: 'hide',
    value: function hide() {
      this.panel.hide();
      if (this.previouslyFocusedElement) {
        this.previouslyFocusedElement.focus();
        this.previouslyFocusedElement = null;
      }
    }
  }, {
    key: 'update',
    value: _asyncToGenerator(function* (props) {
      if (props.hasOwnProperty('preserveLastSearch')) {
        this.preserveLastSearch = props.preserveLastSearch;
      }

      if (props.hasOwnProperty('useAlternateScoring')) {
        this.useAlternateScoring = props.useAlternateScoring;
      }
    })
  }, {
    key: 'highlightMatchesInElement',
    value: function highlightMatchesInElement(text, query, el) {
      var matches = this.fuzz.match(text, query);
      var matchedChars = [];
      var lastIndex = 0;
      for (var matchIndex of matches) {
        var _unmatched = text.substring(lastIndex, matchIndex);
        if (_unmatched) {
          if (matchedChars.length > 0) {
            var matchSpan = document.createElement('span');
            matchSpan.classList.add('character-match');
            matchSpan.textContent = matchedChars.join('');
            el.appendChild(matchSpan);
            matchedChars = [];
          }

          el.appendChild(document.createTextNode(_unmatched));
        }

        matchedChars.push(text[matchIndex]);
        lastIndex = matchIndex + 1;
      }

      if (matchedChars.length > 0) {
        var matchSpan = document.createElement('span');
        matchSpan.classList.add('character-match');
        matchSpan.textContent = matchedChars.join('');
        el.appendChild(matchSpan);
      }

      var unmatched = text.substring(lastIndex);
      if (unmatched) {
        el.appendChild(document.createTextNode(unmatched));
      }
    }
  }, {
    key: 'createDescription',
    value: function createDescription(description, query) {
      var descriptionEl = document.createElement('div');

      // in case of overflow, give full contents on long hover
      descriptionEl.title = description;

      Object.assign(descriptionEl.style, {
        flexGrow: 1,
        flexShrink: 1,
        textOverflow: 'ellipsis',
        whiteSpace: 'nowrap',
        overflow: 'hidden'
      });
      this.highlightMatchesInElement(description, query, descriptionEl);
      return descriptionEl;
    }
  }, {
    key: 'createTag',
    value: function createTag(tagText, query) {
      var tagEl = document.createElement('li');
      Object.assign(tagEl.style, {
        borderBottom: 0,
        display: 'inline',
        padding: 0
      });
      this.highlightMatchesInElement(tagText, query, tagEl);
      return tagEl;
    }
  }, {
    key: 'createTags',
    value: function createTags(matchingTags, query) {
      var _this2 = this;

      var tagsEl = document.createElement('ol');
      Object.assign(tagsEl.style, {
        display: 'inline',
        marginLeft: '4px',
        flexShrink: 0,
        padding: 0
      });

      var introEl = document.createElement('strong');
      introEl.textContent = 'matching tags: ';

      tagsEl.appendChild(introEl);
      matchingTags.map(function (t) {
        return _this2.createTag(t, query);
      }).forEach(function (tagEl, i) {
        tagsEl.appendChild(tagEl);
        if (i < matchingTags.length - 1) {
          var commaSpace = document.createElement('span');
          commaSpace.textContent = ', ';
          tagsEl.appendChild(commaSpace);
        }
      });
      return tagsEl;
    }
  }, {
    key: 'fuzz',
    get: function get() {
      return this.useAlternateScoring ? _fuzzaldrinPlus2['default'] : _fuzzaldrin2['default'];
    }
  }]);

  return CommandPaletteView;
})();

exports['default'] = CommandPaletteView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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