/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
'use strict';

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread"));

var compileGraphQLTag = require("./compileGraphQLTag");

var compileRelayQLTag = require("./compileRelayQLTag");

var getDocumentName = require("./getDocumentName");

var getValidGraphQLTag = require("./getValidGraphQLTag");

var getValidRelayQLTag = require("./getValidRelayQLTag");

var invariant = require("./invariant");

var RelayConfig;

try {
  // eslint-disable-next-line no-eval
  RelayConfig = eval('require')('relay-config'); // eslint-disable-next-line lint/no-unused-catch-bindings
} catch (_) {}

/**
 * Using babel-plugin-relay with only the modern runtime?
 *
 *     {
 *       plugins: [
 *         "relay"
 *       ]
 *     }
 *
 * Using babel-plugin-relay in compatability or classic mode?
 *
 *     {
 *       plugins: [
 *         ["relay", {"compat": true, "schema": "path/to/schema.graphql"}]
 *       ]
 *     }
 *
 */
module.exports = function BabelPluginRelay(context) {
  var t = context.types;

  if (!t) {
    throw new Error('BabelPluginRelay: Expected plugin context to include "types", but got:' + String(context));
  }

  var visitor = {
    TaggedTemplateExpression: function TaggedTemplateExpression(path, state) {
      // Convert graphql`` literals
      var ast = getValidGraphQLTag(path);

      if (ast) {
        compileGraphQLTag(t, path, state, ast);
        return;
      } // Convert Relay.QL`` literals


      var _getValidRelayQLTag = getValidRelayQLTag(path),
          quasi = _getValidRelayQLTag[0],
          tagName = _getValidRelayQLTag[1],
          propName = _getValidRelayQLTag[2];

      if (quasi && tagName) {
        var schema = state.opts && state.opts.schema;
        !schema ? process.env.NODE_ENV !== "production" ? invariant(false, 'babel-plugin-relay: Missing schema option. ' + 'Check your .babelrc file or wherever you configure your Babel ' + 'plugins to ensure the "relay" plugin has a "schema" option.\n' + 'https://relay.dev/docs/en/installation-and-setup#set-up-babel-plugin-relay') : invariant(false) : void 0;
        var documentName = getDocumentName(path, state);
        path.replaceWith(compileRelayQLTag(t, path, schema, quasi, documentName, propName, tagName, true, // enableValidation
        state));
      }
    }
  };
  return {
    visitor: {
      Program: function Program(path, state) {
        var config = RelayConfig && RelayConfig.loadConfig();
        path.traverse(visitor, (0, _objectSpread2["default"])({}, state, {
          opts: (0, _objectSpread2["default"])({}, config, state.opts)
        }));
      }
    }
  };
};