(function() {
  var convertMethodToSuggestion, convertPropertyToSuggestion, fs, getDocLink, isVisible, request, requestOptions, textComparator;

  fs = require('fs');

  request = require('request');

  requestOptions = {
    url: 'https://api.github.com/repos/atom/atom/releases/latest',
    json: true,
    headers: {
      'User-Agent': 'agent'
    }
  };

  request(requestOptions, function(error, response, release) {
    var apiAsset, apiRequestOptions;
    if (error != null) {
      console.error(error.message);
      return process.exit(1);
    }
    apiAsset = release.assets.filter(function(arg1) {
      var name;
      name = arg1.name;
      return name === 'atom-api.json';
    })[0];
    if (!(apiAsset != null ? apiAsset.browser_download_url : void 0)) {
      console.error('No atom-api.json asset found in latest release');
      return process.exit(1);
    }
    apiRequestOptions = {
      json: true,
      url: apiAsset.browser_download_url
    };
    return request(apiRequestOptions, function(error, response, atomApi) {
      var classes, instanceMethods, instanceProperties, methods, name, pluckMethodAttributes, pluckPropertyAttributes, properties, publicClasses, ref;
      if (error != null) {
        console.error(error.message);
        return process.exit(1);
      }
      classes = atomApi.classes;
      publicClasses = {};
      for (name in classes) {
        ref = classes[name], instanceProperties = ref.instanceProperties, instanceMethods = ref.instanceMethods;
        pluckPropertyAttributes = convertPropertyToSuggestion.bind(this, name);
        pluckMethodAttributes = convertMethodToSuggestion.bind(this, name);
        properties = instanceProperties.filter(isVisible).map(pluckPropertyAttributes).sort(textComparator);
        methods = instanceMethods.filter(isVisible).map(pluckMethodAttributes).sort(textComparator);
        if ((properties != null ? properties.length : void 0) > 0 || methods.length > 0) {
          publicClasses[name] = properties.concat(methods);
        }
      }
      return fs.writeFileSync('completions.json', JSON.stringify(publicClasses, null, '  '));
    });
  });

  isVisible = function(arg1) {
    var visibility;
    visibility = arg1.visibility;
    return visibility === 'Essential' || visibility === 'Extended' || visibility === 'Public';
  };

  convertMethodToSuggestion = function(className, method) {
    var arg, args, description, descriptionMoreURL, i, j, len, name, ref, returnValue, returnValues, snippet, snippets, summary, text;
    name = method.name, summary = method.summary, returnValues = method.returnValues;
    args = method['arguments'];
    snippets = [];
    if (args != null ? args.length : void 0) {
      for (i = j = 0, len = args.length; j < len; i = ++j) {
        arg = args[i];
        snippets.push("${" + (i + 1) + ":" + arg.name + "}");
      }
    }
    text = null;
    snippet = null;
    if (snippets.length) {
      snippet = name + "(" + (snippets.join(', ')) + ")";
    } else {
      text = name + "()";
    }
    returnValue = returnValues != null ? (ref = returnValues[0]) != null ? ref.type : void 0 : void 0;
    description = summary;
    descriptionMoreURL = getDocLink(className, name);
    return {
      name: name,
      text: text,
      snippet: snippet,
      description: description,
      descriptionMoreURL: descriptionMoreURL,
      leftLabel: returnValue,
      type: 'method'
    };
  };

  convertPropertyToSuggestion = function(className, arg1) {
    var description, descriptionMoreURL, name, ref, returnValue, summary, text;
    name = arg1.name, summary = arg1.summary;
    text = name;
    returnValue = summary != null ? (ref = summary.match(/\{(\w+)\}/)) != null ? ref[1] : void 0 : void 0;
    description = summary;
    descriptionMoreURL = getDocLink(className, name);
    return {
      name: name,
      text: text,
      description: description,
      descriptionMoreURL: descriptionMoreURL,
      leftLabel: returnValue,
      type: 'property'
    };
  };

  getDocLink = function(className, instanceName) {
    return "https://atom.io/docs/api/latest/" + className + "#instance-" + instanceName;
  };

  textComparator = function(a, b) {
    if (a.name > b.name) {
      return 1;
    }
    if (a.name < b.name) {
      return -1;
    }
    return 0;
  };

}).call(this);

//# sourceMappingURL=data:application/json;base64,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
