Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _atom = require('atom');

var _path = require('path');

var _path2 = _interopRequireDefault(_path);

var _fsPlus = require('fs-plus');

var _fsPlus2 = _interopRequireDefault(_fsPlus);

var _temp = require('temp');

var _temp2 = _interopRequireDefault(_temp);

var _lsArchive = require('ls-archive');

var _lsArchive2 = _interopRequireDefault(_lsArchive);

var _getIconServices = require('./get-icon-services');

var _getIconServices2 = _interopRequireDefault(_getIconServices);

var FileView = (function () {
  function FileView(parentView, indexInParentView, archivePath, entry) {
    var _this = this;

    _classCallCheck(this, FileView);

    this.disposables = new _atom.CompositeDisposable();
    this.parentView = parentView;
    this.indexInParentView = indexInParentView;
    this.archivePath = archivePath;
    this.entry = entry;

    this.element = document.createElement('li');
    this.element.classList.add('list-item', 'entry');
    this.element.tabIndex = -1;

    this.name = document.createElement('span');
    (0, _getIconServices2['default'])().updateFileIcon(this);
    this.name.textContent = this.entry.getName();
    this.element.appendChild(this.name);

    var clickHandler = function clickHandler() {
      _this.select();
      _this.openFile();
    };
    this.element.addEventListener('click', clickHandler);
    this.disposables.add(new _atom.Disposable(function () {
      _this.element.removeEventListener('click', clickHandler);
    }));

    this.disposables.add(atom.commands.add(this.element, {
      'core:confirm': function coreConfirm() {
        if (_this.isSelected()) {
          _this.openFile();
        }
      },

      'core:move-down': function coreMoveDown() {
        if (_this.isSelected()) {
          _this.parentView.selectFileAfterIndex(_this.indexInParentView);
        }
      },

      'core:move-up': function coreMoveUp() {
        if (_this.isSelected()) {
          _this.parentView.selectFileBeforeIndex(_this.indexInParentView);
        }
      }
    }));
  }

  _createClass(FileView, [{
    key: 'destroy',
    value: function destroy() {
      this.disposables.dispose();
      this.element.remove();
    }
  }, {
    key: 'isSelected',
    value: function isSelected() {
      return this.element.classList.contains('selected');
    }
  }, {
    key: 'logError',
    value: function logError(message, error) {
      console.error(message, error.stack != null ? error.stack : error);
    }
  }, {
    key: 'openFile',
    value: function openFile() {
      var _this2 = this;

      _lsArchive2['default'].readFile(this.archivePath, this.entry.getPath(), function (error, contents) {
        if (error != null) {
          _this2.logError('Error reading: ' + _this2.entry.getPath() + ' from ' + _this2.archivePath, error);
        } else {
          _temp2['default'].mkdir('atom-', function (error, tempDirPath) {
            if (error != null) {
              _this2.logError('Error creating temp directory: ' + tempDirPath, error);
            } else {
              (function () {
                var tempFilePath = _path2['default'].join(tempDirPath, _path2['default'].basename(_this2.archivePath), _this2.entry.getName());
                _fsPlus2['default'].writeFile(tempFilePath, contents, function (error) {
                  if (error != null) {
                    return _this2.logError('Error writing to ' + tempFilePath, error);
                  } else {
                    return atom.workspace.open(tempFilePath);
                  }
                });
              })();
            }
          });
        }
      });
    }
  }, {
    key: 'select',
    value: function select() {
      this.element.focus();

      var archiveEditorElement = this.element.closest('.archive-editor');
      // On initial tree creation, it is not possible for any entries to be selected
      // (The entries also haven't been added to the DOM yet)
      if (archiveEditorElement) {
        for (var selected of archiveEditorElement.querySelectorAll('.selected')) {
          selected.classList.remove('selected');
        }
      }
      this.element.classList.add('selected');
    }
  }]);

  return FileView;
})();

exports['default'] = FileView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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