Object.defineProperty(exports, '__esModule', {
  value: true
});

var _createClass = (function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ('value' in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; })();

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError('Cannot call a class as a function'); } }

/** @babel */

var _fileView = require('./file-view');

var _fileView2 = _interopRequireDefault(_fileView);

var _getIconServices = require('./get-icon-services');

var _getIconServices2 = _interopRequireDefault(_getIconServices);

var DirectoryView = (function () {
  function DirectoryView(parentView, indexInParentView, archivePath, entry) {
    _classCallCheck(this, DirectoryView);

    this.entries = [];
    this.parentView = parentView;
    this.indexInParentView = indexInParentView;
    this.element = document.createElement('li');
    this.element.classList.add('list-nested-item', 'entry');

    var listItem = document.createElement('span');
    listItem.classList.add('list-item');

    var entrySpan = document.createElement('span');
    entrySpan.textContent = entry.getName();
    listItem.appendChild(entrySpan);
    this.element.appendChild(listItem);

    this.entry = entry;
    this.entrySpan = entrySpan;
    (0, _getIconServices2['default'])().updateDirectoryIcon(this);

    this.entriesTree = document.createElement('ol');
    this.entriesTree.classList.add('list-tree');
    var index = 0;
    for (var child of entry.children) {
      if (child.isDirectory()) {
        var entryView = new DirectoryView(this, index, archivePath, child);
        this.entries.push(entryView);
        this.entriesTree.appendChild(entryView.element);
      } else {
        var entryView = new _fileView2['default'](this, index, archivePath, child);
        this.entries.push(entryView);
        this.entriesTree.appendChild(entryView.element);
      }

      index++;
    }
    this.element.appendChild(this.entriesTree);
  }

  _createClass(DirectoryView, [{
    key: 'destroy',
    value: function destroy() {
      if (this.iconDisposable) {
        this.iconDisposable.dispose();
        this.iconDisposable = null;
      }

      while (this.entries.length > 0) {
        this.entries.pop().destroy();
      }

      this.element.remove();
    }
  }, {
    key: 'selectFileBeforeIndex',
    value: function selectFileBeforeIndex(index) {
      for (var i = index - 1; i >= 0; i--) {
        var previousEntry = this.entries[i];
        if (previousEntry instanceof _fileView2['default']) {
          previousEntry.select();
          return;
        } else {
          if (previousEntry.selectLastFile()) {
            return;
          }
        }
      }

      this.parentView.selectFileBeforeIndex(this.indexInParentView);
    }
  }, {
    key: 'selectFileAfterIndex',
    value: function selectFileAfterIndex(index) {
      for (var i = index + 1; i < this.entries.length; i++) {
        var nextEntry = this.entries[i];
        if (nextEntry instanceof _fileView2['default']) {
          nextEntry.select();
          return;
        } else {
          if (nextEntry.selectFirstFile()) {
            return;
          }
        }
      }

      this.parentView.selectFileAfterIndex(this.indexInParentView);
    }
  }, {
    key: 'selectFirstFile',
    value: function selectFirstFile() {
      for (var entry of this.entries) {
        if (entry instanceof _fileView2['default']) {
          entry.select();
          return true;
        } else {
          if (entry.selectFirstFile()) {
            return true;
          }
        }
      }

      return false;
    }
  }, {
    key: 'selectLastFile',
    value: function selectLastFile() {
      for (var i = this.entries.length - 1; i >= 0; i--) {
        var entry = this.entries[i];
        if (entry instanceof _fileView2['default']) {
          entry.select();
          return true;
        } else {
          if (entry.selectLastFile()) {
            return true;
          }
        }
      }

      return false;
    }
  }]);

  return DirectoryView;
})();

exports['default'] = DirectoryView;
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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