/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.letsmt;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.tokenize.Detokenizer;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

public class DetokenizeSentenceSampleStream
extends FilterObjectStream<SentenceSample, SentenceSample> {
    private final Detokenizer detokenizer;

    public DetokenizeSentenceSampleStream(Detokenizer detokenizer, ObjectStream<SentenceSample> samples) {
        super(samples);
        this.detokenizer = Objects.requireNonNull(detokenizer);
    }

    @Override
    public SentenceSample read() throws IOException {
        SentenceSample sample = (SentenceSample)this.samples.read();
        if (sample != null) {
            ArrayList<String> sentenceTexts = new ArrayList<String>();
            for (Span sentenceSpan : sample.getSentences()) {
                sentenceTexts.add(sample.getDocument().substring(sentenceSpan.getStart(), sentenceSpan.getEnd()));
            }
            StringBuilder documentText = new StringBuilder();
            ArrayList<Span> newSentenceSpans = new ArrayList<Span>();
            for (String sentenceText : sentenceTexts) {
                String[] tokens = WhitespaceTokenizer.INSTANCE.tokenize(sentenceText);
                int begin = documentText.length();
                documentText.append(this.detokenizer.detokenize(tokens, null));
                newSentenceSpans.add(new Span(begin, documentText.length()));
                documentText.append(' ');
            }
            return new SentenceSample(documentText, newSentenceSpans.toArray(new Span[newSentenceSpans.size()]));
        }
        return null;
    }
}

