/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.languagetool.rules.patterns.PatternToken;

public class PatternRuleLoaderTest {
    @Test
    public void testGetRules() throws Exception {
        PatternRuleLoader prg = new PatternRuleLoader();
        String name = "/xx/grammar.xml";
        List rules = prg.getRules(JLanguageTool.getDataBroker().getFromRulesDirAsStream(name), name);
        Assert.assertTrue((rules.size() >= 30 ? 1 : 0) != 0);
        Rule demoRule1 = this.getRuleById("DEMO_RULE", rules);
        Assert.assertEquals((Object)"http://fake-server.org/foo-bar-error-explained", (Object)demoRule1.getUrl().toString());
        Assert.assertEquals((Object)"[This is <marker>fuu bah</marker>.]", (Object)demoRule1.getCorrectExamples().toString());
        List incorrectExamples = demoRule1.getIncorrectExamples();
        Assert.assertEquals((long)1L, (long)incorrectExamples.size());
        Assert.assertEquals((Object)"This is <marker>foo bar</marker>.", (Object)((IncorrectExample)incorrectExamples.get(0)).getExample());
        Rule demoRule2 = this.getRuleById("API_OUTPUT_TEST_RULE", rules);
        Assert.assertNull((Object)demoRule2.getUrl());
        Assert.assertEquals((Object)ITSIssueType.Uncategorized, (Object)demoRule1.getLocQualityIssueType());
        Assert.assertEquals((String)"tag inheritance failed", (Object)ITSIssueType.Addition, (Object)this.getRuleById("TEST_GO", rules).getLocQualityIssueType());
        Assert.assertEquals((String)"tag inheritance overwrite failed", (Object)ITSIssueType.Uncategorized, (Object)this.getRuleById("TEST_PHRASES1", rules).getLocQualityIssueType());
        Assert.assertEquals((String)"tag inheritance overwrite failed", (Object)ITSIssueType.Characters, (Object)this.getRuleById("test_include", rules).getLocQualityIssueType());
        List<Rule> groupRules1 = this.getRulesById("test_spacebefore", rules);
        Assert.assertEquals((String)"tag inheritance form category failed", (Object)ITSIssueType.Addition, (Object)groupRules1.get(0).getLocQualityIssueType());
        Assert.assertEquals((String)"tag inheritance overwrite failed", (Object)ITSIssueType.Duplication, (Object)groupRules1.get(1).getLocQualityIssueType());
        List<Rule> groupRules2 = this.getRulesById("test_unification_with_negation", rules);
        Assert.assertEquals((String)"tag inheritance from rulegroup failed", (Object)ITSIssueType.Grammar, (Object)groupRules2.get(0).getLocQualityIssueType());
        Set<String> categories = this.getCategoryNames(rules);
        Assert.assertEquals((long)5L, (long)categories.size());
        Assert.assertTrue((boolean)categories.contains("misc"));
        Assert.assertTrue((boolean)categories.contains("otherCategory"));
        Assert.assertTrue((boolean)categories.contains("Test tokens with min and max attributes"));
        Assert.assertTrue((boolean)categories.contains("A category that's off by default"));
        PatternRule demoRuleWithChunk = (PatternRule)this.getRuleById("DEMO_CHUNK_RULE", rules);
        List patternTokens = demoRuleWithChunk.getPatternTokens();
        Assert.assertEquals((long)2L, (long)patternTokens.size());
        Assert.assertEquals(null, (Object)((PatternToken)patternTokens.get(1)).getPOStag());
        Assert.assertEquals((Object)new ChunkTag("B-NP-singular"), (Object)((PatternToken)patternTokens.get(1)).getChunkTag());
        List<Rule> orRules = this.getRulesById("GROUP_WITH_URL", rules);
        Assert.assertEquals((long)3L, (long)orRules.size());
        Assert.assertEquals((Object)"http://fake-server.org/rule-group-url", (Object)orRules.get(0).getUrl().toString());
        Assert.assertEquals((Object)"http://fake-server.org/rule-group-url-overwrite", (Object)orRules.get(1).getUrl().toString());
        Assert.assertEquals((Object)"http://fake-server.org/rule-group-url", (Object)orRules.get(2).getUrl().toString());
        Assert.assertEquals((Object)"short message on rule group", (Object)((PatternRule)orRules.get(0)).getShortMessage());
        Assert.assertEquals((Object)"overwriting short message", (Object)((PatternRule)orRules.get(1)).getShortMessage());
        Assert.assertEquals((Object)"short message on rule group", (Object)((PatternRule)orRules.get(2)).getShortMessage());
        List<Rule> orRules2 = this.getRulesById("OR_GROUPS", rules);
        for (Rule rule : orRules2) {
            Assert.assertNull((String)"http://fake-server.org/rule-group-url", (Object)rule.getUrl());
        }
        Rule nextRule = this.getRuleById("DEMO_CHUNK_RULE", rules);
        Assert.assertNull((String)"http://fake-server.org/rule-group-url", (Object)nextRule.getUrl());
    }

    private Set<String> getCategoryNames(List<AbstractPatternRule> rules) {
        HashSet<String> categories = new HashSet<String>();
        for (AbstractPatternRule rule : rules) {
            categories.add(rule.getCategory().getName());
        }
        return categories;
    }

    private Rule getRuleById(String id, List<AbstractPatternRule> rules) {
        for (Rule rule : rules) {
            if (!rule.getId().equals(id)) continue;
            return rule;
        }
        throw new RuntimeException("No rule found for id '" + id + "'");
    }

    private List<Rule> getRulesById(String id, List<AbstractPatternRule> rules) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        for (Rule rule : rules) {
            if (!rule.getId().equals(id)) continue;
            result.add(rule);
        }
        return result;
    }
}

