/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.PixelGrabber;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private static MediaTracker mTracker = new MediaTracker(new JPanel());
    private Image image;
    private int imageAlign;

    public ImagePanel(Image image) {
        this(image, 1);
    }

    public ImagePanel(Image image, int n) {
        this.setImage(image);
        this.setImageAlign(n);
    }

    public void setImage(Image image) {
        this.image = ImagePanel.loadImage(image);
        if (this.image == null) {
            throw new RuntimeException("Failed to load image");
        }
        this.setPreferredBackground();
        this.setPreferredSize(new Dimension(this.image.getWidth(null), this.image.getHeight(null)));
        this.refresh();
    }

    public void setImageAlign(int n) {
        this.imageAlign = n;
        this.setPreferredBackground();
        this.refresh();
    }

    protected static Image loadImage(Image image) {
        mTracker.addImage(image, 0);
        try {
            mTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        mTracker.removeImage(image, 0);
        return image;
    }

    protected void setPreferredBackground() {
        int[] nArray = new int[1];
        PixelGrabber pixelGrabber = null;
        switch (this.imageAlign) {
            case 1: {
                pixelGrabber = new PixelGrabber(this.image, 0, this.image.getHeight(null) - 1, 1, 1, nArray, 0, 1);
                break;
            }
            case 3: {
                pixelGrabber = new PixelGrabber(this.image, 0, 0, 1, 1, nArray, 0, 1);
                break;
            }
            default: {
                pixelGrabber = new PixelGrabber(this.image, 0, this.image.getHeight(null) - 1, 1, 1, nArray, 0, 1);
            }
        }
        try {
            if (pixelGrabber != null && pixelGrabber.grabPixels()) {
                this.setBackground(new Color(nArray[0]));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        switch (this.imageAlign) {
            case 1: {
                graphics.drawImage(this.image, (this.getWidth() - this.image.getWidth(null)) / 2, 0, this);
                break;
            }
            case 3: {
                graphics.drawImage(this.image, (this.getWidth() - this.image.getWidth(null)) / 2, this.getHeight() - this.image.getHeight(null), this);
                break;
            }
            default: {
                graphics.drawImage(this.image, (this.getWidth() - this.image.getWidth(null)) / 2, 0, this);
            }
        }
    }

    private void refresh() {
        if (this.isShowing()) {
            this.invalidate();
            this.repaint();
        }
    }
}

