/*
 * Decompiled with CFR 0.152.
 */
package sun.management.counter;

import sun.management.counter.Counter;
import sun.management.counter.Units;
import sun.management.counter.Variability;

public abstract class AbstractCounter
implements Counter {
    String name;
    Units units;
    Variability variability;
    int flags;
    int vectorLength;
    private static final long serialVersionUID = 6992337162326171013L;

    protected AbstractCounter(String string, Units units, Variability variability, int n, int n2) {
        this.name = string;
        this.units = units;
        this.variability = variability;
        this.flags = n;
        this.vectorLength = n2;
    }

    protected AbstractCounter(String string, Units units, Variability variability, int n) {
        this(string, units, variability, n, 0);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Units getUnits() {
        return this.units;
    }

    @Override
    public Variability getVariability() {
        return this.variability;
    }

    @Override
    public boolean isVector() {
        return this.vectorLength > 0;
    }

    @Override
    public int getVectorLength() {
        return this.vectorLength;
    }

    @Override
    public boolean isInternal() {
        return (this.flags & 1) == 0;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public abstract Object getValue();

    public String toString() {
        String string = this.getName() + ": " + this.getValue() + " " + this.getUnits();
        if (this.isInternal()) {
            return string + " [INTERNAL]";
        }
        return string;
    }

    class Flags {
        static final int SUPPORTED = 1;

        Flags() {
        }
    }
}

