#ifndef _EFL_UI_SELECTION_EO_H_
#define _EFL_UI_SELECTION_EO_H_

#ifndef _EFL_UI_SELECTION_EO_CLASS_TYPE
#define _EFL_UI_SELECTION_EO_CLASS_TYPE

typedef Eo Efl_Ui_Selection;

#endif

#ifndef _EFL_UI_SELECTION_EO_TYPES
#define _EFL_UI_SELECTION_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/** Efl Ui Selection class
 *
 * @ingroup Efl_Ui_Selection
 */
#define EFL_UI_SELECTION_MIXIN efl_ui_selection_mixin_get()

EWAPI const Efl_Class *efl_ui_selection_mixin_get(void);

/**
 * @brief Set the selection data to the object
 *
 * @param[in] obj The object.
 * @param[in] type Selection Type
 * @param[in] format Selection Format
 * @param[in] data Selection data
 * @param[in] seat Specified seat for multiple seats case.
 *
 * @return Future for tracking when the selection is lost
 *
 * @ingroup Efl_Ui_Selection
 */
EOAPI Eina_Future *efl_ui_selection_set(Eo *obj, Efl_Ui_Selection_Type type, Efl_Ui_Selection_Format format, Eina_Slice data, unsigned int seat);

/**
 * @brief Get the data from the object that has selection
 *
 * @param[in] obj The object.
 * @param[in] type Selection Type
 * @param[in] format Selection Format
 * @param[in] data_func Data ready function pointer
 * @param[in] seat Specified seat for multiple seats case.
 *
 * @ingroup Efl_Ui_Selection
 */
EOAPI void efl_ui_selection_get(Eo *obj, Efl_Ui_Selection_Type type, Efl_Ui_Selection_Format format, void *data_func_data, Efl_Ui_Selection_Data_Ready data_func, Eina_Free_Cb data_func_free_cb, unsigned int seat);

/**
 * @brief Clear the selection data from the object
 *
 * @param[in] obj The object.
 * @param[in] type Selection Type
 * @param[in] seat Specified seat for multiple seats case.
 *
 * @ingroup Efl_Ui_Selection
 */
EOAPI void efl_ui_selection_clear(Eo *obj, Efl_Ui_Selection_Type type, unsigned int seat);

/**
 * @brief Determine whether the selection data has owner
 *
 * @param[in] obj The object.
 * @param[in] type Selection type
 * @param[in] seat Specified seat for multiple seats case.
 *
 * @return EINA_TRUE if there is object owns selection, otherwise EINA_FALSE
 *
 * @ingroup Efl_Ui_Selection
 */
EOAPI Eina_Bool efl_ui_selection_has_owner(Eo *obj, Efl_Ui_Selection_Type type, unsigned int seat);

EWAPI extern const Efl_Event_Description _EFL_UI_SELECTION_EVENT_WM_SELECTION_CHANGED;

/** Called when display server's selection has changed
 * @return Efl_Ui_Selection_Changed
 *
 * @ingroup Efl_Ui_Selection
 */
#define EFL_UI_SELECTION_EVENT_WM_SELECTION_CHANGED (&(_EFL_UI_SELECTION_EVENT_WM_SELECTION_CHANGED))
#endif /* EFL_BETA_API_SUPPORT */

#endif
