/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.DataLayout;
import sun.jvm.hotspot.oops.MethodData;

public abstract class ProfileData {
    private DataLayout _data;

    public DataLayout data() {
        return this._data;
    }

    public abstract int cellCount();

    public int sizeInBytes() {
        return DataLayout.computeSizeInBytes(this.cellCount());
    }

    public int dp() {
        return this.data().dp();
    }

    int intptrAt(int index) {
        return this.data().cellAt(index);
    }

    int intAt(int index) {
        return this.intptrAt(index);
    }

    int uintAt(int index) {
        return this.intptrAt(index);
    }

    public Address addressAt(int index) {
        return this.data().addressAt(index);
    }

    boolean flagAt(int flagNumber) {
        return this.data().flagAt(flagNumber);
    }

    public static int cellOffset(int index) {
        return DataLayout.cellOffset(index);
    }

    public ProfileData(DataLayout data) {
        this._data = data;
    }

    ProfileData() {
        this._data = null;
    }

    int bci() {
        return this.data().bci();
    }

    int trapState() {
        return this.data().trapState();
    }

    public abstract void printDataOn(PrintStream var1);

    void tab(PrintStream st) {
        st.print("\t");
    }

    void printShared(PrintStream st, String name) {
        int flags;
        st.print("bci: " + this.bci());
        st.print(" " + name + " ");
        this.tab(st);
        int trap = this.trapState();
        if (trap != 0) {
            st.print("trap(" + MethodData.formatTrapState(trap) + ") ");
        }
        if ((flags = this.data().flags()) != 0) {
            st.print("flags(" + flags + ") ");
        }
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        try {
            this.printDataOn(ps);
        }
        finally {
            ps.close();
        }
        return baos.toString();
    }
}

