
/*
 * Copyright (C) 2010-2016 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IPerformanceMetric.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
The IPerformanceMetric interface represents parameters of the given
performance metric.

Interface ID: <tt>{81314D14-FD1C-411A-95C5-E9BB1414E632}</tt>
*/
public class IPerformanceMetric extends IUnknown
{

    public IPerformanceMetric(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
Name of the metric.
@return String
*/
    public String getMetricName()
    {
        try
        {
            String retVal = port.iPerformanceMetricGetMetricName(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Object this metric belongs to.
@return IUnknown
*/
    public IUnknown getObject()
    {
        this.getObjMgr().preventObjRelease();
        try
        {
            String retVal = port.iPerformanceMetricGetObject(obj);
            return (retVal.length() > 0) ? new IUnknown(retVal, getObjMgr(), port) : null;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        finally
        {
            getObjMgr().allowObjRelease();
        }
    }

/**
Textual description of the metric.
@return String
*/
    public String getDescription()
    {
        try
        {
            String retVal = port.iPerformanceMetricGetDescription(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Time interval between samples, measured in seconds.
@return Long
*/
    public Long getPeriod()
    {
        try
        {
            Long retVal = port.iPerformanceMetricGetPeriod(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Number of recent samples retained by the performance collector for this
metric.

When the collected sample count exceeds this number, older samples
are discarded.
@return Long
*/
    public Long getCount()
    {
        try
        {
            Long retVal = port.iPerformanceMetricGetCount(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Unit of measurement.
@return String
*/
    public String getUnit()
    {
        try
        {
            String retVal = port.iPerformanceMetricGetUnit(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Minimum possible value of this metric.
@return Integer
*/
    public Integer getMinimumValue()
    {
        try
        {
            Integer retVal = port.iPerformanceMetricGetMinimumValue(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Maximum possible value of this metric.
@return Integer
*/
    public Integer getMaximumValue()
    {
        try
        {
            Integer retVal = port.iPerformanceMetricGetMaximumValue(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    public static IPerformanceMetric queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IPerformanceMetric(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }
}
