/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_6_1;

import java.util.List;
import org.virtualbox_6_1.Helper;
import org.virtualbox_6_1.ICloudProvider;
import org.virtualbox_6_1.IUnknown;
import org.virtualbox_6_1.ObjectRefManager;
import org.virtualbox_6_1.VBoxException;
import org.virtualbox_6_1.jaxws.InvalidObjectFaultMsg;
import org.virtualbox_6_1.jaxws.RuntimeFaultMsg;
import org.virtualbox_6_1.jaxws.VboxPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICloudProviderManager
extends IUnknown {
    public ICloudProviderManager(String string, ObjectRefManager objectRefManager, VboxPortType vboxPortType) {
        super(string, objectRefManager, vboxPortType);
    }

    public List<ICloudProvider> getProviders() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iCloudProviderManagerGetProviders(this.obj);
            List<ICloudProvider> list2 = Helper.wrap(ICloudProvider.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public static ICloudProviderManager queryInterface(IUnknown iUnknown) {
        return iUnknown == null ? null : new ICloudProviderManager(iUnknown.getWrapped(), iUnknown.getObjMgr(), iUnknown.getRemoteWSPort());
    }

    public ICloudProvider getProviderById(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iCloudProviderManagerGetProviderById(this.obj, string);
            ICloudProvider iCloudProvider = string2.length() > 0 ? new ICloudProvider(string2, this.getObjMgr(), this.port) : null;
            return iCloudProvider;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public ICloudProvider getProviderByShortName(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iCloudProviderManagerGetProviderByShortName(this.obj, string);
            ICloudProvider iCloudProvider = string2.length() > 0 ? new ICloudProvider(string2, this.getObjMgr(), this.port) : null;
            return iCloudProvider;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public ICloudProvider getProviderByName(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iCloudProviderManagerGetProviderByName(this.obj, string);
            ICloudProvider iCloudProvider = string2.length() > 0 ? new ICloudProvider(string2, this.getObjMgr(), this.port) : null;
            return iCloudProvider;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }
}

