"""The module helps converting SymPy expressions into shorter forms of them.

for example:
the expression E**(pi*I) will be converted into -1
the expression (x+x)**2 will be converted into 4*x**2
"""
from .simplify import (simplify, hypersimp, hypersimilar,
    logcombine, separatevars, posify, besselsimp, kroneckersimp,
    signsimp, bottom_up, nsimplify)

from .fu import FU, fu

from .sqrtdenest import sqrtdenest

from .cse_main import cse

from .traversaltools import use

from .epathtools import epath, EPath

from .hyperexpand import hyperexpand

from .radsimp import collect, rcollect, radsimp, collect_const, fraction, numer, denom

from .trigsimp import trigsimp, exptrigsimp

from .powsimp import powsimp, powdenest

from .combsimp import combsimp

from .gammasimp import gammasimp

from .ratsimp import ratsimp, ratsimpmodprime
