/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.components.ZoomableViewport;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class ZoomingDelegate {
    private final JComponent myContentComponent;
    private final JComponent myViewportComponent;
    private BufferedImage myCachedImage;
    private Point myMagnificationPoint;
    private double myMagnification;

    public ZoomingDelegate(JComponent contentComponent, JComponent viewportComponent) {
        this.myContentComponent = contentComponent;
        this.myViewportComponent = viewportComponent;
    }

    public void paint(Graphics g) {
        if (this.myCachedImage != null && this.myMagnificationPoint != null) {
            double scale = ZoomingDelegate.magnificationToScale(this.myMagnification);
            int xOffset = (int)((double)this.myMagnificationPoint.x - (double)this.myMagnificationPoint.x * scale);
            int yOffset = (int)((double)this.myMagnificationPoint.y - (double)this.myMagnificationPoint.y * scale);
            Rectangle clip = g.getClipBounds();
            g.setColor(this.myContentComponent.getBackground());
            g.fillRect(clip.x, clip.y, clip.width, clip.height);
            Graphics2D translated = (Graphics2D)g.create();
            translated.translate(xOffset, yOffset);
            translated.scale(scale, scale);
            UIUtil.drawImage((Graphics)translated, (Image)this.myCachedImage, (int)0, (int)0, null);
        }
    }

    public void magnificationStarted(@NotNull Point at) {
        if (at == null) {
            ZoomingDelegate.$$$reportNull$$$0(0);
        }
        this.myMagnificationPoint = at;
    }

    public void magnificationFinished(double magnification) {
        Magnificator magnificator = ((ZoomableViewport)((Object)this.myViewportComponent)).getMagnificator();
        if (magnificator != null && Double.compare(magnification, 0.0) != 0) {
            Point inContent = this.convertToContentCoordinates(this.myMagnificationPoint);
            Point inContentScaled = magnificator.magnify(ZoomingDelegate.magnificationToScale(magnification), inContent);
            int vOffset = inContentScaled.y - this.myMagnificationPoint.y;
            int hOffset = inContentScaled.x - this.myMagnificationPoint.x;
            this.myViewportComponent.repaint();
            this.myViewportComponent.validate();
            this.scrollTo(vOffset, hOffset);
        }
        this.myMagnificationPoint = null;
        this.myMagnification = 0.0;
        this.myCachedImage = null;
    }

    protected void scrollTo(int vOffset, int hOffset) {
        JScrollPane pane = JBScrollPane.findScrollPane(this.myViewportComponent);
        JScrollBar vsb = pane.getVerticalScrollBar();
        vsb.setValue(vOffset);
        JScrollBar hsb = pane.getHorizontalScrollBar();
        hsb.setValue(hOffset);
    }

    protected Point convertToContentCoordinates(Point point) {
        return SwingUtilities.convertPoint(this.myViewportComponent, point, this.myContentComponent);
    }

    public boolean isActive() {
        return this.myCachedImage != null;
    }

    private static double magnificationToScale(double magnification) {
        return magnification < 0.0 ? 1.0 / (1.0 - magnification) : 1.0 + magnification;
    }

    public void magnify(double magnification) {
        double prev = this.myMagnification;
        this.myMagnification = magnification;
        if (this.myCachedImage == null) {
            Rectangle bounds = this.myViewportComponent.getBounds();
            if (bounds.width <= 0 || bounds.height <= 0) {
                return;
            }
            BufferedImage image = UIUtil.createImage((Graphics)this.myViewportComponent.getGraphics(), (int)bounds.width, (int)bounds.height, (int)1);
            Graphics graphics = image.getGraphics();
            graphics.setClip(0, 0, bounds.width, bounds.height);
            this.myViewportComponent.paint(graphics);
            this.myCachedImage = image;
        }
        if (Double.compare(prev, magnification) != 0) {
            this.myViewportComponent.repaint();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "at", "com/intellij/ui/components/ZoomingDelegate", "magnificationStarted"));
    }
}

