/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Getter;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Debug;
import org.jetbrains.annotations.NotNull;

@Debug.Renderer(text="\"size = \" + size()", hasChildren="!isEmpty()", childrenArray="childrenArray()")
abstract class RefValueHashMap<K, V>
implements Map<K, V> {
    private final Map<K, MyReference<K, V>> myMap;
    private final ReferenceQueue<V> myQueue;

    @NotNull
    static IncorrectOperationException pointlessContainsKey() {
        IncorrectOperationException incorrectOperationException = new IncorrectOperationException("containsKey() makes no sense for weak/soft map because GC can clear the value any moment now");
        if (incorrectOperationException == null) {
            RefValueHashMap.$$$reportNull$$$0(0);
        }
        return incorrectOperationException;
    }

    @NotNull
    static IncorrectOperationException pointlessContainsValue() {
        IncorrectOperationException incorrectOperationException = new IncorrectOperationException("containsValue() makes no sense for weak/soft map because GC can clear the key any moment now");
        if (incorrectOperationException == null) {
            RefValueHashMap.$$$reportNull$$$0(1);
        }
        return incorrectOperationException;
    }

    RefValueHashMap() {
        this.myQueue = new ReferenceQueue();
        this.myMap = new THashMap();
    }

    RefValueHashMap(@NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            RefValueHashMap.$$$reportNull$$$0(2);
        }
        this.myQueue = new ReferenceQueue();
        this.myMap = new THashMap(strategy);
    }

    protected abstract MyReference<K, V> createReference(@NotNull K var1, V var2, @NotNull ReferenceQueue<? super V> var3);

    private void processQueue() {
        MyReference ref;
        while ((ref = (MyReference)((Object)this.myQueue.poll())) != null) {
            Object key = ref.getKey();
            if (this.myMap.get(key) != ref) continue;
            this.myMap.remove(key);
        }
        return;
    }

    @Override
    public V get(Object key) {
        MyReference<K, V> ref = this.myMap.get(key);
        return (V)SoftReference.deref(ref);
    }

    @Override
    public V put(@NotNull K key, V value) {
        if (key == null) {
            RefValueHashMap.$$$reportNull$$$0(3);
        }
        this.processQueue();
        MyReference<K, V> reference = this.createReference(key, value, this.myQueue);
        MyReference<K, V> oldRef = this.myMap.put(key, reference);
        return (V)SoftReference.deref(oldRef);
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        MyReference<K, V> ref = this.myMap.remove(key);
        return (V)SoftReference.deref(ref);
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> t) {
        if (t == null) {
            RefValueHashMap.$$$reportNull$$$0(4);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.myMap.clear();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        throw RefValueHashMap.pointlessContainsKey();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set<K> set = this.myMap.keySet();
        if (set == null) {
            RefValueHashMap.$$$reportNull$$$0(5);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        ArrayList result = new ArrayList();
        Collection<MyReference<K, V>> refs = this.myMap.values();
        for (MyReference<K, V> ref : refs) {
            Object value = ref.get();
            if (value == null) continue;
            result.add(value);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            RefValueHashMap.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    private Map.Entry[] childrenArray() {
        return (Map.Entry[])this.myMap.entrySet().stream().map(entry -> {
            Object val = SoftReference.deref((Getter)entry.getValue());
            return val != null ? new AbstractMap.SimpleImmutableEntry(entry.getKey(), val) : null;
        }).filter(Objects::nonNull).toArray(Map.Entry[]::new);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/RefValueHashMap";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "pointlessContainsKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "pointlessContainsValue";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/RefValueHashMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface MyReference<K, T>
    extends Getter<T> {
        @NotNull
        public K getKey();
    }
}

