/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.documentation.docstrings.DocStringBuilder;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringUpdater;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocString;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocStringBuilder;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocStringUpdater;
import com.jetbrains.python.documentation.docstrings.NumpyDocStringBuilder;
import com.jetbrains.python.documentation.docstrings.NumpyDocStringUpdater;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocString;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocStringBuilder;
import com.jetbrains.python.documentation.docstrings.TagBasedDocString;
import com.jetbrains.python.documentation.docstrings.TagBasedDocStringBuilder;
import com.jetbrains.python.documentation.docstrings.TagBasedDocStringUpdater;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.toolbox.Substring;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDocstringGenerator {
    public static final String TRIPLE_DOUBLE_QUOTES = "\"\"\"";
    public static final String TRIPLE_SINGLE_QUOTES = "'''";
    private final List<DocstringParam> myAddedParams;
    private final List<DocstringParam> myRemovedParams;
    private final String myDocStringText;
    @Nullable
    private final PyDocStringOwner myDocStringOwner;
    private final String myDocStringIndent;
    private final DocStringFormat myDocStringFormat;
    private final PsiElement mySettingsAnchor;
    private boolean myUseTypesFromDebuggerSignature;
    private boolean myNewMode;
    private boolean myAddFirstEmptyLine;
    private boolean myParametersPrepared;
    private String myQuotes;

    private PyDocstringGenerator(@Nullable PyDocStringOwner docStringOwner, @Nullable String docStringText, @NotNull DocStringFormat format, @NotNull String indentation, @NotNull PsiElement settingsAnchor) {
        if (format == null) {
            PyDocstringGenerator.$$$reportNull$$$0(0);
        }
        if (indentation == null) {
            PyDocstringGenerator.$$$reportNull$$$0(1);
        }
        if (settingsAnchor == null) {
            PyDocstringGenerator.$$$reportNull$$$0(2);
        }
        this.myAddedParams = Lists.newArrayList();
        this.myRemovedParams = Lists.newArrayList();
        this.myUseTypesFromDebuggerSignature = true;
        this.myNewMode = false;
        this.myAddFirstEmptyLine = false;
        this.myParametersPrepared = false;
        this.myQuotes = TRIPLE_DOUBLE_QUOTES;
        this.myDocStringOwner = docStringOwner;
        this.myDocStringIndent = indentation;
        this.myDocStringFormat = format;
        this.myDocStringText = docStringText;
        this.myNewMode = this.myDocStringText == null;
        this.mySettingsAnchor = settingsAnchor;
    }

    @NotNull
    public static PyDocstringGenerator forDocStringOwner(@NotNull PyDocStringOwner owner) {
        if (owner == null) {
            PyDocstringGenerator.$$$reportNull$$$0(3);
        }
        String indentation = "";
        if (owner instanceof PyStatementListContainer) {
            indentation = PyIndentUtil.getElementIndent((PsiElement)((PyStatementListContainer)((Object)owner)).getStatementList());
        }
        String docStringText = owner.getDocStringExpression() == null ? null : owner.getDocStringExpression().getText();
        PyDocstringGenerator pyDocstringGenerator = new PyDocstringGenerator(owner, docStringText, DocStringUtil.getConfiguredDocStringFormatOrPlain((PsiElement)owner), indentation, (PsiElement)owner);
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(4);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public static PyDocstringGenerator create(@NotNull DocStringFormat format, @NotNull String indentation, @NotNull PsiElement settingsAnchor) {
        if (format == null) {
            PyDocstringGenerator.$$$reportNull$$$0(5);
        }
        if (indentation == null) {
            PyDocstringGenerator.$$$reportNull$$$0(6);
        }
        if (settingsAnchor == null) {
            PyDocstringGenerator.$$$reportNull$$$0(7);
        }
        PyDocstringGenerator pyDocstringGenerator = new PyDocstringGenerator(null, null, format, indentation, settingsAnchor);
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(8);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public static PyDocstringGenerator update(@NotNull PyStringLiteralExpression docString) {
        if (docString == null) {
            PyDocstringGenerator.$$$reportNull$$$0(9);
        }
        PyDocstringGenerator pyDocstringGenerator = new PyDocstringGenerator((PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)docString, PyDocStringOwner.class), docString.getText(), DocStringUtil.getConfiguredDocStringFormatOrPlain(docString), PyIndentUtil.getElementIndent(docString), docString);
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(10);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public static PyDocstringGenerator update(@NotNull DocStringFormat format, @NotNull String indentation, @NotNull String text2, PsiElement settingsAnchor) {
        if (format == null) {
            PyDocstringGenerator.$$$reportNull$$$0(11);
        }
        if (indentation == null) {
            PyDocstringGenerator.$$$reportNull$$$0(12);
        }
        if (text2 == null) {
            PyDocstringGenerator.$$$reportNull$$$0(13);
        }
        PyDocstringGenerator pyDocstringGenerator = new PyDocstringGenerator(null, text2, format, indentation, settingsAnchor);
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(14);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withParam(@NotNull String name) {
        if (name == null) {
            PyDocstringGenerator.$$$reportNull$$$0(15);
        }
        PyDocstringGenerator pyDocstringGenerator = this.withParamTypedByName(name, null);
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(16);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withParam(@NotNull PyNamedParameter param) {
        if (param == null) {
            PyDocstringGenerator.$$$reportNull$$$0(17);
        }
        PyDocstringGenerator pyDocstringGenerator = this.withParam(this.getPreferredParameterName(param));
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(18);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withParamTypedByName(@NotNull String name, @Nullable String type) {
        if (name == null) {
            PyDocstringGenerator.$$$reportNull$$$0(19);
        }
        this.myAddedParams.add(new DocstringParam(name, type, false));
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(20);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withParamTypedByName(@NotNull PyNamedParameter name, @Nullable String type) {
        if (name == null) {
            PyDocstringGenerator.$$$reportNull$$$0(21);
        }
        PyDocstringGenerator pyDocstringGenerator = this.withParamTypedByName(this.getPreferredParameterName(name), type);
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(22);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withReturnValue(@Nullable String type) {
        this.myAddedParams.add(new DocstringParam("", type, true));
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(23);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withoutParam(@NotNull String name) {
        if (name == null) {
            PyDocstringGenerator.$$$reportNull$$$0(24);
        }
        this.myRemovedParams.add(new DocstringParam(name, null, false));
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(25);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withQuotes(@NotNull String quotes) {
        if (quotes == null) {
            PyDocstringGenerator.$$$reportNull$$$0(26);
        }
        this.myQuotes = quotes;
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(27);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator useTypesFromDebuggerSignature(boolean use2) {
        this.myUseTypesFromDebuggerSignature = use2;
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(28);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator addFirstEmptyLine() {
        this.myAddFirstEmptyLine = true;
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(29);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator forceNewMode() {
        this.myNewMode = true;
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(30);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withInferredParameters(boolean addReturn) {
        if (this.myDocStringOwner instanceof PyFunction) {
            for (PyParameter param : ((PyFunction)this.myDocStringOwner).getParameterList().getParameters()) {
                if (param.getAsNamed() == null) continue;
                String paramName = param.getName();
                StructuredDocString docString = this.getStructuredDocString();
                if (StringUtil.isEmpty((String)paramName) || param.isSelf() || docString != null && docString.getParameters().contains(paramName)) continue;
                this.withParam((PyNamedParameter)param);
            }
            RaiseVisitor visitor2 = new RaiseVisitor();
            PyStatementList statementList = ((PyFunction)this.myDocStringOwner).getStatementList();
            statementList.accept(visitor2);
            if (!PyDocstringGenerator.isConstructor((PyFunction)this.myDocStringOwner) && (visitor2.myHasReturn || addReturn)) {
                this.withReturnValue(null);
            }
        }
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.$$$reportNull$$$0(31);
        }
        return pyDocstringGenerator;
    }

    private static boolean isConstructor(@NotNull PyFunction function) {
        String funcName;
        if (function == null) {
            PyDocstringGenerator.$$$reportNull$$$0(32);
        }
        return "__init__".equals(funcName = function.getName()) && function.getContainingClass() != null;
    }

    @NotNull
    public String getDocStringIndent() {
        String string = this.myDocStringIndent;
        if (string == null) {
            PyDocstringGenerator.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    public DocStringFormat getDocStringFormat() {
        DocStringFormat docStringFormat = this.myDocStringFormat;
        if (docStringFormat == null) {
            PyDocstringGenerator.$$$reportNull$$$0(34);
        }
        return docStringFormat;
    }

    public boolean isNewMode() {
        return this.myNewMode;
    }

    private void prepareParameters() {
        if (this.myParametersPrepared) {
            return;
        }
        HashSet withoutType = Sets.newHashSet();
        HashMap paramTypes = Maps.newHashMap();
        for (DocstringParam param : this.myAddedParams) {
            if (param.getType() == null) {
                withoutType.add(Pair.create((Object)param.getName(), (Object)param.isReturnValue()));
                continue;
            }
            paramTypes.put(Pair.create((Object)param.getName(), (Object)param.isReturnValue()), param.getType());
        }
        PySignature signature = null;
        if (this.myDocStringOwner instanceof PyFunction && this.myUseTypesFromDebuggerSignature) {
            signature = PySignatureCacheManager.getInstance(this.myDocStringOwner.getProject()).findSignature((PyFunction)this.myDocStringOwner);
        }
        DocStringFormat format = this.myDocStringFormat;
        ArrayList filtered = Lists.newArrayList();
        HashSet processed = Sets.newHashSet();
        for (DocstringParam param : this.myAddedParams) {
            Pair paramCoordinates = Pair.create((Object)param.getName(), (Object)param.isReturnValue());
            if (processed.contains(paramCoordinates)) continue;
            if (param.getType() == null) {
                String type = (String)paramTypes.get(paramCoordinates);
                if (type == null && PyCodeInsightSettings.getInstance().INSERT_TYPE_DOCSTUB) {
                    type = signature != null ? StringUtil.notNullize((String)(param.isReturnValue() ? signature.getReturnTypeQualifiedName() : signature.getArgTypeQualifiedName(param.getName()))) : "";
                }
                if (type != null) {
                    if (format != DocStringFormat.GOOGLE && format != DocStringFormat.NUMPY) {
                        filtered.add(param);
                    }
                    filtered.add(new DocstringParam(param.getName(), type, param.isReturnValue()));
                } else {
                    filtered.add(param);
                }
            } else if (!withoutType.contains(paramCoordinates)) {
                filtered.add(param);
            }
            processed.add(paramCoordinates);
        }
        this.myAddedParams.clear();
        this.myAddedParams.addAll(filtered);
        this.myParametersPrepared = true;
    }

    public boolean hasParametersToAdd() {
        this.prepareParameters();
        return !this.myAddedParams.isEmpty();
    }

    @Nullable
    private PyStringLiteralExpression getDocStringExpression() {
        Preconditions.checkNotNull((Object)this.myDocStringOwner, (Object)"For this action docstring owner must be supplied");
        return this.myDocStringOwner.getDocStringExpression();
    }

    @Nullable
    private StructuredDocString getStructuredDocString() {
        return this.myDocStringText == null ? null : DocStringUtil.parseDocString(this.myDocStringFormat, this.myDocStringText);
    }

    public void startTemplate() {
        Substring substring;
        Preconditions.checkNotNull((Object)this.myDocStringOwner, (Object)"For this action docstring owner must be supplied");
        PyStringLiteralExpression docStringExpression = this.getDocStringExpression();
        assert (docStringExpression != null);
        TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)docStringExpression);
        if (this.myAddedParams.size() > 1) {
            throw new IllegalArgumentException("TemplateBuilder can be created only for one parameter");
        }
        DocstringParam paramToEdit = this.getParamToEdit();
        DocStringFormat format = this.myDocStringFormat;
        if (format == DocStringFormat.PLAIN) {
            return;
        }
        StructuredDocString parsed = DocStringUtil.parseDocString(format, docStringExpression);
        if (paramToEdit.isReturnValue()) {
            substring = parsed.getReturnTypeSubstring();
        } else {
            String paramName = paramToEdit.getName();
            substring = parsed.getParamTypeSubstring(paramName);
        }
        if (substring == null) {
            return;
        }
        builder.replaceRange(substring.getTextRange(), PyDocstringGenerator.getDefaultType(this.getParamToEdit()));
        Template template = (Template)PyUtil.updateDocumentUnblockedAndCommitted((PsiElement)this.myDocStringOwner, document -> ((TemplateBuilderImpl)builder).buildInlineTemplate());
        VirtualFile virtualFile = this.myDocStringOwner.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Project project = this.myDocStringOwner.getProject();
        Editor targetEditor = PsiUtilBase.findEditor((PsiElement)this.myDocStringOwner);
        if (targetEditor != null && template != null) {
            targetEditor.getCaretModel().moveToOffset(docStringExpression.getTextOffset());
            TemplateManager.getInstance((Project)project).startTemplate(targetEditor, template);
        }
    }

    @NotNull
    public String getPreferredParameterName(@NotNull PyNamedParameter parameter) {
        if (parameter == null) {
            PyDocstringGenerator.$$$reportNull$$$0(35);
        }
        if (this.getDocStringFormat() == DocStringFormat.GOOGLE && parameter.getAsNamed() != null) {
            String string = parameter.getAsNamed().getRepr(false);
            if (string == null) {
                PyDocstringGenerator.$$$reportNull$$$0(36);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)parameter.getName());
        if (string == null) {
            PyDocstringGenerator.$$$reportNull$$$0(37);
        }
        return string;
    }

    @NotNull
    private static String getDefaultType(@NotNull DocstringParam param) {
        if (param == null) {
            PyDocstringGenerator.$$$reportNull$$$0(38);
        }
        if (StringUtil.isEmpty((String)param.getType())) {
            if ("object" == null) {
                PyDocstringGenerator.$$$reportNull$$$0(39);
            }
            return "object";
        }
        String string = param.getType();
        if (string == null) {
            PyDocstringGenerator.$$$reportNull$$$0(40);
        }
        return string;
    }

    @NotNull
    public String buildDocString() {
        this.prepareParameters();
        if (this.myNewMode) {
            String string = this.createDocString();
            if (string == null) {
                PyDocstringGenerator.$$$reportNull$$$0(41);
            }
            return string;
        }
        String string = this.updateDocString();
        if (string == null) {
            PyDocstringGenerator.$$$reportNull$$$0(42);
        }
        return string;
    }

    @NotNull
    private String createDocString() {
        DocStringBuilder builder = null;
        if (this.myDocStringFormat == DocStringFormat.EPYTEXT || this.myDocStringFormat == DocStringFormat.REST) {
            builder = new TagBasedDocStringBuilder(this.myDocStringFormat == DocStringFormat.EPYTEXT ? "@" : ":");
            TagBasedDocStringBuilder tagBuilder = builder;
            if (this.myAddFirstEmptyLine) {
                tagBuilder.addEmptyLine();
            }
            for (DocstringParam param2 : this.myAddedParams) {
                if (param2.isReturnValue()) {
                    if (param2.getType() != null) {
                        tagBuilder.addReturnValueType(param2.getType());
                        continue;
                    }
                    tagBuilder.addReturnValueDescription("");
                    continue;
                }
                if (param2.getType() != null) {
                    tagBuilder.addParameterType(param2.getName(), param2.getType());
                    continue;
                }
                tagBuilder.addParameterDescription(param2.getName(), "");
            }
        } else if (this.myDocStringFormat == DocStringFormat.GOOGLE || this.myDocStringFormat == DocStringFormat.NUMPY) {
            List returnValues;
            List parameters;
            builder = this.myDocStringFormat == DocStringFormat.GOOGLE ? GoogleCodeStyleDocStringBuilder.forSettings(this.mySettingsAnchor.getContainingFile()) : new NumpyDocStringBuilder();
            SectionBasedDocStringBuilder sectionBuilder = (SectionBasedDocStringBuilder)builder;
            if (this.myAddFirstEmptyLine) {
                sectionBuilder.addEmptyLine();
            }
            if (!(parameters = ContainerUtil.findAll(this.myAddedParams, param -> !param.isReturnValue())).isEmpty()) {
                sectionBuilder.startParametersSection();
                for (DocstringParam param3 : parameters) {
                    sectionBuilder.addParameter(param3.getName(), param3.getType(), "");
                }
            }
            if (!(returnValues = ContainerUtil.findAll(this.myAddedParams, param -> param.isReturnValue())).isEmpty()) {
                sectionBuilder.startReturnsSection();
                boolean hasTypedReturns = false;
                for (DocstringParam returnValue : returnValues) {
                    if (!StringUtil.isNotEmpty((String)returnValue.getType())) continue;
                    sectionBuilder.addReturnValue(null, returnValue.getType(), "");
                    hasTypedReturns = true;
                }
                if (!hasTypedReturns) {
                    sectionBuilder.addEmptyLine();
                }
            }
        }
        if (builder != null && !builder.getLines().isEmpty()) {
            String string = this.myQuotes + '\n' + builder.buildContent(this.myDocStringIndent, true) + '\n' + this.myDocStringIndent + this.myQuotes;
            if (string == null) {
                PyDocstringGenerator.$$$reportNull$$$0(43);
            }
            return string;
        }
        String string = this.createEmptyFallbackDocString();
        if (string == null) {
            PyDocstringGenerator.$$$reportNull$$$0(44);
        }
        return string;
    }

    @NotNull
    private String updateDocString() {
        DocStringUpdater updater = null;
        if (this.myDocStringFormat == DocStringFormat.EPYTEXT || this.myDocStringFormat == DocStringFormat.REST) {
            String prefix = this.myDocStringFormat == DocStringFormat.EPYTEXT ? "@" : ":";
            updater = new TagBasedDocStringUpdater((TagBasedDocString)this.getStructuredDocString(), prefix, this.myDocStringIndent);
        } else if (this.myDocStringFormat == DocStringFormat.GOOGLE) {
            updater = GoogleCodeStyleDocStringUpdater.forSettings((GoogleCodeStyleDocString)this.getStructuredDocString(), this.myDocStringIndent, this.mySettingsAnchor.getContainingFile());
        } else if (this.myDocStringFormat == DocStringFormat.NUMPY) {
            updater = new NumpyDocStringUpdater((SectionBasedDocString)this.getStructuredDocString(), this.myDocStringIndent);
        } else if (this.myDocStringText != null) {
            String string = this.myDocStringText;
            if (string == null) {
                PyDocstringGenerator.$$$reportNull$$$0(45);
            }
            return string;
        }
        if (updater != null) {
            for (DocstringParam param : this.myAddedParams) {
                if (param.isReturnValue()) {
                    updater.addReturnValue(param.getType());
                    continue;
                }
                updater.addParameter(param.getName(), param.getType());
            }
            for (DocstringParam param : this.myRemovedParams) {
                if (param.isReturnValue()) continue;
                updater.removeParameter(param.getName());
            }
            String string = updater.getDocStringText();
            if (string == null) {
                PyDocstringGenerator.$$$reportNull$$$0(46);
            }
            return string;
        }
        String string = this.createEmptyFallbackDocString();
        if (string == null) {
            PyDocstringGenerator.$$$reportNull$$$0(47);
        }
        return string;
    }

    @NotNull
    private String createEmptyFallbackDocString() {
        String string = this.myQuotes + '\n' + this.myDocStringIndent + this.myQuotes;
        if (string == null) {
            PyDocstringGenerator.$$$reportNull$$$0(48);
        }
        return string;
    }

    private DocstringParam getParamToEdit() {
        if (this.myAddedParams.size() == 0) {
            throw new IllegalStateException("We should have at least one param to edit");
        }
        return this.myAddedParams.get(0);
    }

    @NotNull
    public PyDocStringOwner buildAndInsert() {
        Preconditions.checkNotNull((Object)this.myDocStringOwner, (Object)"For this action docstring owner must be supplied");
        String replacementText = this.buildDocString();
        Project project = this.myDocStringOwner.getProject();
        PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
        PyExpressionStatement replacement = elementGenerator.createDocstring(replacementText);
        PyStringLiteralExpression docStringExpression = this.getDocStringExpression();
        if (docStringExpression != null) {
            docStringExpression.replace((PsiElement)replacement.getExpression());
        } else {
            PyStatementListContainer container = PyUtil.as(this.myDocStringOwner, PyStatementListContainer.class);
            if (container == null) {
                throw new IllegalStateException("Should be a function or class");
            }
            PyStatementList statements = container.getStatementList();
            String indentation = PyIndentUtil.getElementIndent((PsiElement)statements);
            PyUtil.updateDocumentUnblockedAndCommitted((PsiElement)this.myDocStringOwner, (Consumer<? super Document>)((Consumer)document -> {
                PsiElement beforeStatements = statements.getPrevSibling();
                String replacementWithLineBreaks = "\n" + indentation + replacementText;
                if (statements.getStatements().length > 0) {
                    replacementWithLineBreaks = replacementWithLineBreaks + "\n" + indentation;
                }
                TextRange range = beforeStatements.getTextRange();
                if (!(beforeStatements instanceof PsiWhiteSpace)) {
                    document.insertString(range.getEndOffset(), (CharSequence)replacementWithLineBreaks);
                } else if (statements.getStatements().length == 0 && beforeStatements.textContains('\n')) {
                    document.insertString(range.getStartOffset(), (CharSequence)replacementWithLineBreaks);
                } else {
                    document.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)replacementWithLineBreaks);
                }
            }));
        }
        PyDocStringOwner pyDocStringOwner = this.myDocStringOwner;
        if (pyDocStringOwner == null) {
            PyDocstringGenerator.$$$reportNull$$$0(49);
        }
        return pyDocStringOwner;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 1: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentation";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsAnchor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/PyDocstringGenerator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docString";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotes";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/PyDocstringGenerator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "forDocStringOwner";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "update";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "withParam";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "withParamTypedByName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "withReturnValue";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutParam";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "withQuotes";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "useTypesFromDebuggerSignature";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "addFirstEmptyLine";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "forceNewMode";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "withInferredParameters";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocStringIndent";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocStringFormat";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredParameterName";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultType";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDocString";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocString";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "updateDocString";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyFallbackDocString";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAndInsert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forDocStringOwner";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "withParam";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "withParamTypedByName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "withoutParam";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "withQuotes";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isConstructor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredParameterName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RaiseVisitor
    extends PyRecursiveElementVisitor {
        private boolean myHasRaise = false;
        private boolean myHasReturn = false;
        @Nullable
        private PyExpression myRaiseTarget = null;

        private RaiseVisitor() {
        }

        @Override
        public void visitPyRaiseStatement(@NotNull PyRaiseStatement node) {
            if (node == null) {
                RaiseVisitor.$$$reportNull$$$0(0);
            }
            this.myHasRaise = true;
            PyExpression[] expressions = node.getExpressions();
            if (expressions.length > 0) {
                this.myRaiseTarget = expressions[0];
            }
        }

        @Override
        public void visitPyReturnStatement(PyReturnStatement node) {
            this.myHasReturn = true;
        }

        @NotNull
        public String getRaiseTargetText() {
            if (this.myRaiseTarget != null) {
                PyExpression callee;
                String raiseTarget = this.myRaiseTarget.getText();
                if (this.myRaiseTarget instanceof PyCallExpression && (callee = ((PyCallExpression)this.myRaiseTarget).getCallee()) != null) {
                    raiseTarget = callee.getText();
                }
                String string = raiseTarget;
                if (string == null) {
                    RaiseVisitor.$$$reportNull$$$0(1);
                }
                return string;
            }
            if ("" == null) {
                RaiseVisitor.$$$reportNull$$$0(2);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/docstrings/PyDocstringGenerator$RaiseVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/docstrings/PyDocstringGenerator$RaiseVisitor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRaiseTargetText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyRaiseStatement";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DocstringParam {
        private final String myName;
        private final String myType;
        private final boolean myReturnValue;

        private DocstringParam(@NotNull String name, @Nullable String type, boolean isReturn) {
            if (name == null) {
                DocstringParam.$$$reportNull$$$0(0);
            }
            this.myName = name;
            this.myType = type;
            this.myReturnValue = isReturn;
        }

        @NotNull
        public String getName() {
            String string = this.myName;
            if (string == null) {
                DocstringParam.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        public String getType() {
            return this.myType;
        }

        public boolean isReturnValue() {
            return this.myReturnValue;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DocstringParam param = (DocstringParam)o;
            if (this.myReturnValue != param.myReturnValue) {
                return false;
            }
            if (!this.myName.equals(param.myName)) {
                return false;
            }
            return !(this.myType != null ? !this.myType.equals(param.myType) : param.myType != null);
        }

        public int hashCode() {
            int result = this.myName.hashCode();
            result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
            result = 31 * result + (this.myReturnValue ? 1 : 0);
            return result;
        }

        public String toString() {
            return "DocstringParam{myName='" + this.myName + '\'' + ", myType='" + this.myType + '\'' + ", myReturnValue=" + this.myReturnValue + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/docstrings/PyDocstringGenerator$DocstringParam";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/docstrings/PyDocstringGenerator$DocstringParam";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

