/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.wm.impl.commands.FinalizableCommand;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommandProcessor
implements Runnable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.wm.impl.CommandProcessor");
    private final Object myLock = new Object();
    private final List<CommandGroup> myCommandGroupList = new ArrayList<CommandGroup>();
    private int myCommandCount;
    private boolean myFlushed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getCommandCount() {
        Object object = this.myLock;
        synchronized (object) {
            return this.myCommandCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Object object = this.myLock;
        synchronized (object) {
            this.myFlushed = true;
            this.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(@NotNull List<? extends FinalizableCommand> commandList, @NotNull Condition expired) {
        if (commandList == null) {
            CommandProcessor.$$$reportNull$$$0(0);
        }
        if (expired == null) {
            CommandProcessor.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            boolean isBusy = this.myCommandCount > 0 || !this.myFlushed;
            CommandGroup commandGroup = new CommandGroup(commandList, expired);
            this.myCommandGroupList.add(commandGroup);
            this.myCommandCount += commandList.size();
            if (!isBusy) {
                this.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        Object object = this.myLock;
        synchronized (object) {
            while (this.runNext()) {
            }
        }
    }

    private boolean runNext() {
        Condition expire;
        CommandGroup commandGroup = this.getNextCommandGroup();
        if (commandGroup == null || commandGroup.isEmpty()) {
            return false;
        }
        Condition conditionForGroup = commandGroup.getExpireCondition();
        FinalizableCommand command = commandGroup.takeNextCommand();
        --this.myCommandCount;
        Condition condition = expire = command.getExpireCondition() != null ? command.getExpireCondition() : conditionForGroup;
        if (expire == null) {
            expire = ApplicationManager.getApplication().getDisposed();
        }
        if (expire.value(null)) {
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("CommandProcessor.run " + command);
        }
        command.run();
        return true;
    }

    @Nullable
    private CommandGroup getNextCommandGroup() {
        while (!this.myCommandGroupList.isEmpty()) {
            CommandGroup candidate = this.myCommandGroupList.get(0);
            if (!candidate.isEmpty()) {
                return candidate;
            }
            this.myCommandGroupList.remove(candidate);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "commandList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "expired";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/wm/impl/CommandProcessor";
        objectArray[2] = "execute";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CommandGroup {
        private final List<? extends FinalizableCommand> myList;
        private Condition myExpireCondition;

        private CommandGroup(@NotNull List<? extends FinalizableCommand> list2, @NotNull Condition expireCondition) {
            if (list2 == null) {
                CommandGroup.$$$reportNull$$$0(0);
            }
            if (expireCondition == null) {
                CommandGroup.$$$reportNull$$$0(1);
            }
            this.myList = list2;
            this.myExpireCondition = expireCondition;
        }

        @NotNull
        Condition getExpireCondition() {
            Condition condition = this.myExpireCondition;
            if (condition == null) {
                CommandGroup.$$$reportNull$$$0(2);
            }
            return condition;
        }

        public boolean isEmpty() {
            return this.myList.isEmpty();
        }

        @NotNull
        FinalizableCommand takeNextCommand() {
            FinalizableCommand command = this.myList.remove(0);
            if (this.isEmpty()) {
                this.myExpireCondition = Conditions.alwaysTrue();
            }
            FinalizableCommand finalizableCommand = command;
            if (finalizableCommand == null) {
                CommandGroup.$$$reportNull$$$0(3);
            }
            return finalizableCommand;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expireCondition";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/wm/impl/CommandProcessor$CommandGroup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/wm/impl/CommandProcessor$CommandGroup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExpireCondition";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "takeNextCommand";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

