/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.readOnlyHandler;

import com.intellij.CommonBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.readOnlyHandler.FileInfo;
import com.intellij.openapi.vcs.readOnlyHandler.HandleType;
import com.intellij.openapi.vcs.readOnlyHandler.ReadOnlyStatusDialog;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.WritingAccessProvider;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="ReadonlyStatusHandler", storages={@Storage(value="$WORKSPACE_FILE$")})
public class ReadonlyStatusHandlerImpl
extends ReadonlyStatusHandler
implements PersistentStateComponent<State> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.readOnlyHandler.ReadonlyStatusHandlerImpl");
    private final Project myProject;
    protected boolean myClearReadOnlyInTests;
    private State myState;

    public ReadonlyStatusHandlerImpl(@NotNull Project project) {
        if (project == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(0);
        }
        this.myState = new State();
        this.myProject = project;
    }

    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(1);
        }
        this.myState = state;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ReadonlyStatusHandler.OperationStatus ensureFilesWritable(@NotNull Collection<? extends VirtualFile> files2) {
        List<FileInfo> fileInfos;
        if (files2 == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(2);
        }
        if (files2.isEmpty()) {
            OperationStatusImpl operationStatusImpl = new OperationStatusImpl(VirtualFile.EMPTY_ARRAY);
            if (operationStatusImpl == null) {
                ReadonlyStatusHandlerImpl.$$$reportNull$$$0(3);
            }
            return operationStatusImpl;
        }
        ReadonlyStatusHandlerImpl.checkThreading();
        THashSet realFiles = new THashSet(files2.size());
        for (VirtualFile virtualFile2 : files2) {
            void var4_4;
            void var4_7;
            VirtualFile originalFile;
            if (virtualFile2 instanceof LightVirtualFile && (originalFile = ((LightVirtualFile)virtualFile2).getOriginalFile()) != null) {
                VirtualFile virtualFile3 = originalFile;
            }
            if (var4_7 instanceof VirtualFileWindow) {
                VirtualFile virtualFile4 = ((VirtualFileWindow)var4_7).getDelegate();
            }
            if (var4_4 == null) continue;
            realFiles.add(var4_4);
        }
        files2 = new ArrayList<VirtualFile>((Collection<? extends VirtualFile>)realFiles);
        if (!this.myProject.isDefault()) {
            for (WritingAccessProvider writingAccessProvider : WritingAccessProvider.EP_NAME.getIterable((AreaInstance)this.myProject)) {
                Collection denied = ContainerUtil.filter(files2, virtualFile -> !accessProvider.isPotentiallyWritable(virtualFile));
                if (denied.isEmpty()) {
                    denied = writingAccessProvider.requestWriting(files2);
                }
                if (denied.isEmpty()) continue;
                OperationStatusImpl operationStatusImpl = new OperationStatusImpl(VfsUtilCore.toVirtualFileArray((Collection)denied), writingAccessProvider.getReadOnlyMessage());
                if (operationStatusImpl == null) {
                    ReadonlyStatusHandlerImpl.$$$reportNull$$$0(4);
                }
                return operationStatusImpl;
            }
        }
        if ((fileInfos = this.createFileInfos(files2)).isEmpty()) {
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandlerImpl.createResultStatus(files2);
            if (operationStatus == null) {
                ReadonlyStatusHandlerImpl.$$$reportNull$$$0(5);
            }
            return operationStatus;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (this.myClearReadOnlyInTests) {
                ReadonlyStatusHandlerImpl.processFiles(new ArrayList<FileInfo>(fileInfos), null);
            }
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandlerImpl.createResultStatus(files2);
            if (operationStatus == null) {
                ReadonlyStatusHandlerImpl.$$$reportNull$$$0(6);
            }
            return operationStatus;
        }
        int n = IdeEventQueue.getInstance().getEventCount();
        if (this.myState.SHOW_DIALOG) {
            new ReadOnlyStatusDialog(this.myProject, fileInfos).show();
        } else {
            ReadonlyStatusHandlerImpl.processFiles(new ArrayList<FileInfo>(fileInfos), null);
        }
        IdeEventQueue.getInstance().setEventCount(n);
        ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandlerImpl.createResultStatus(files2);
        if (operationStatus == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(7);
        }
        return operationStatus;
    }

    private static void checkThreading() {
        Application app = ApplicationManager.getApplication();
        app.assertIsDispatchThread();
        if (!app.isWriteAccessAllowed()) {
            return;
        }
        if (app.isUnitTestMode() && Registry.is((String)"tests.assert.clear.read.only.status.outside.write.action")) {
            LOG.error("ensureFilesWritable should be called outside write action");
        }
    }

    private static ReadonlyStatusHandler.OperationStatus createResultStatus(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(8);
        }
        ArrayList<VirtualFile> readOnlyFiles = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : files2) {
            if (!virtualFile.exists() || virtualFile.isWritable()) continue;
            readOnlyFiles.add(virtualFile);
        }
        return new OperationStatusImpl(VfsUtilCore.toVirtualFileArray(readOnlyFiles));
    }

    @NotNull
    private List<FileInfo> createFileInfos(@NotNull Collection<? extends VirtualFile> files2) {
        if (files2 == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(9);
        }
        ArrayList<FileInfo> fileInfos = new ArrayList<FileInfo>();
        for (VirtualFile virtualFile : files2) {
            if (virtualFile == null || virtualFile.isWritable() || !virtualFile.isInLocalFileSystem()) continue;
            fileInfos.add(new FileInfo(virtualFile, this.myProject));
        }
        ArrayList<FileInfo> arrayList = fileInfos;
        if (arrayList == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    public static void processFiles(List<FileInfo> fileInfos, @Nullable String changelist) {
        FileInfo[] copy = fileInfos.toArray(new FileInfo[0]);
        MultiValuesMap handleTypeToFile = new MultiValuesMap();
        for (FileInfo fileInfo : copy) {
            handleTypeToFile.put((Object)fileInfo.getSelectedHandleType(), (Object)fileInfo.getFile());
        }
        for (HandleType handleType : handleTypeToFile.keySet()) {
            handleType.processFiles(handleTypeToFile.get((Object)handleType), changelist);
        }
        for (FileInfo fileInfo : copy) {
            if (fileInfo.getFile().exists() && !fileInfo.getFile().isWritable()) continue;
            fileInfos.remove(fileInfo);
        }
    }

    public void setClearReadOnlyInTests(boolean clearReadOnlyInTests) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myClearReadOnlyInTests = clearReadOnlyInTests;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/readOnlyHandler/ReadonlyStatusHandlerImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/readOnlyHandler/ReadonlyStatusHandlerImpl";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureFilesWritable";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesWritable";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createResultStatus";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFileInfos";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OperationStatusImpl
    extends ReadonlyStatusHandler.OperationStatus {
        private final VirtualFile[] myReadonlyFiles;
        @NotNull
        private final String myReadOnlyReason;

        OperationStatusImpl(@NotNull VirtualFile[] readonlyFiles) {
            if (readonlyFiles == null) {
                OperationStatusImpl.$$$reportNull$$$0(0);
            }
            this(readonlyFiles, "");
        }

        private OperationStatusImpl(VirtualFile[] readonlyFiles, @NotNull String readOnlyReason) {
            if (readOnlyReason == null) {
                OperationStatusImpl.$$$reportNull$$$0(1);
            }
            this.myReadonlyFiles = readonlyFiles;
            this.myReadOnlyReason = readOnlyReason;
        }

        @NotNull
        public VirtualFile[] getReadonlyFiles() {
            if (this.myReadonlyFiles == null) {
                OperationStatusImpl.$$$reportNull$$$0(2);
            }
            return this.myReadonlyFiles;
        }

        public boolean hasReadonlyFiles() {
            return this.myReadonlyFiles.length > 0;
        }

        @NotNull
        public String getReadonlyFilesMessage() {
            if (this.hasReadonlyFiles()) {
                if (!StringUtil.isEmpty((String)this.myReadOnlyReason)) {
                    String string = this.myReadOnlyReason;
                    if (string == null) {
                        OperationStatusImpl.$$$reportNull$$$0(3);
                    }
                    return string;
                }
                StringBuilder buf = new StringBuilder();
                if (this.myReadonlyFiles.length > 1) {
                    for (VirtualFile file2 : this.myReadonlyFiles) {
                        buf.append('\n');
                        buf.append(file2.getPresentableUrl());
                    }
                    String string = CommonBundle.message((String)"failed.to.make.the.following.files.writable.error.message", (Object[])new Object[]{buf.toString()});
                    if (string == null) {
                        OperationStatusImpl.$$$reportNull$$$0(4);
                    }
                    return string;
                }
                String string = CommonBundle.message((String)"failed.to.make.file.writable.error.message", (Object[])new Object[]{this.myReadonlyFiles[0].getPresentableUrl()});
                if (string == null) {
                    OperationStatusImpl.$$$reportNull$$$0(5);
                }
                return string;
            }
            throw new RuntimeException("No readonly files");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "readonlyFiles";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "readOnlyReason";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/readOnlyHandler/ReadonlyStatusHandlerImpl$OperationStatusImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/readOnlyHandler/ReadonlyStatusHandlerImpl$OperationStatusImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReadonlyFiles";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReadonlyFilesMessage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class State {
        public boolean SHOW_DIALOG = true;
    }
}

