/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.service.project.ExternalLibraryPathTypeMapper;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractProjectDataService;
import com.intellij.openapi.externalSystem.service.project.manage.ProjectStructureUIModifiableModelsProvider;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemConstants;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Order(value=-2147483628)
public final class LibraryDataService
extends AbstractProjectDataService<LibraryData, Library> {
    private static final Logger LOG = Logger.getInstance(LibraryDataService.class);
    @NotNull
    public static final NotNullFunction<String, File> PATH_TO_FILE = path -> new File((String)path);

    @NotNull
    public Key<LibraryData> getTargetDataKey() {
        Key key = ProjectKeys.LIBRARY;
        if (key == null) {
            LibraryDataService.$$$reportNull$$$0(0);
        }
        return key;
    }

    public void importData(@NotNull Collection<DataNode<LibraryData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            LibraryDataService.$$$reportNull$$$0(1);
        }
        if (project == null) {
            LibraryDataService.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            LibraryDataService.$$$reportNull$$$0(3);
        }
        HashMap<String, LibraryData> processedLibraries = new HashMap<String, LibraryData>();
        for (DataNode<LibraryData> dataNode : toImport) {
            LibraryData libraryData = (LibraryData)dataNode.getData();
            String libraryName = libraryData.getInternalName();
            LibraryData importedLibrary = processedLibraries.putIfAbsent(libraryName, libraryData);
            if (importedLibrary == null) {
                this.importLibrary(libraryData, modelsProvider);
                continue;
            }
            LOG.warn("Multiple project level libraries found with the same name '" + libraryName + "'");
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Chosen library:" + importedLibrary.getPaths(LibraryPathType.BINARY));
            LOG.debug("Ignored library:" + libraryData.getPaths(LibraryPathType.BINARY));
        }
    }

    private void importLibrary(@NotNull LibraryData toImport, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            LibraryDataService.$$$reportNull$$$0(4);
        }
        if (modelsProvider == null) {
            LibraryDataService.$$$reportNull$$$0(5);
        }
        Map<OrderRootType, Collection<File>> libraryFiles = this.prepareLibraryFiles(toImport);
        String libraryName = toImport.getInternalName();
        Library library = modelsProvider.getLibraryByName(libraryName);
        if (library != null) {
            LibraryDataService.syncPaths(toImport, library, modelsProvider);
            return;
        }
        library = modelsProvider.createLibrary(libraryName, ExternalSystemApiUtil.toExternalSource((ProjectSystemId)toImport.getOwner()));
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(library);
        LibraryDataService.registerPaths(toImport.isUnresolved(), libraryFiles, libraryModel, libraryName);
    }

    @NotNull
    public Map<OrderRootType, Collection<File>> prepareLibraryFiles(@NotNull LibraryData data) {
        if (data == null) {
            LibraryDataService.$$$reportNull$$$0(6);
        }
        HashMap<OrderRootType, Collection<File>> result2 = new HashMap<OrderRootType, Collection<File>>();
        for (LibraryPathType pathType : LibraryPathType.values()) {
            Set paths = data.getPaths(pathType);
            if (paths.isEmpty()) continue;
            result2.put(ExternalLibraryPathTypeMapper.getInstance().map(pathType), ContainerUtil.map((Collection)paths, PATH_TO_FILE));
        }
        HashMap<OrderRootType, Collection<File>> hashMap = result2;
        if (hashMap == null) {
            LibraryDataService.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    static void registerPaths(boolean unresolved, @NotNull Map<OrderRootType, Collection<File>> libraryFiles, @NotNull Library.ModifiableModel model2, @NotNull String libraryName) {
        if (libraryFiles == null) {
            LibraryDataService.$$$reportNull$$$0(8);
        }
        if (model2 == null) {
            LibraryDataService.$$$reportNull$$$0(9);
        }
        if (libraryName == null) {
            LibraryDataService.$$$reportNull$$$0(10);
        }
        for (Map.Entry<OrderRootType, Collection<File>> entry : libraryFiles.entrySet()) {
            for (File file2 : entry.getValue()) {
                VirtualFile virtualFile;
                VirtualFile virtualFile2 = virtualFile = unresolved ? null : ExternalSystemUtil.refreshAndFindFileByIoFile(file2);
                if (virtualFile == null) {
                    String[] urls;
                    String url;
                    if (!unresolved && ExternalSystemConstants.VERBOSE_PROCESSING && entry.getKey() == OrderRootType.CLASSES) {
                        LOG.warn(String.format("Can't find %s of the library '%s' at path '%s'", entry.getKey(), libraryName, file2.getAbsolutePath()));
                    }
                    if (ArrayUtil.contains((String)(url = VfsUtil.getUrlForLibraryRoot((File)file2)), (String[])(urls = model2.getUrls(entry.getKey())))) continue;
                    model2.addRoot(url, entry.getKey());
                    continue;
                }
                if (virtualFile.isDirectory()) {
                    Object[] files2 = model2.getFiles(entry.getKey());
                    if (ArrayUtil.contains((Object)virtualFile, (Object[])files2)) continue;
                    model2.addRoot(virtualFile, entry.getKey());
                    continue;
                }
                VirtualFile root = virtualFile;
                if (virtualFile.getFileType() instanceof ArchiveFileType && (root = JarFileSystem.getInstance().getJarRootForLocalFile(virtualFile)) == null) {
                    LOG.warn(String.format("Can't parse contents of the JAR file at path '%s' for the library '%s''", file2.getAbsolutePath(), libraryName));
                    continue;
                }
                Object[] files3 = model2.getFiles(entry.getKey());
                if (ArrayUtil.contains((Object)root, (Object[])files3)) continue;
                model2.addRoot(root, entry.getKey());
            }
        }
    }

    public void postProcess(@NotNull Collection<DataNode<LibraryData>> toImport, @Nullable ProjectData projectData, @NotNull Project project, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            LibraryDataService.$$$reportNull$$$0(11);
        }
        if (project == null) {
            LibraryDataService.$$$reportNull$$$0(12);
        }
        if (modelsProvider == null) {
            LibraryDataService.$$$reportNull$$$0(13);
        }
        if (projectData == null) {
            return;
        }
        if (modelsProvider instanceof ProjectStructureUIModifiableModelsProvider) {
            return;
        }
        List orphanIdeLibraries = ContainerUtil.newSmartList();
        LibraryTable.ModifiableModel librariesModel = modelsProvider.getModifiableProjectLibrariesModel();
        final HashMap<String, Library> namesToLibs = new HashMap<String, Library>();
        final HashSet<Library> potentialOrphans = new HashSet<Library>();
        RootPolicy<Void> excludeUsedLibraries = new RootPolicy<Void>(){

            public Void visitLibraryOrderEntry(@NotNull LibraryOrderEntry ideDependency, Void value) {
                if (ideDependency == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ideDependency.isModuleLevel()) {
                    return null;
                }
                Library lib = ideDependency.getLibrary();
                if (lib == null) {
                    lib = (Library)namesToLibs.get(ideDependency.getLibraryName());
                }
                if (lib != null) {
                    potentialOrphans.remove(lib);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ideDependency", "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService$1", "visitLibraryOrderEntry"));
            }
        };
        for (Library library : librariesModel.getLibraries()) {
            if (!ExternalSystemApiUtil.isExternalSystemLibrary((Library)library, (ProjectSystemId)projectData.getOwner())) continue;
            namesToLibs.put(library.getName(), library);
            potentialOrphans.add(library);
        }
        for (Library library : modelsProvider.getModules()) {
            for (OrderEntry entry : modelsProvider.getOrderEntries((Module)library)) {
                entry.accept((RootPolicy)excludeUsedLibraries, null);
            }
        }
        for (Library lib : potentialOrphans) {
            if (modelsProvider.isSubstituted(lib.getName())) continue;
            orphanIdeLibraries.add(lib);
        }
        for (Library library : orphanIdeLibraries) {
            Library library2;
            String libraryName = library.getName();
            if (libraryName == null || (library2 = librariesModel.getLibraryByName(libraryName)) == null) continue;
            librariesModel.removeLibrary(library2);
        }
    }

    private static void syncPaths(@NotNull LibraryData externalLibrary, @NotNull Library ideLibrary, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (externalLibrary == null) {
            LibraryDataService.$$$reportNull$$$0(14);
        }
        if (ideLibrary == null) {
            LibraryDataService.$$$reportNull$$$0(15);
        }
        if (modelsProvider == null) {
            LibraryDataService.$$$reportNull$$$0(16);
        }
        if (externalLibrary.isUnresolved()) {
            return;
        }
        HashMap toRemove2 = new HashMap();
        HashMap<OrderRootType, HashSet> toAdd = new HashMap<OrderRootType, HashSet>();
        ExternalLibraryPathTypeMapper externalLibraryPathTypeMapper = ExternalLibraryPathTypeMapper.getInstance();
        for (LibraryPathType pathType : LibraryPathType.values()) {
            OrderRootType ideType = externalLibraryPathTypeMapper.map(pathType);
            HashSet toAddPerType = ContainerUtilRt.newHashSet((Iterable)externalLibrary.getPaths(pathType));
            toAdd.put(ideType, toAddPerType);
            if (pathType != LibraryPathType.BINARY && toAddPerType.isEmpty()) continue;
            HashSet<String> toRemovePerType = new HashSet<String>();
            toRemove2.put(ideType, toRemovePerType);
            for (VirtualFile ideFile : ideLibrary.getFiles(ideType)) {
                String idePath = ExternalSystemApiUtil.getLocalFileSystemPath((VirtualFile)ideFile);
                if (toAddPerType.remove(idePath)) continue;
                toRemovePerType.add(ideFile.getUrl());
            }
        }
        if (toRemove2.isEmpty() && toAdd.isEmpty()) {
            return;
        }
        Library.ModifiableModel libraryModel = modelsProvider.getModifiableLibraryModel(ideLibrary);
        for (Map.Entry entry : toRemove2.entrySet()) {
            for (String path : (Set)entry.getValue()) {
                libraryModel.removeRoot(path, (OrderRootType)entry.getKey());
            }
        }
        for (Map.Entry entry : toAdd.entrySet()) {
            HashMap<OrderRootType, Collection<File>> roots = new HashMap<OrderRootType, Collection<File>>();
            roots.put((OrderRootType)entry.getKey(), ContainerUtil.map((Collection)((Collection)entry.getValue()), PATH_TO_FILE));
            LibraryDataService.registerPaths(externalLibrary.isUnresolved(), roots, libraryModel, externalLibrary.getInternalName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService";
                break;
            }
            case 1: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFiles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalLibrary";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetDataKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/service/project/manage/LibraryDataService";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareLibraryFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "importData";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "importLibrary";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "prepareLibraryFiles";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerPaths";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "postProcess";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "syncPaths";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

