/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.LogEventsKt;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0001J\u0013\u0010\u001d\u001a\u00020\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001f\u001a\u00020\u0007H\u0016J\u0006\u0010 \u001a\u00020\u001aJ\u0006\u0010!\u001a\u00020\u0005J\u000e\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR&\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006$"}, d2={"Lcom/intellij/internal/statistic/eventLog/LogEventAction;", "", "id", "", "state", "", "count", "", "(Ljava/lang/String;ZI)V", "getCount", "()I", "setCount", "(I)V", "data", "", "getData", "()Ljava/util/Map;", "setData", "(Ljava/util/Map;)V", "getId", "()Ljava/lang/String;", "getState", "()Z", "setState", "(Z)V", "addData", "", "key", "value", "equals", "other", "hashCode", "increment", "isEventGroup", "shouldMerge", "next", "intellij.platform.ide.impl"})
public final class LogEventAction {
    @NotNull
    private Map<String, Object> data;
    @NotNull
    private final String id;
    private boolean state;
    private int count;

    @NotNull
    public final Map<String, Object> getData() {
        return this.data;
    }

    public final void setData(@NotNull Map<String, Object> map2) {
        Intrinsics.checkParameterIsNotNull(map2, (String)"<set-?>");
        this.data = map2;
    }

    public final void increment() {
        int n = this.count;
        this.count = n + 1;
    }

    public final boolean isEventGroup() {
        return this.count > 1;
    }

    public final boolean shouldMerge(@NotNull LogEventAction next) {
        Intrinsics.checkParameterIsNotNull((Object)next, (String)"next");
        if (this.state || next.state) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.id, (Object)next.id) ^ true) {
            return false;
        }
        return !(Intrinsics.areEqual(this.data, next.data) ^ true);
    }

    public final void addData(@NotNull String key, @NotNull Object value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        if (this.data.isEmpty()) {
            this.data = new HashMap();
        }
        Object escapedValue = value instanceof String ? LogEventsKt.escape((String)value) : value;
        this.data.put(LogEventsKt.escapeFieldName(key), escapedValue);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null) ^ true) {
            return false;
        }
        Object object2 = other;
        if (object2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.internal.statistic.eventLog.LogEventAction");
        }
        LogEventAction cfr_ignored_0 = (LogEventAction)object2;
        if (Intrinsics.areEqual((Object)this.id, (Object)((LogEventAction)other).id) ^ true) {
            return false;
        }
        if (this.count != ((LogEventAction)other).count) {
            return false;
        }
        return !(Intrinsics.areEqual(this.data, ((LogEventAction)other).data) ^ true);
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = 31 * result2 + this.count;
        result2 = 31 * result2 + ((Object)this.data).hashCode();
        return result2;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final boolean getState() {
        return this.state;
    }

    public final void setState(boolean bl) {
        this.state = bl;
    }

    public final int getCount() {
        return this.count;
    }

    public final void setCount(int n) {
        this.count = n;
    }

    public LogEventAction(@NotNull String id, boolean state, int count) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        this.id = id;
        this.state = state;
        this.count = count;
        Map map2 = Collections.emptyMap();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"Collections.emptyMap()");
        this.data = map2;
    }

    public /* synthetic */ LogEventAction(String string, boolean bl, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        this(string, bl, n);
    }
}

