/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus.ui;

import com.intellij.ide.GeneralSettings;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UiInfoUsageCollector
extends ApplicationUsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages() {
        Set<UsageDescriptor> set = UiInfoUsageCollector.getDescriptors();
        if (set == null) {
            UiInfoUsageCollector.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public static Set<UsageDescriptor> getDescriptors() {
        THashSet set = new THashSet();
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Nav.Bar.visible", UiInfoUsageCollector.navbar() ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Nav.Bar.floating", UiInfoUsageCollector.navbar() ? 0 : 1);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Toolbar.visible", UiInfoUsageCollector.toolbar() ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Toolbar.hidden", UiInfoUsageCollector.toolbar() ? 0 : 1);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Toolbar.and.NavBar", !UiInfoUsageCollector.toolbar() && UiInfoUsageCollector.navbar() ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Toolbar.and.NavBar.hidden", !UiInfoUsageCollector.toolbar() && !UiInfoUsageCollector.navbar() ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Status.bar.visible", UiInfoUsageCollector.status() ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Status.bar.hidden", UiInfoUsageCollector.status() ? 0 : 1);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Tool.Window.buttons.visible", UiInfoUsageCollector.stripes() ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Tool.Window.buttons.hidden", UiInfoUsageCollector.stripes() ? 0 : 1);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Recent.Files[15]", UiInfoUsageCollector.recent() == 15 ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Recent.Files[15_30]", 15 < UiInfoUsageCollector.recent() && UiInfoUsageCollector.recent() < 31 ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Recent.Files[30_50]", 30 < UiInfoUsageCollector.recent() && UiInfoUsageCollector.recent() < 51 ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Recent.Files[more.than.50]", 50 < UiInfoUsageCollector.recent() ? 1 : 0);
        set.add(new UsageDescriptor("recent.files", 1, new FeatureUsageData().addData("grouped", UiInfoUsageCollector.recentPeriod(UiInfoUsageCollector.recent()))));
        UISettings ui = UISettings.getInstance();
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Show.Editor.Tabs.In.Single.Row", ui.getScrollTabLayoutInEditor() ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Hide.Editor.Tabs.If.Needed", ui.getScrollTabLayoutInEditor() && ui.getHideTabsIfNeeded() ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Block.cursor", EditorSettingsExternalizable.getInstance().isBlockCursor() ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Line.Numbers", EditorSettingsExternalizable.getInstance().isLineNumbersShown() ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Gutter.Icons", EditorSettingsExternalizable.getInstance().areGutterIconsShown() ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Soft.Wraps", EditorSettingsExternalizable.getInstance().isUseSoftWraps() ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Tabs.None", UiInfoUsageCollector.tabPlace() == 0 ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Tabs.Top", UiInfoUsageCollector.tabPlace() == 1 ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Tabs.Bottom", UiInfoUsageCollector.tabPlace() == 3 ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Tabs.Left", UiInfoUsageCollector.tabPlace() == 2 ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Tabs.Right", UiInfoUsageCollector.tabPlace() == 4 ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Retina", UIUtil.isRetina() ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "Show.tips.on.startup", GeneralSettings.getInstance().isShowTipsOnStartup() ? 1 : 0);
        set.add(StatisticsUtilKt.getBooleanUsage("Allow.merging.buttons", ui.getAllowMergeButtons()));
        PropertiesComponent properties = PropertiesComponent.getInstance();
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "QuickDoc.Show.Toolwindow", properties.isTrueValue("ShowDocumentationInToolWindow") ? 1 : 0);
        UiInfoUsageCollector.add((Set<? super UsageDescriptor>)set, "QuickDoc.AutoUpdate", properties.getBoolean("DocumentationAutoUpdateEnabled", true) ? 1 : 0);
        THashSet tHashSet = set;
        if (tHashSet == null) {
            UiInfoUsageCollector.$$$reportNull$$$0(1);
        }
        return tHashSet;
    }

    @Override
    public int getVersion() {
        return 2;
    }

    private static String recentPeriod(int recent) {
        if (recent < 15) {
            return "less.than.15";
        }
        if (16 < recent && recent < 31) {
            return "[15_30]";
        }
        if (30 < recent && recent < 51) {
            return "[30_50]";
        }
        return "[more.than.50]";
    }

    @Override
    @NotNull
    public String getGroupId() {
        if ("ui.info.features" == null) {
            UiInfoUsageCollector.$$$reportNull$$$0(2);
        }
        return "ui.info.features";
    }

    private static void add(Set<? super UsageDescriptor> set, String key, int value) {
        set.add(new UsageDescriptor(key, value));
    }

    private static int tabPlace() {
        return UISettings.getInstance().getEditorTabPlacement();
    }

    private static int recent() {
        return UISettings.getInstance().getRecentFilesLimit();
    }

    private static boolean stripes() {
        return UISettings.getInstance().getHideToolStripes();
    }

    private static boolean status() {
        return UISettings.getInstance().getShowStatusBar();
    }

    private static boolean toolbar() {
        return UISettings.getInstance().getShowMainToolbar();
    }

    private static boolean navbar() {
        return UISettings.getInstance().getShowNavigationBar();
    }

    @Override
    @Nullable
    public FeatureUsageData getData() {
        return new FeatureUsageData().addOS();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/internal/statistic/collectors/fus/ui/UiInfoUsageCollector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptors";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

