/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.ide.CliResult;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.MultiMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.MessageDecoder;

public final class SocketLock {
    private static final String PORT_FILE = "port";
    private static final String PORT_LOCK_FILE = "port.lock";
    private static final String TOKEN_FILE = "token";
    private static final String ACTIVATE_COMMAND = "activate ";
    private static final String PID_COMMAND = "pid";
    private static final String PATHS_EOT_RESPONSE = "---";
    private static final String OK_RESPONSE = "ok";
    private final String myConfigPath;
    private final String mySystemPath;
    private final AtomicReference<CliRequestProcessor> myActivateListener;
    private String myToken;
    private BuiltInServer myServer;

    public SocketLock(@NotNull String configPath, @NotNull String systemPath) {
        if (configPath == null) {
            SocketLock.$$$reportNull$$$0(0);
        }
        if (systemPath == null) {
            SocketLock.$$$reportNull$$$0(1);
        }
        this.myActivateListener = new AtomicReference();
        this.myConfigPath = SocketLock.canonicalPath(configPath);
        this.mySystemPath = SocketLock.canonicalPath(systemPath);
        if (FileUtil.pathsEqual((String)this.myConfigPath, (String)this.mySystemPath)) {
            throw new IllegalArgumentException("'config' and 'system' paths should point to different directories");
        }
    }

    public void setExternalInstanceListener(@Nullable CliRequestProcessor processor2) {
        this.myActivateListener.set(processor2);
    }

    public void dispose() {
        SocketLock.log("enter: dispose()", new Object[0]);
        BuiltInServer server = this.myServer;
        if (server == null) {
            return;
        }
        try {
            Disposer.dispose((Disposable)server);
        }
        finally {
            try {
                this.underLocks(() -> {
                    FileUtil.delete((File)new File(this.myConfigPath, PORT_FILE));
                    FileUtil.delete((File)new File(this.mySystemPath, PORT_FILE));
                    FileUtil.delete((File)new File(this.mySystemPath, TOKEN_FILE));
                    return null;
                });
            }
            catch (Exception e) {
                Logger.getInstance(SocketLock.class).warn((Throwable)e);
            }
        }
    }

    @Nullable
    public BuiltInServer getServer() {
        return this.myServer;
    }

    @NotNull
    public ActivateStatusAndResponse lock() throws Exception {
        ActivateStatusAndResponse activateStatusAndResponse = this.lock(ArrayUtilRt.EMPTY_STRING_ARRAY);
        if (activateStatusAndResponse == null) {
            SocketLock.$$$reportNull$$$0(2);
        }
        return activateStatusAndResponse;
    }

    @NotNull
    public ActivateStatusAndResponse lock(@NotNull String[] args) throws Exception {
        if (args == null) {
            SocketLock.$$$reportNull$$$0(3);
        }
        SocketLock.log("enter: lock(config=%s system=%s)", this.myConfigPath, this.mySystemPath);
        ActivateStatusAndResponse activateStatusAndResponse = this.underLocks(() -> {
            File portMarkerC = new File(this.myConfigPath, PORT_FILE);
            File portMarkerS = new File(this.mySystemPath, PORT_FILE);
            MultiMap portToPath = MultiMap.createSmart();
            SocketLock.addExistingPort(portMarkerC, this.myConfigPath, (MultiMap<Integer, String>)portToPath);
            SocketLock.addExistingPort(portMarkerS, this.mySystemPath, (MultiMap<Integer, String>)portToPath);
            if (!portToPath.isEmpty()) {
                for (Map.Entry entry : portToPath.entrySet()) {
                    ActivateStatusAndResponse status = this.tryActivate((Integer)entry.getKey(), (Collection)entry.getValue(), args);
                    if (status.getActivateStatus() == ActivateStatus.NO_INSTANCE) continue;
                    SocketLock.log("exit: lock(): " + (Object)((Object)status.getActivateStatus()), new Object[0]);
                    return status;
                }
            }
            if (SocketLock.isShutdownCommand()) {
                System.exit(0);
            }
            this.myToken = UUID.randomUUID().toString();
            String[] lockedPaths = new String[]{this.myConfigPath, this.mySystemPath};
            this.myServer = BuiltInServer.startNioOrOio((int)BuiltInServer.getRecommendedWorkerCount(), (int)6942, (int)50, (boolean)false, () -> new MyChannelInboundHandler(lockedPaths, this.myActivateListener, this.myToken));
            byte[] portBytes = Integer.toString(this.myServer.getPort()).getBytes(StandardCharsets.UTF_8);
            FileUtil.writeToFile((File)portMarkerC, (byte[])portBytes);
            FileUtil.writeToFile((File)portMarkerS, (byte[])portBytes);
            Path tokenFile = Paths.get(this.mySystemPath, TOKEN_FILE);
            Files.write(tokenFile, this.myToken.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            PosixFileAttributeView view = Files.getFileAttributeView(tokenFile, PosixFileAttributeView.class, new LinkOption[0]);
            if (view != null) {
                try {
                    view.setPermissions(EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
                }
                catch (IOException e) {
                    SocketLock.log(e);
                }
            }
            SocketLock.log("exit: lock(): succeed", new Object[0]);
            return ActivateStatusAndResponse.emptyResponse(ActivateStatus.NO_INSTANCE);
        });
        if (activateStatusAndResponse == null) {
            SocketLock.$$$reportNull$$$0(4);
        }
        return activateStatusAndResponse;
    }

    /*
     * Exception decompiling
     */
    private <V> V underLocks(@NotNull Callable<V> action) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void addExistingPort(@NotNull File portMarker, @NotNull String path, @NotNull MultiMap<Integer, String> portToPath) {
        if (portMarker == null) {
            SocketLock.$$$reportNull$$$0(6);
        }
        if (path == null) {
            SocketLock.$$$reportNull$$$0(7);
        }
        if (portToPath == null) {
            SocketLock.$$$reportNull$$$0(8);
        }
        if (portMarker.exists()) {
            try {
                portToPath.putValue((Object)Integer.parseInt(FileUtilRt.loadFile((File)portMarker)), (Object)path);
            }
            catch (Exception e) {
                SocketLock.log(e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private ActivateStatusAndResponse tryActivate(int portNumber, @NotNull Collection<String> paths, @NotNull String[] args) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void printPID(int port) {
        try {
            Socket socket = new Socket(InetAddress.getLoopbackAddress(), port);
            socket.setSoTimeout(1000);
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            out.writeUTF(PID_COMMAND);
            DataInputStream in = new DataInputStream(socket.getInputStream());
            int pid = 0;
            try {
                while (true) {
                    String s;
                    if (!Pattern.matches("[0-9]+@.*", s = in.readUTF())) {
                        continue;
                    }
                    pid = Integer.parseInt(s.substring(0, s.indexOf(64)));
                    System.err.println(pid);
                }
            }
            catch (IOException e) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isShutdownCommand() {
        return "shutdown".equals(JetBrainsProtocolHandler.getCommand());
    }

    private static String[] checkForJetBrainsProtocolCommand(String[] args) {
        String jbUrl = System.getProperty(JetBrainsProtocolHandler.class.getName());
        if (jbUrl != null) {
            return new String[]{jbUrl};
        }
        return args;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sendStringSequence(ChannelHandlerContext context, List<String> strings) throws IOException {
        ByteBuf buffer = context.alloc().ioBuffer(1024);
        boolean success = false;
        try (ByteBufOutputStream out = new ByteBufOutputStream(buffer);){
            for (String s : strings) {
                out.writeUTF(s);
            }
            out.writeUTF(PATHS_EOT_RESPONSE);
            success = true;
        }
        finally {
            if (!success) {
                buffer.release();
            }
        }
        context.writeAndFlush((Object)buffer);
    }

    @NotNull
    private static List<String> readStringSequence(DataInputStream in) {
        ArrayList<String> result2 = new ArrayList<String>();
        try {
            while (true) {
                String string = in.readUTF();
                SocketLock.log("read: path=%s", string);
                if (!PATHS_EOT_RESPONSE.equals(string)) {
                    result2.add(string);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            SocketLock.log("read: %s", e.getMessage());
        }
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            SocketLock.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    @NotNull
    private static CliResult mapResponseToCliResult(@NotNull List<String> responseParts) throws IllegalArgumentException {
        int code;
        if (responseParts == null) {
            SocketLock.$$$reportNull$$$0(15);
        }
        if (responseParts.size() > 3 || responseParts.size() < 2) {
            throw new IllegalArgumentException("bad response: " + StringUtil.join(responseParts, (String)";"));
        }
        try {
            code = Integer.parseInt(responseParts.get(1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Second part is not a parsable return code", e);
        }
        String message = responseParts.size() == 3 ? responseParts.get(2) : null;
        CliResult cliResult = new CliResult(code, message);
        if (cliResult == null) {
            SocketLock.$$$reportNull$$$0(16);
        }
        return cliResult;
    }

    @NotNull
    private static String canonicalPath(@NotNull String configPath) {
        String string;
        if (configPath == null) {
            SocketLock.$$$reportNull$$$0(17);
        }
        try {
            string = new File(configPath).getCanonicalPath();
        }
        catch (IOException ignore) {
            String string2 = configPath;
            if (string2 == null) {
                SocketLock.$$$reportNull$$$0(19);
            }
            return string2;
        }
        if (string == null) {
            SocketLock.$$$reportNull$$$0(18);
        }
        return string;
    }

    private static void log(Exception e) {
        Logger.getInstance(SocketLock.class).warn((Throwable)e);
    }

    private static void log(String format, Object ... args) {
        Logger logger = Logger.getInstance(SocketLock.class);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format(format, args));
        }
    }

    static /* synthetic */ void access$100(Exception x0) {
        SocketLock.log(x0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemPath";
                break;
            }
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/idea/SocketLock";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "portMarker";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "portToPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "responseParts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/idea/SocketLock";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "lock";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "tryActivate";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "readStringSequence";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "mapResponseToCliResult";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "lock";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "underLocks";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addExistingPort";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryActivate";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "mapResponseToCliResult";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "canonicalPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ActivateStatusAndResponse {
        @NotNull
        private final ActivateStatus myActivateStatus;
        @Nullable
        private final CliResult myResponse;

        public ActivateStatusAndResponse(@NotNull ActivateStatus status, @Nullable CliResult response) {
            if (status == null) {
                ActivateStatusAndResponse.$$$reportNull$$$0(0);
            }
            this.myActivateStatus = status;
            this.myResponse = response;
        }

        @NotNull
        public static ActivateStatusAndResponse emptyResponse(@NotNull ActivateStatus status) {
            if (status == null) {
                ActivateStatusAndResponse.$$$reportNull$$$0(1);
            }
            ActivateStatusAndResponse activateStatusAndResponse = new ActivateStatusAndResponse(status, null);
            if (activateStatusAndResponse == null) {
                ActivateStatusAndResponse.$$$reportNull$$$0(2);
            }
            return activateStatusAndResponse;
        }

        @NotNull
        public ActivateStatus getActivateStatus() {
            ActivateStatus activateStatus = this.myActivateStatus;
            if (activateStatus == null) {
                ActivateStatusAndResponse.$$$reportNull$$$0(3);
            }
            return activateStatus;
        }

        @Nullable
        public CliResult getResponse() {
            return this.myResponse;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "status";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/idea/SocketLock$ActivateStatusAndResponse";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/idea/SocketLock$ActivateStatusAndResponse";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "emptyResponse";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActivateStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "emptyResponse";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyChannelInboundHandler
    extends MessageDecoder {
        private final String[] myLockedPaths;
        private final AtomicReference<? extends CliRequestProcessor> myActivateListener;
        private final String myToken;
        private State myState;

        MyChannelInboundHandler(@NotNull String[] lockedPaths, @NotNull AtomicReference<? extends CliRequestProcessor> activateListener, @NotNull String token) {
            if (lockedPaths == null) {
                MyChannelInboundHandler.$$$reportNull$$$0(0);
            }
            if (activateListener == null) {
                MyChannelInboundHandler.$$$reportNull$$$0(1);
            }
            if (token == null) {
                MyChannelInboundHandler.$$$reportNull$$$0(2);
            }
            this.myState = State.HEADER;
            this.myLockedPaths = lockedPaths;
            this.myActivateListener = activateListener;
            this.myToken = token;
        }

        public void channelActive(ChannelHandlerContext context) throws Exception {
            SocketLock.sendStringSequence(context, Arrays.asList(this.myLockedPaths));
        }

        /*
         * Unable to fully structure code
         */
        protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull ByteBuf input) throws Exception {
            if (context == null) {
                MyChannelInboundHandler.$$$reportNull$$$0(3);
            }
            if (input == null) {
                MyChannelInboundHandler.$$$reportNull$$$0(4);
            }
            while (true) {
                switch (1.$SwitchMap$com$intellij$idea$SocketLock$MyChannelInboundHandler$State[this.myState.ordinal()]) {
                    case 1: {
                        buffer = this.getBufferIfSufficient(input, 2, context);
                        if (buffer == null) {
                            return;
                        }
                        this.contentLength = buffer.readUnsignedShort();
                        if (this.contentLength > 8192) {
                            context.close();
                            return;
                        }
                        this.myState = State.CONTENT;
                        break;
                    }
                    case 2: {
                        command = this.readChars(input);
                        if (command == null) {
                            return;
                        }
                        if (!StringUtil.startsWith((CharSequence)command, (CharSequence)"pid")) ** GOTO lbl46
                        buffer = context.alloc().ioBuffer();
                        out = new ByteBufOutputStream(buffer);
                        var6_6 = null;
                        try {
                            name = ManagementFactory.getRuntimeMXBean().getName();
                            out.writeUTF(name);
                        }
                        catch (Throwable name) {
                            var6_6 = name;
                            throw name;
                        }
                        finally {
                            if (out != null) {
                                if (var6_6 != null) {
                                    try {
                                        out.close();
                                    }
                                    catch (Throwable name) {
                                        var6_6.addSuppressed(name);
                                    }
                                } else {
                                    out.close();
                                }
                            }
                        }
                        context.writeAndFlush((Object)buffer);
lbl46:
                        // 2 sources

                        if (StringUtil.startsWith((CharSequence)command, (CharSequence)"activate ")) {
                            args = StringUtil.split((String)data, (String)((data = command.subSequence("activate ".length(), command.length()).toString()).contains("\u0000") != false ? "\u0000" : "\ufffd"));
                            v0 = tokenOK = args.isEmpty() == false && this.myToken.equals(args.get(0)) != false;
                            if (!tokenOK) {
                                SocketLock.access$100(new UnsupportedOperationException("unauthorized request: " + command));
                                Notifications.Bus.notify((Notification)new Notification("System Messages", IdeBundle.message((String)"activation.auth.title", (Object[])new Object[0]), IdeBundle.message((String)"activation.auth.message", (Object[])new Object[0]), NotificationType.WARNING));
                                result = new CliResult(13, IdeBundle.message((String)"activation.auth.message", (Object[])new Object[0]));
                            } else {
                                listener = this.myActivateListener.get();
                                result = listener != null ? CliResult.getOrWrapFailure(listener.process(args.subList(1, args.size())), (int)15) : new CliResult(14, IdeBundle.message((String)"activation.not.initialized", (Object[])new Object[0]));
                            }
                            SocketLock.access$000(context, Stream.of(new String[]{"ok", String.valueOf(result.getReturnCode()), result.getMessage()}).filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, nonNull(java.lang.Object ), (Ljava/lang/String;)Z)()).collect(Collectors.toList()));
                        }
                        context.close();
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lockedPaths";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activateListener";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = SocketLock.TOKEN_FILE;
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/idea/SocketLock$MyChannelInboundHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "messageReceived";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static enum State {
            HEADER,
            CONTENT;

        }
    }

    @FunctionalInterface
    public static interface CliRequestProcessor {
        public Future<? extends CliResult> process(@NotNull List<String> var1);
    }

    public static enum ActivateStatus {
        ACTIVATED,
        NO_INSTANCE,
        CANNOT_ACTIVATE;

    }
}

