/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.services;

import com.intellij.execution.services.ServiceModel;
import com.intellij.execution.services.ServiceView;
import com.intellij.ide.DeleteProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

class ServiceViewDeleteProvider
implements DeleteProvider {
    private final ServiceView myServiceView;

    ServiceViewDeleteProvider(@NotNull ServiceView serviceView) {
        if (serviceView == null) {
            ServiceViewDeleteProvider.$$$reportNull$$$0(0);
        }
        this.myServiceView = serviceView;
    }

    public void deleteElement(@NotNull DataContext dataContext) {
        Project project;
        if (dataContext == null) {
            ServiceViewDeleteProvider.$$$reportNull$$$0(1);
        }
        if ((project = (Project)dataContext.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        List<Pair<ServiceModel.ServiceViewItem, Runnable>> items = ContainerUtil.mapNotNull(this.myServiceView.getSelectedItems(), item -> {
            Runnable remover = item.getViewDescriptor().getRemover();
            return remover == null ? null : Pair.create((Object)item, (Object)remover);
        });
        if ((items = ServiceViewDeleteProvider.filterChildren(items)).isEmpty()) {
            return;
        }
        int size = items.size();
        if (Messages.showYesNoDialog((Project)project, (String)("Delete " + size + " " + StringUtil.pluralize((String)"item", (int)size) + "?"), (String)"Delete", (Icon)Messages.getWarningIcon()) != 0) {
            return;
        }
        for (Pair<ServiceModel.ServiceViewItem, Runnable> item2 : items) {
            ((Runnable)item2.second).run();
        }
    }

    public boolean canDeleteElement(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            ServiceViewDeleteProvider.$$$reportNull$$$0(2);
        }
        if (this.myServiceView.getSelectedItems().stream().noneMatch(item -> item.getViewDescriptor().getRemover() != null)) {
            return false;
        }
        JComponent detailsComponent = this.myServiceView.getUi().getDetailsComponent();
        return detailsComponent == null || !UIUtil.isAncestor((Component)detailsComponent, (Component)((Component)dataContext.getData(PlatformDataKeys.CONTEXT_COMPONENT)));
    }

    @NotNull
    private static List<Pair<ServiceModel.ServiceViewItem, Runnable>> filterChildren(List<Pair<ServiceModel.ServiceViewItem, Runnable>> items) {
        List list2 = ContainerUtil.filter(items, item -> {
            for (ServiceModel.ServiceViewItem parent = ((ServiceModel.ServiceViewItem)item.first).getParent(); parent != null; parent = parent.getParent()) {
                for (Pair pair : items) {
                    if (!((ServiceModel.ServiceViewItem)pair.first).equals(parent)) continue;
                    return false;
                }
            }
            return true;
        });
        if (list2 == null) {
            ServiceViewDeleteProvider.$$$reportNull$$$0(3);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceView";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/services/ServiceViewDeleteProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/services/ServiceViewDeleteProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteElement";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

